---
mapped_pages:
  - https://www.elastic.co/guide/en/elasticsearch/client/php-api/current/configuration.html
---

# Configuration [configuration]

Almost every aspect of the client is configurable. Most users only need to configure a few parameters to suit their needs, but it is possible to completely replace much of the internals if required.

Custom configuration is accomplished before the client is instantiated, through the `ClientBuilder` class. You can find all the configuration options and check sample code that helps you replace the various components.

To learn more about JSON in PHP, read [Dealing with JSON arrays and objects in PHP](/reference/php_json_objects.md).

* [Host Configuration](/reference/host-config.md)
* [Set retries](/reference/set-retries.md)
* [HTTP Meta Data](/reference/http-meta-data.md)
* [Enabling the Logger](/reference/enabling_logger.md)
* [Configure the HTTP client](/reference/http-client.md)
* [Namespaces](/reference/namespaces.md)
* [Node Pool](/reference/node_pool.md)
* [Building the client from a configuration hash](/reference/node_pool.md#config-hash)









