/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import net.sourceforge.plantuml.project.Failable;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.lang.DayPattern;
import net.sourceforge.plantuml.project.lang.Something;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOr;
import net.sourceforge.plantuml.regex.RegexResult;

public class ComplementDate
implements Something<GanttDiagram> {
    private final Type type;

    private ComplementDate(Type type) {
        this.type = type;
    }

    public static ComplementDate any() {
        return new ComplementDate(Type.ANY);
    }

    public static ComplementDate onlyRelative() {
        return new ComplementDate(Type.ONLY_RELATIVE);
    }

    public static ComplementDate onlyAbsolute() {
        return new ComplementDate(Type.ONLY_ABSOLUTE);
    }

    @Override
    public IRegex toRegex(String suffix) {
        DayPattern dayPattern = new DayPattern(suffix);
        switch (this.type) {
            case ONLY_ABSOLUTE: {
                return dayPattern.toRegex();
            }
            case ONLY_RELATIVE: {
                return new RegexOr(this.toRegexD(suffix), this.toRegexE(suffix));
            }
        }
        return new RegexOr(dayPattern.toRegex(), this.toRegexD(suffix), this.toRegexE(suffix));
    }

    private IRegex toRegexD(String suffix) {
        return new RegexConcat(new RegexLeaf(1, "DCOUNT" + suffix, "([\\d]+)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("days?"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("after"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("start"));
    }

    private IRegex toRegexE(String suffix) {
        return new RegexConcat(new RegexLeaf("[dD]\\+"), new RegexLeaf(1, "ECOUNT" + suffix, "([\\d]+)"));
    }

    @Override
    public Failable<Day> getMe(GanttDiagram system, RegexResult arg, String suffix) {
        DayPattern dayPattern = new DayPattern(suffix);
        Day result = dayPattern.getDay(arg);
        if (result != null) {
            return Failable.ok(result);
        }
        if (arg.get("DCOUNT" + suffix, 0) != null) {
            return Failable.ok(this.resultD(system, arg, suffix));
        }
        if (arg.get("ECOUNT" + suffix, 0) != null) {
            return Failable.ok(this.resultE(system, arg, suffix));
        }
        throw new IllegalStateException();
    }

    private Day resultD(GanttDiagram system, RegexResult arg, String suffix) {
        int day = Integer.parseInt(arg.get("DCOUNT" + suffix, 0));
        return system.getStartingDate().addDays(day);
    }

    private Day resultE(GanttDiagram system, RegexResult arg, String suffix) {
        int day = Integer.parseInt(arg.get("ECOUNT" + suffix, 0));
        return system.getStartingDate().addDays(day);
    }

    static enum Type {
        ANY,
        ONLY_RELATIVE,
        ONLY_ABSOLUTE;

    }
}

