/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.data;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.PortLabelPlacement;
import org.eclipse.elk.core.options.SizeOptions;
import org.eclipse.elk.core.util.IGraphElementVisitor;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.properties.IProperty;

public class DeprecatedLayoutOptionReplacer
implements IGraphElementVisitor {
    private static final Consumer<ElkGraphElement> NEXT_TO_PORT_IF_POSSIBLE = e -> {
        e.getProperty(CoreOptions.PORT_LABELS_PLACEMENT).add(PortLabelPlacement.NEXT_TO_PORT_IF_POSSIBLE);
        e.setProperty(CoreOptions.PORT_LABELS_NEXT_TO_PORT_IF_POSSIBLE, null);
    };
    private static final Consumer<ElkGraphElement> SPACE_EFFICIENT = e -> {
        if (e.getProperty(CoreOptions.NODE_SIZE_OPTIONS).contains((Object)SizeOptions.SPACE_EFFICIENT_PORT_LABELS)) {
            e.getProperty(CoreOptions.PORT_LABELS_PLACEMENT).add(PortLabelPlacement.SPACE_EFFICIENT);
            e.getProperty(CoreOptions.NODE_SIZE_OPTIONS).remove((Object)SizeOptions.SPACE_EFFICIENT_PORT_LABELS);
        }
    };
    public static final Map<IProperty<?>, Consumer<ElkGraphElement>> RULES = ImmutableMap.of(CoreOptions.PORT_LABELS_NEXT_TO_PORT_IF_POSSIBLE, NEXT_TO_PORT_IF_POSSIBLE, CoreOptions.NODE_SIZE_OPTIONS, SPACE_EFFICIENT);

    @Override
    public void visit(ElkGraphElement element) {
        RULES.forEach((option, replacer) -> {
            if (element.hasProperty((IProperty<?>)option)) {
                replacer.accept(element);
            }
        });
    }
}

