/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.Char;
import org.scilab.forge.jlatexmath.CharBox;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.VerticalBox;

public class OgonekAtom
extends Atom {
    private Atom base;

    public OgonekAtom(Atom base) {
        this.base = base;
    }

    @Override
    public Box createBox(TeXEnvironment env) {
        Box y;
        Box b = this.base.createBox(env);
        VerticalBox vb = new VerticalBox();
        vb.add(b);
        Char ch = env.getTeXFont().getChar("ogonek", env.getStyle());
        float italic = ch.getItalic();
        CharBox ogonek = new CharBox(ch);
        if (Math.abs(italic) > 1.0E-7f) {
            y = new HorizontalBox(new StrutBox(-italic, 0.0f, 0.0f, 0.0f));
            y.add(ogonek);
        } else {
            y = ogonek;
        }
        HorizontalBox og = new HorizontalBox(y, b.getWidth(), 1);
        vb.add(new StrutBox(0.0f, -ogonek.getHeight(), 0.0f, 0.0f));
        vb.add(og);
        float f = vb.getHeight() + vb.getDepth();
        vb.setHeight(b.getHeight());
        vb.setDepth(f - b.getHeight());
        return vb;
    }
}

