<?php
namespace Teknisa\Libs\Util;

use Doctrine\Common\Cache\ArrayCache;
use Zeedhi\Framework\Cache\Cache;

/**
 * Class ArrayNullCache
 *
 * Class to provide an implementation of Array Cache Driver,
 * returning null when no cache is provided.
 */
class ArrayNullCache extends ArrayCache implements Cache {
    public function save($key, $value, $lifeTime = 0) {
        return $this->doSave($key, $value, $lifeTime);
    }

    public function fetch($key) {
        $data = $this->doFetch($key);

        if($data === false) {
            return null;
        } else {
            return $data;
        }
    }

    public function delete($key) {
        return $this->doDelete($key);
    }
}