<?php

namespace Teknisa\Libs\Controller;

use Teknisa\Libs\Exception\CustomException;
use Teknisa\Libs\Util\Utilities;
use Teknisa\Libs\Util\InstanceProvider;
use Zeedhi\Framework\DTO\Request;
use Zeedhi\Framework\DTO\Response;
use Teknisa\Libs\Service\Layout as LayoutService;
use Teknisa\Libs\Traits\TResponse;
use Zeedhi\Framework\DataSource\DataSet;


class Layout {
    use TResponse;

    /** @var LayoutService $layoutService */
    private $layoutService;

    /**
     * @param LayoutService $layoutService
     */
    public function __construct(LayoutService $layoutService) {
        $this->layoutService = $layoutService;
    }

    /**
     * @param Request $request
     * @param Response $response
     * @throws \Exception
     */
    public function loadLayout(Request $request, Response $response) {
        try {
            $name = $request->getParameters()['id'];
            $return = $this->layoutService->loadLayout($name);
            $this->sendResponse($return, 200);
        } catch(\Exception $e) {
            $response->setError(new Response\Error($e->getMessage(), Response\Message::TYPE_ERROR));
        }
    }

    /**
     * @param Request $request
     * @param Response $response
     * @throws \Exception
     */
    public function saveLayout(Request $request, Response $response) {
        try {
            $layoutObject = $request->getParameters();
            $this->layoutService->saveLayout($layoutObject);
        } catch(\Exception $e) {
            $this->sendResponse(['error' => $e->getMessage(), 'code' => $e->getCode()], 500);
        }
    }

}
