<?php

namespace Teknisa\Libs\Controller;

use Teknisa\Libs\Exception\CustomException;
use Teknisa\Libs\Traits\TResponse;
use Teknisa\Libs\Util\InstanceProvider;
use Teknisa\Libs\Util\Utilities;
use Zeedhi\Framework\DTO\Request;
use Zeedhi\Framework\DTO\Response;
use Zeedhi\Framework\DTO\Response\Error;
use Zeedhi\Framework\DataSource\DataSet;
use Teknisa\Libs\Service\Menu as MenuService;


class Menu {
    use TResponse;

    /** @var  MenuService $menuService */
    private $menuService;

    /** @param MenuService $menuService */
    public function __construct(MenuService $menuService) {
        $this->menuService = $menuService;
    }

    /**
     * @param Request $request
     * @param Response $response
     */
    public function buildMenu(Request $request, Response $response) {
        try {
            $params = $request->getParameters();
            $visibleMenus = isset($params['VISIBLE_ELEMENTS']) ? $params['VISIBLE_ELEMENTS'] : null;
            $expiredMenus = isset($params['EXPIRED_ELEMENTS']) ? $params['EXPIRED_ELEMENTS'] : null;
            $menus = $this->menuService->buildMenu($visibleMenus, $expiredMenus);
            $this->sendResponse($menus, 200);
        } catch(CustomException $e) {
            $this->sendResponse(Utilities::getErrorObjectFromException($e), 500);
        }
    }
}
