<?php
namespace Teknisa\Libs\Service;

use Doctrine\DBAL\Exception;
use Teknisa\Libs\Util\InstanceProvider;
use Teknisa\Libs\Util\Environment;

class AclLabels
{
    /**
     * @var Environment
     */
    private $environment;
    /**
     * @var \Teknisa\Libs\Util\Repositories\AclLabels
     */
    private $accessProfileRepository;

    public function __construct(Environment $environment)
    {
        $this->environment = $environment;
        $this->accessProfileRepository = InstanceProvider::getLibAclLabelsRepository();
    }

    /**
     * @param array $nrperfilacesso
     * @return array[]
     * @throws Exception
     */
    public function getLabelsByNrperfilacesso(array $nrperfilacesso, $nrorg = null)
    {
        $nrorg = empty($nrorg) ? $this->environment->getCurrentOrganizationId() : $nrorg;
        $nrperfilacessoQueryFilter = $this->createQueryFilterNrperfilacesso($nrperfilacesso);
        return $this->accessProfileRepository->getLabelsByNrperfilacesso($nrperfilacessoQueryFilter, $nrorg);
    }

    /**
     * @param array $nrperfilacesso
     * @return string
     */
    private function createQueryFilterNrperfilacesso(array $nrperfilacesso)
    {
        return 'AND NRPERFILACESSO IN (' . implode(', ', $nrperfilacesso) . ")";
    }
}
