<?php

namespace Teknisa\Libs\Service;

use Teknisa\Libs\Util\Utilities;
use Teknisa\Libs\Util\Repositories\Migration as MigrationRepository;
use Teknisa\Libs\Util\InstanceProvider;

class Version {

    CONST TEKNISA_ENTITIES = 'git@192.168.122.56:teknisa/entities.git';

    public function getVersionInfo($currentModule) {
        $versionInfo = array(
            'name' => "",
			'version' => "",
            'frontend' => array(),
            'backend'  => array(),
            'modules'  => array(),
        );
        $config      = Utilities::getLoginConfig();
        $modulesPath = $config['modulesPath'];
        $productPath = Utilities::getProductBasePath();
        $modules     = $this->getFileContentsDecoded($productPath . $modulesPath);
        foreach($modules as $module => $moduleInfo) {
            if(!isset($moduleInfo['onlyControl']) || empty($moduleInfo['onlyControl'])) {
                $path = $productPath;
                if ($module != Utilities::PRODUCT_MENU_NAME) {
                    $path .= '/modules/' . $module;
                }
                if ($module == $currentModule) {
                    $versionInfo['backend']  = $this->getBackendVersion($path);
                    $versionInfo['frontend'] = $this->getFrontendVersion($path, $versionInfo);
                } else {
                    $versionInfo['modules'][] = $this->getModulesVersion($path, $module);
                }
            }
        }
        if(Utilities::getShowDbInVersionInfoParameter()) {
            $versionDb = $this->getVersionDB();
            $versionInfo['version'] .= ' ( DB Version - ' . $versionDb. ' )';
        }
        
        return $versionInfo;
    }

    protected function getVersionDB(){
        $nmObject = self::TEKNISA_ENTITIES ;
        $nrOrg = InstanceProvider::getEnvironment()->getCurrentOrganizationId();
        $customEntityManager = InstanceProvider::getConnectionCustom()->updateVpdConnection($nrOrg);
        $migration = MigrationRepository::getLastAppliedMigration($nmObject, $customEntityManager);
        if(empty($migration)){
            $version = '0';
        } else {
            $version = $migration[0]['NRVEROBJBD'];
        }
        return $version;
    }

    protected function getBackendVersion($path) {
        $version = array();
        $composerJsonFile = $this->getFileContentsDecoded($path . '/backend/composer.json');
        if($composerJsonFile) {
            $composerLockFile = $this->getFileContentsDecoded($path . '/backend/composer.lock');
            $requireKeys      = array_keys($composerJsonFile['require']);
            foreach ($composerLockFile['packages'] as $package) {
                if (in_array($package['name'], $requireKeys)) {
                    $versionEntities = $package['version'];
                    if($package['name'] == 'teknisa/entities'){
                        $versionDb = $this->getVersionDB();
                        $versionEntities = $versionEntities . ' ( ' . $versionDb . ' )';
                    }
                    array_push($version, array('name' => $package['name'], 'version' => $versionEntities));
                }
            }
        }
        return $version;
    }

    protected function getFrontendVersion($path, &$versionInfo) {
        $version = array();
        $packageFile = $this->getFileContentsDecoded($path . '/frontend/package.json');
        $packageLockFile = $this->getFileContentsDecoded($path . '/frontend/package-lock.json');
        $frontEndDirectoryName = '/frontend';

        if (!$packageFile) {
            $packageFile = $this->getFileContentsDecoded($path . '/mobile/package.json');
            $packageLockFile = $this->getFileContentsDecoded($path . '/mobile/package-lock.json');
            $frontEndDirectoryName = '/mobile';
        }

        if($packageFile && $packageLockFile) {
            $versionInfo['name'] = isset($packageFile['appName']) ? $packageFile['appName'] : $packageFile['name'];
            if(isset($packageFile['appVersion'])) {
                $versionInfo['version'] = $packageFile['appVersion'];
            } else if(isset($packageFile['version'])) {
                $versionInfo['version'] = $packageFile['version'];
            } else {
                $versionInfo['version'] = '';
            }
            $requireKeys = array_keys($packageFile['dependencies']);
            $packageLockDependencies = array_keys($packageLockFile['dependencies']);
            foreach ($requireKeys as $requireKey) {
                $depName = $requireKey;
                $depVersion = $packageLockFile['dependencies'][$requireKey]['version'];
                array_push($version, array('name' => $depName, 'version' => $depVersion));
            }
        }
        return $version;
    }

    protected function getModulesVersion($path, $module) {
        $packageFile = $this->getFileContentsDecoded($path . '/frontend/package.json');
        $frontEndDirectoryName = '/frontend';

        if (!$packageFile) {
            $packageFile = $this->getFileContentsDecoded($path . '/mobile/package.json');
            $frontEndDirectoryName = '/mobile';
        }

        $name = $module;
        if ($packageFile && isset($packageFile['appName'])) {
            $name = $packageFile['appName'];
        } else if($packageFile && isset($packageFile['name'])) {
            $name = $packageFile['name'];
        }

        $version = $packageFile && isset($packageFile['version']) ? $packageFile['version'] : "";
        return array( 'name' => $name, 'version' => $version );
    }

    protected function getFileContentsDecoded($filePath) {
        $fileContents = @file_get_contents($filePath);
        return $fileContents ? json_decode($fileContents, true) : null;
    }
} 