<?php


namespace Teknisa\Libs\Traits;

use Exception;
use Zeedhi\Framework\DataSource\DataSet;
use Zeedhi\Framework\DTO\Response;
use Zeedhi\Framework\HTTP\Response\JSON;

trait TResponse
{
    /**
     * @var string[]
     */
    public static $statusTexts = array(
        100 => 'HTTP/1.1 100 Continue',
        101 => 'HTTP/1.1 101 Switching Protocols',
        200 => 'HTTP/1.1 200 OK',
        201 => 'HTTP/1.1 201 Created',
        202 => 'HTTP/1.1 202 Accepted',
        203 => 'HTTP/1.1 203 Non-Authoritative Information',
        204 => 'HTTP/1.1 204 No Content',
        205 => 'HTTP/1.1 205 Reset Content',
        206 => 'HTTP/1.1 206 Partial Content',
        300 => 'HTTP/1.1 300 Multiple Choices',
        301 => 'HTTP/1.1 301 Moved Permanently',
        302 => 'HTTP/1.1 302 Found',
        303 => 'HTTP/1.1 303 See Other',
        304 => 'HTTP/1.1 304 Not Modified',
        305 => 'HTTP/1.1 305 Use Proxy',
        307 => 'HTTP/1.1 307 Temporary Redirect',
        400 => 'HTTP/1.1 400 Bad Request',
        401 => 'HTTP/1.1 401 Unauthorized',
        402 => 'HTTP/1.1 402 Payment Required',
        403 => 'HTTP/1.1 403 Forbidden',
        404 => 'HTTP/1.1 404 Not Found',
        405 => 'HTTP/1.1 405 Method Not Allowed',
        406 => 'HTTP/1.1 406 Not Acceptable',
        407 => 'HTTP/1.1 407 Proxy Authentication Required',
        408 => 'HTTP/1.1 408 Request Time-out',
        409 => 'HTTP/1.1 409 Conflict',
        410 => 'HTTP/1.1 410 Gone',
        411 => 'HTTP/1.1 411 Length Required',
        412 => 'HTTP/1.1 412 Precondition Failed',
        413 => 'HTTP/1.1 413 Request Entity Too Large',
        414 => 'HTTP/1.1 414 Request-URI Too Large',
        415 => 'HTTP/1.1 415 Unsupported Media Type',
        416 => 'HTTP/1.1 416 Requested Range Not Satisfiable',
        417 => 'HTTP/1.1 417 Expectation Failed',
        500 => 'HTTP/1.1 500 Internal Server Error',
        501 => 'HTTP/1.1 501 Not Implemented',
        502 => 'HTTP/1.1 502 Bad Gateway',
        503 => 'HTTP/1.1 503 Service Unavailable',
        504 => 'HTTP/1.1 504 Gateway Time-out',
        505 => 'HTTP/1.1 505 HTTP Version Not Supported',
        506 => 'HTTP/1.1 Variant Also Negotiates (Experimental)', // RFC2295
        507 => 'HTTP/1.1 Insufficient Storage', // RFC4918
        508 => 'HTTP/1.1 Loop Detected', // RFC5842
        510 => 'HTTP/1.1 Not Extended', // RFC2774
        511 => 'HTTP/1.1 Network Authentication Required', // RFC6585
    );

    /**
     * @param array $content
     * @param int $statusCode
     * @throws Exception
     */
    public function sendResponseData(array $content, $statusCode = 200)
    {
        header(self::$statusTexts[$statusCode]);
        header('Content-type: application/json; charset=utf-8');
        header("Access-Control-Allow-Origin: *");
        header("Access-Control-Allow-Credentials: true");
        $data = $this->contentJson($content);
        echo($data);
        die;
    }

    /**
     * @param $content
     * @return string
     * @throws Exception
     */
    private function contentJson($content): string
    {
        if (null === $content) {
            $content = new \ArrayObject();
        }
        $encodingOptions = JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_AMP | JSON_HEX_QUOT;
        $content = json_encode($content, $encodingOptions);
        if ($content === false) {
            throw new Exception("Cant encode response content: ".json_last_error_msg());
        }
        return $content;
    }

    /**
     * @param array $data
     * @param Response $response
     * @param false $error
     */
    public function sendResponseNext(array $data, Response $response, $error = false)
    {
        $dataset = new DataSet('', $data['data'], $data['pagination']);
        $next = new \Zeedhi\Framework\DTO\Next\Response();
        $next->setDataSet($dataset);
        if($error) {
            $response->setStatus('E');
        }
        $response->setZeedhiNext($next);
    }

    /**
     * @param $content
     * @param $statusCode
     * @throws Exception
     */
    public function sendResponse($content, $statusCode)
    {
        $kernelResponse = new JSON($content, $statusCode);
        $responseHeaders = $kernelResponse->getHeaders();
        $responseHeaders->set('Access-Control-Allow-Origin', '*');
        $responseHeaders->set('Access-Control-Allow-Credentials', 'true');
        $responseHeaders->set('Content-type', 'application/json');
        $kernelResponse->send();
        die;
    }

}
