<?php

namespace Teknisa\Libs\Util;

use Doctrine\DBAL\DriverManager;
use Doctrine\ORM\EntityManager as EntityManager;
use Zeedhi\Framework\ORM\ConnectionFactory as ORMConnectionFactory;

class ConnectionCustom {
    private $config;
    private $eventManager;
    private $connectionParams;

    public function __construct(array $connectionParams, $config = null, $eventManager = null) {
        $this->config = $config;
        $this->eventManager = $eventManager;
        $this->connectionParams = $connectionParams;
    }

    public function updateVpdConnection($nrOrg) {
        if($nrOrg && isset($this->connectionParams['useVpd']) && $this->connectionParams['useVpd'] == 'true') {
            if (isset($this->connectionParams['vpdWithWallet']) && $this->connectionParams['vpdWithWallet'] == 'true') {
                unset($this->connectionParams['host']);
                unset($this->connectionParams['port']);
                $this->connectionParams['user'] = '/';
                $this->connectionParams['password'] = '';
                $this->connectionParams['dbname'] = 'USR_ORG_' . $nrOrg;
                $this->connectionParams['sessionMode'] = -2147483648;
            } else {
                $this->connectionParams['user'] = 'USR_ORG_' . $nrOrg;
                if (!empty($this->connectionParams['vpdPassword'])) {
                    $this->connectionParams['password'] = $this->connectionParams['vpdPassword'];
                }
                if (empty($this->connectionParams['host'])) {
                    $this->connectionParams['dbname'] = 'USR_ORG_' . $nrOrg;
                }
                if (isset($this->connectionParams['isWallet']) && $this->connectionParams['isWallet'] == 'true') {
                    $this->connectionParams['dbname'] = isset($this->connectionParams['vpdDBNAME'])
                        ? $this->connectionParams['vpdDBNAME']
                        : $this->connectionParams['vpdDBName'];
                    $this->connectionParams['host'] = $this->connectionParams['vpdHost'];
                    $this->connectionParams['port'] = $this->connectionParams['vpdPort'];
                    $this->connectionParams['service'] = $this->connectionParams['vpdService'];
                    unset($this->connectionParams['sessionMode']);
                }
            }
            if(empty($this->connectionParams["password"])) {
                $this->connectionParams["password"] = '';
            } else if($this->connectionParams["isEncrypted"] == 'true') {
                if(isset($connectionParams["newCrypt"]) && $connectionParams["newCrypt"]) {
                    if(!isset($connectionParams["cryptKey"])){
                        throw new \Exception("The crypt key is required");
                    }
                    $this->connectionParams["password"] = ORMConnectionFactory::decrypt($this->connectionParams["password"],$connectionParams["cryptKey"]);
                } else {
                    $this->connectionParams["password"] = Utilities::legacyDecrypt($this->connectionParams["password"], 'zeedhi', "\0");
                }
            }

            $connection = DriverManager::getConnection($this->connectionParams, $this->config, $this->eventManager);
            return EntityManager::create($connection, $this->config, $this->eventManager);
        } else {
            return false;
        }
    }
} 