<?php

namespace Teknisa\Libs\Util;

use Teknisa\Libs\Util\Configuration;
use Zeedhi\Framework\DataSource\Manager\Doctrine\NameProvider;

class NameProviderImpl implements NameProvider {
    protected $fileLocation;

    public function __construct($fileLocation) {
        $this->fileLocation = $fileLocation;
    }

    public function getClassName($tableName) {}

    public function getDataSourceByName($dataSourceName) {
        $ds = DIRECTORY_SEPARATOR;
        if(!empty($this->fileLocation)) {
            $file = file_get_contents($this->fileLocation);
            $dataSourcesSubModels = json_decode($file, true);
            $dataSourceDirectory = $dataSourcesSubModels[$dataSourceName];
        } else {
            $dataSourceDirectory = '..' . $ds . 'gen' . $ds . 'datasources';
        }
        return Configuration::factoryFromFileLocation($dataSourceDirectory, $dataSourceName);
    }

}