<?php

namespace Teknisa\Libs\Util\Masks;

use Teknisa\Libs\Util\Repositories\General;

class Picture {
    private $_mascara;
    private $_numeroDeNiveis;
    private $_tamanhoDaMascara;
    private $_tamanhoCadaNivel = array();
    private $_tamanhoNivelAcumulado = array();

    public function __construct($nrorg, $picture) {
        $paramgeral = General::getGeneralParamsByOrganizationId($nrorg);

        $this->_mascara = str_replace('a', '*', $paramgeral[strtoupper($picture)]);
        $this->_mascara = str_replace('c', 'C', $this->_mascara);

        $this->_numeroDeNiveis = (substr_count($this->_mascara, '.') + 1);
        $this->_tamanhoDaMascara = strlen(str_replace('.', '', $this->_mascara));
        $niveis = explode('.', $this->_mascara);
        for($i = 0; $i < $this->_numeroDeNiveis; $i++) {
            $this->_tamanhoCadaNivel[$i] = strlen($niveis[$i]);
            if (empty($this->_tamanhoNivelAcumulado)) {
                $this->_tamanhoNivelAcumulado[$i] = strlen($niveis[$i]);
            } else {
                $this->_tamanhoNivelAcumulado[$i] = $this->_tamanhoNivelAcumulado[$i - 1] + strlen($niveis[$i]);
            }
        }
    }

    public function getMascara()
    {
        return $this->_mascara;
    }

    public function getTamanhoDaMascara()
    {
        return $this->_tamanhoDaMascara;
    }

    public function getNumeroDeNiveis()
    {
        return $this->_numeroDeNiveis;
    }

    public function getTamanhoCadaNivel()
    {
        return $this->_tamanhoCadaNivel;
    }

    public function getTamanhoNivelAcumulado()
    {
        return $this->_tamanhoNivelAcumulado;
    }

    /**
     * Retorna o codigo na forma da mascara.
     *
     * @param string $codigoarvore Codigo da arvore.
     *
     * @return string
     */
    public function getCodigoComMascara($codigoarvore){

        $mascara = $this->_mascara;
        $novamascara = '';
        $i = 0;
        $count = 0;

        while($count < strlen($codigoarvore)) {
            if ($mascara[$i] !== '.') {
                $novamascara .= $codigoarvore[$count];
                $count++;
            } else {
                $novamascara .= '.';
            }
            $i++;
        }

        return $novamascara;
    }
} 