<?php

namespace Teknisa\Libs\Util;

use Doctrine\Common\Cache\Cache as CacheInterface;
use Zeedhi\Framework\Cache\Cache;
use Zeedhi\Framework\Cache\Type\MongoImpl;
use Teknisa\Libs\Exception\Token as TokenException;
use MongoDB\BSON\UTCDateTime as MongoDate;

class MongoImplCustom extends MongoImpl implements Cache, CacheInterface
{

    protected const collectionAccess = 'OperadorAcesso';
    /**
     * {@inheritdoc}
     */
    public function fetch($key, $lifeTime = 0, $keepConnected = false) {
        $documents = $this->mongo->find($this->getCollectionName(), array('_id' => $key));
        $document = array_shift($documents);

        if ($document === null) {
            TokenException::invalidToken($key);
        }

        if ($this->isExpired($document) && !$keepConnected) {
            $this->delete($key);
            TokenException::expiredToken($key);
        }

        $docParams = unserialize($document[self::DATA_FIELD]->getData());
        $this->save($key, $docParams, $lifeTime);
        return $docParams;
    }

    /**
     * Check if the document is expired.
     *
     * @param array $document
     *
     * @return boolean
     */
    protected function isExpired(array $document) {
        return isset($document[self::EXPIRATION_FIELD]) &&
               $document[self::EXPIRATION_FIELD] instanceof MongoDate &&
               intval($document[self::EXPIRATION_FIELD]->__toString()) < time();
    }

    public function findAccess(array $criteria) {
        $documents = $this->mongo->find(self::collectionAccess,$criteria);
        return empty($documents) ? null : $documents[0];
    }

    public function saveAccess($concurrentAccess)
    {
        if(empty($concurrentAccess['_id'])){
            $this->mongo->insert(self::collectionAccess,$concurrentAccess);
        }else{
            $criteria = array(
                '_id' => $concurrentAccess['_id']
            );
            unset($concurrentAccess['_id']);
            $this->mongo->getCollection(self::collectionAccess)->replaceOne($criteria,$concurrentAccess);
        }
    }

    public function deleteAccess($user, $project, $hash, $organizationId)
    {
        $criteria = array("nrProdutoId" => intval($project), "cdOperador" => $user, "dsChaveUltAcesso" => $hash, "nrOrg" => $organizationId);
        $this->mongo->getCollection(self::collectionAccess)->deleteOne($criteria);
    }
}