<?php

namespace Teknisa\Libs\Util\Repositories;

use Doctrine\DBAL\Connection;
use Teknisa\Libs\Util\Utilities;
use Teknisa\Libs\Util\InstanceProvider;

class CustomReports {

    /**
     * @param $name
     * @param $content
     * @param $nrOrg
     * @param $cdOperador
     */
    public static function insertCustomReport($label, $fileName, $parentReport, $productId, $windowName, $nrOrg, $cdOperador) {
        $dateTimeFormat = 'DD/MM/YYYY HH24:MI:SS';
        $query = <<<SQL
                INSERT INTO CUSTOM_REPORTS 
                (ID, LABEL, FILE_NAME, PARENT_REPORT, PRODUCT_ID, WINDOW_NAME, NRORG, 
                DTINCLUSAO, DTULTATU, CDOPERINCLUSAO, CDOPERULTATU, NRORGINCLUSAO, NRORGULTATU)
                VALUES 
                (SEQ_CUSTOM_REPORTS.NEXTVAL, :LABEL, :FILE_NAME, :PARENT_REPORT, :PRODUCT_ID, :WINDOW_NAME, :NRORG,
                TO_DATE(:NOW, '$dateTimeFormat'), TO_DATE(:NOW, '$dateTimeFormat'), :CDOPERADOR, :CDOPERADOR, :NRORG, :NRORG)
SQL;
        $params = array(
            'LABEL'         => $label,
            'FILE_NAME'     => $fileName,
            'PARENT_REPORT' => $parentReport,
            'PRODUCT_ID'    => $productId,
            'WINDOW_NAME'   => $windowName,
            'NRORG'         => $nrOrg,
            'CDOPERADOR'    => $cdOperador,
            'NOW'           => Utilities::getCurrentDateTimeString()
        );

        InstanceProvider::getEntityManager()->getConnection()->executeQuery($query, $params);
    }

    public static function updateCustomReport($id, $label, $productId, $windowName, $nrorg, $cdoperador) {
        $dateTimeFormat = 'DD/MM/YYYY HH24:MI:SS';
        $query = <<<SQL
                   UPDATE CUSTOM_REPORTS 
                      SET LABEL = :LABEL,
                          DTULTATU = TO_DATE(:NOW, '$dateTimeFormat'), 
                          CDOPERULTATU = :CDOPERADOR, 
                          NRORGULTATU = :NRORG
                    WHERE ID = :ID
                      AND NRORG = :NRORG
                      AND PRODUCT_ID = :PRODUCT_ID
                      AND WINDOW_NAME = :WINDOW_NAME
SQL;

        $params = array(
            'LABEL'         => $label,
            'ID'            => $id,
            'WINDOW_NAME'   => $windowName,
            'PRODUCT_ID'    => $productId,
            'NRORG'         => $nrorg,
            'CDOPERADOR'    => $cdoperador,
            'NOW'           => Utilities::getCurrentDateTimeString()

        );

        InstanceProvider::getEntityManager()->getConnection()->executeQuery($query, $params);
    }

    public static function deleteCustomReport($id, $productId, $windowName, $nrorg) {
        $dateTimeFormat = 'DD/MM/YYYY HH24:MI:SS';
        $query = <<<SQL
                   DELETE 
                     FROM CUSTOM_REPORTS
                    WHERE ID = :ID
                      AND NRORG = :NRORG
                      AND PRODUCT_ID = :PRODUCT_ID
                      AND WINDOW_NAME = :WINDOW_NAME
SQL;

        $params = array(
            'ID'          => $id,
            'WINDOW_NAME' => $windowName,
            'PRODUCT_ID'  => $productId,
            'NRORG'       => $nrorg,
        );

        InstanceProvider::getEntityManager()->getConnection()->executeQuery($query, $params);
    }

    public function getCustomReports($productId, $windowName, $nrorg, $id = null)
    {
        $idFilter = empty($id) ? '' : ' AND ID = ' . $id;
        $query = <<<SQL
                  SELECT ID AS "ID", LABEL AS "LABEL", FILE_NAME AS "FILE_NAME",
                         PARENT_REPORT AS "PARENT_REPORT", WINDOW_NAME AS "WINDOW_NAME"
                    FROM CUSTOM_REPORTS 
                   WHERE NRORG = :NRORG
                     AND PRODUCT_ID = :PRODUCT_ID
                     AND WINDOW_NAME = :WINDOW_NAME
                         $idFilter
                ORDER BY ID
SQL;

        $params = array(
            'PRODUCT_ID'  => $productId,
            'WINDOW_NAME' => $windowName,
            'NRORG'       => $nrorg,
        );
        
        return InstanceProvider::getEntityManager()->getConnection()->fetchAll($query, $params);
    }
}