<?php

namespace Teknisa\Libs\Util\Repositories;

use Doctrine\DBAL\Connection;
use Teknisa\Libs\Util\Utilities;
use Teknisa\Libs\Util\InstanceProvider;



class Layout {

    /**
     * @param $name
     * @param $content
     * @param $nrOrg
     * @param $cdOperador
     */
    public static function insertLayout($name, $layoutString, $nrOrg, $cdOperador) {
        $dateTimeFormat = 'DD/MM/YYYY HH24:MI:SS';
        $query = <<<SQL
                INSERT INTO ZH_LAYOUT_NEXT 
                (NAME, CONTENT, CDOPERADOR, NRORG ,DTINCLUSAO, DTULTATU, CDOPERINCLUSAO, CDOPERULTATU, NRORGINCLUSAO, NRORGULTATU)
                VALUES (:NAME, :CONTENT, :CDOPERADOR, :NRORG, TO_DATE(:NOW, '$dateTimeFormat'), TO_DATE(:NOW, '$dateTimeFormat'), :CDOPERADOR, :CDOPERADOR, :NRORG, :NRORG)
SQL;
        $params = array(
            'NAME'   => $name,
            'CONTENT'   => $layoutString,
            'NRORG'        => $nrOrg,
            'CDOPERADOR'   => $cdOperador,
            "NOW" => Utilities::getCurrentDateTimeString()

        );

        InstanceProvider::getEntityManager()->getConnection()->executeQuery($query, $params);

    }

    public static function updateLayout($id, $layoutString, $nrOrg, $cdOperador) {
        $dateTimeFormat = 'DD/MM/YYYY HH24:MI:SS';
        $query = <<<SQL
                    UPDATE ZH_LAYOUT_NEXT 
                     SET CONTENT = :CONTENT , 
                         DTULTATU = TO_DATE(:NOW, '$dateTimeFormat'), 
                         CDOPERULTATU = :CDOPERADOR, 
                         NRORGULTATU = :NRORG
                  WHERE ID = :ID 
                        AND NRORG = :NRORG
SQL;

        $params = array(
            'ID'   => $id,
            'CONTENT'   => $layoutString,
            'NRORG'        => $nrOrg,
            'CDOPERADOR'   => $cdOperador,
            "NOW" => Utilities::getCurrentDateTimeString()

        );

        InstanceProvider::getEntityManager()->getConnection()->executeQuery($query, $params);

    }

    public function getLayout($name, $nrorg, $cdoperador)
    {
        $query = <<<SQL
                  SELECT CONTENT AS "CONTENT", ID AS "ID"
                    FROM ZH_LAYOUT_NEXT 
                   WHERE NAME = :NAME
                    AND    NRORG = :NRORG
                    AND CDOPERADOR = :CDOPERADOR
SQL;

        $params = array(
            'NAME' => $name,
            'NRORG' => $nrorg, 
            'CDOPERADOR' => $cdoperador
        );
        
        $data = InstanceProvider::getEntityManager()->getConnection()->fetchAll($query, $params);
        return empty($data) ? $data : $data[0];
    }
}