<?php

namespace Teknisa\Libs\Controller;

use Exception;
use Teknisa\Libs\Traits\TResponse;
use Teknisa\Libs\Util\Utilities;
use Zeedhi\Framework\DTO\Request;
use Zeedhi\Framework\DTO\Response;
use Zeedhi\Framework\DTO\Response\Error;
use Zeedhi\Framework\DataSource\DataSet;
use Teknisa\Libs\Service\Version as VersionService;

class Version {

    use TResponse;
    /** @var  VersionService $versionService */
    private $versionService;

    /** @param VersionService $versionService */
    public function __construct(VersionService $versionService)
    {
        $this->versionService = $versionService;
    }


    public function getVersionInfo(Request $request)
    {
        try {
            $currentModule = $request->getParameter('currentModule');
            $versionInfo = $this->versionService->getVersionInfo($currentModule);
            $this->sendResponse($versionInfo, 200);
        } catch(Exception $e) {
            $this->sendResponse(['error' => $e->getMessage(), 'code' => $e->getCode()], 500);
        }
    }
}