<?php

namespace Teknisa\Libs\Controller;

use Teknisa\Libs\Exception\CustomException;
use Teknisa\Libs\Traits\TResponse;
use Teknisa\Libs\Util\Utilities;
use Zeedhi\Framework\DTO\Exception;
use Zeedhi\Framework\DTO\Request;
use Zeedhi\Framework\DTO\Response;
use Teknisa\Libs\Service\Metadata as MetadataService;

class Metadata
{
    use TResponse;

    /** @var  MetadataService $metadataService */
    private $metadataService;

    public function __construct(MetadataService $metadataService)
    {
        $this->metadataService = $metadataService;
    }

    /**
     * @param Request $request
     * @return void
     * @throws Exception
     */
    public function findMetadata(Request $request)
    {
        try {
            $params = $request->getParameters();
            $jsonPath = $params['jsonPath'];
            $override = $params['override'] ?? null;
            $routePath = $params['routePath'] ?? null;
            $metadataJson = $this->metadataService->findMetadata($jsonPath, $override, $routePath);
            $this->sendResponse($metadataJson, 200);
        } catch(CustomException $e) {           
            $this->sendResponse(Utilities::getErrorObjectFromException($e), 500);
        }
    }
}
