<?php

namespace Teknisa\Libs\Util\XLS;

class Error {
    
    protected $message;
    protected $row;
    protected $column;
    protected $columnName;
    
    public function __construct($message, $row, $column = NULL, $columnName = NULL){
        $this->message = $message;
        $this->row = $row;
        $this->column = $column;
        $this->columnName = $columnName;
    }
    
    public function getMessage(){
        return $this->message;
    }
    
    public function getRow(){
        return $this->row;
    }
    
    public function getColumn(){
        return $this->column;
    }
    
    public function getColumnName(){
        return $this->columnName;
    }
    
    public function setMessage($message){
        $this->message = $message;
    }
    
    public function setRow($row){
        $this->row = $row;
    }
    
    public function setColumn($column){
        $this->column = $column;
    }
    
    public function setColumnName($columnName){
        $this->columnName = $columnName;
    }
    
    public function toArray(){
        return array(
            'message' => $this->message,
            'row' => $this->row,
            'column' => $this->column,
            'columnName' => $this->columnName
        );
    }
    
}