<?php

namespace Teknisa\Libs\Controller;

use Exception;
use Teknisa\Libs\Traits\TResponse;
use Teknisa\Libs\Util\Utilities;
use Zeedhi\Framework\DTO\Request;
use Zeedhi\Framework\DTO\Response;
use Zeedhi\Framework\DTO\Response\Error;
use Zeedhi\Framework\DataSource\DataSet;
use Teknisa\Libs\Service\GeneralInfo as GeneralInfoService;

class GeneralInfo {

    use TResponse;

    /**
     * @var GeneralInfoService
     */
    private $generalInfoService;

    /**
     * GeneralInfo constructor.
     * @param GeneralInfoService $generalInfoService
     */
    public function __construct(GeneralInfoService $generalInfoService)
    {
        $this->generalInfoService = $generalInfoService;
    }


    public function getGeneralInfo(Request $request)
    {
        try {
            $currentModule = $request->getParameter('currentModule');
            $versionInfo = $this->generalInfoService->getGeneralInfo($currentModule);
            $this->sendResponse($versionInfo, 200);
        } catch(Exception $e) {
            $this->sendResponse(['error' => $e->getMessage(), 'code' => $e->getCode()], 500);
        }
    }
}