<?php

namespace Teknisa\Libs\Service;

use Teknisa\Libs\Service\Version as VersionService;
use Teknisa\Libs\Util\Environment;
use Teknisa\Libs\Util\InstanceProvider;
use Teknisa\Libs\Util\Utilities;

class GeneralInfo
{
    /**
     * @var Environment
     */
    private $environment;

    /**
     * @var VersionService
     */
    private $versionService;

    public function __construct(Environment $environment, VersionService $versionService)
    {
        $this->environment = $environment;
        $this->versionService = $versionService;
    }

    public function getGeneralInfo($currentModule)
    {
        $versionInfo = $this->versionService->getVersionInfo($currentModule);
        $userInfo = $this->getUserInfo();
        return ['versionInfo' => $versionInfo, 'userInfo' => $userInfo];
    }

    public function getUserInfo()
    {
        $userDataRepository = InstanceProvider::getLibUserDataRepository();

        $userInfo = [
            'NAME' => $this->environment->getCurrentUserName(),
            'EMAIL' => $this->environment->getCurrentEmail(),
        ];

        $operador = $userDataRepository->getOperatorByCdoperador($this->environment->getUserId());

        if ($operador['DSIMAGEMOPER']) {
            $userInfo['IMAGE'] = Utilities::getFileServerFilesUrlParameter() . $operador['DSIMAGEMOPER'];
        } else {
            $userInfo['IMAGE'] = null;
        }

        return $userInfo;
    }
} 