<?php

namespace Teknisa\Libs\Service;

use Teknisa\Libs\Util\Environment;
use Teknisa\Libs\Util\Repositories\Log as LogRepository;
use Teknisa\Libs\Util\InstanceProvider;

class Log {
    /** @var LogRepository $logRepository */
    private $logRepository;
    /** @var Environment $environment */
    private $environment;

    public function __construct(LogRepository $logRepository, Environment $environment) {
        $this->logRepository = $logRepository;
        $this->environment = $environment;
    }

    public function logRegister($cdpesqitem, $dsoperacao, $idtipooper, $nmtabela, $dsmetusuoper, $dsnmusuoper, $dsrdmusuoper, $dsendusuoper) {
        $libEnvironment = InstanceProvider::getEnvironment();
        $organizationId = $libEnvironment->getCurrentOrganizationId();
        $operatorCurrent = $libEnvironment->getCurrentUserId();
        $findNmResOper = $this->logRepository->findNmResOper($operatorCurrent);
        $nmresoper = $findNmResOper[0]['NMOPERADOR'];
        $this->logRepository->insertLogRegister($cdpesqitem, $dsoperacao, $idtipooper, $nmtabela, $nmresoper, $dsmetusuoper, $dsnmusuoper, $dsrdmusuoper, $dsendusuoper, $organizationId, $operatorCurrent);
    }
} 
