<?php

namespace Teknisa\Libs\Util;

use Zeedhi\Framework\File;
use Zeedhi\Framework\Report\Strategy\BirtStrategy;
use Zeedhi\Framework\Report\ReportFile;

class BirtModules extends BirtStrategy {

    protected $defaultPath;
    protected $productPath;
    protected $modsPath = array();

    public function __construct($reportServerUrl, $defaultPath, $productPath, $modsPath, $logoPath = null, $confPath = null, $viewMode = BirtStrategy::VIEW_MODE) {
        $this->productPath = $productPath;
        $this->defaultPath = $defaultPath;
        $this->modsPath = $modsPath;
        $reportPath = $defaultPath;
        $reportType = BirtStrategy::STATIC_REL;
        $reportFormat = 'pdf';
        $reportLocale = BirtStrategy::DEFAULT_LOCALE;
        $reportTimezone = BirtStrategy::DEFAULT_TIMEZONE;

        parent::__construct($logoPath, $reportPath, $confPath, $reportServerUrl,
            $reportType, $reportFormat, $viewMode, $reportLocale, $reportTimezone
        );
    }

    public function createRemoteReport($reportName, array $params) {
        $changePathMod = \Zeedhi\Framework\Util\Functions::arrayKeyExists('MOD_PATH', $params) ? true : false;

        if ($changePathMod) {
            $mod = $params['MOD_PATH'];
            $reportPath = $this->productPath . '/' . $this->modsPath[$mod];
            $this->setReportPath($reportPath);
            $params = array_diff($params, array($mod));
        }

        $url = parent::createRemoteReport($reportName, $params);
        return $url;
    }
}