<?php

namespace Teknisa\Libs\Util;

use \Zeedhi\Framework\DataSource\Configuration as ZeedhiConfiguration;

class Configuration extends ZeedhiConfiguration {
    protected $columnsProperties;

    public function getColumnsProperties() {
        return $this->columnsProperties;
    }

    public function setColumnsProperties($columnsProperties) {
        $this->columnsProperties = $columnsProperties;
    }

    public static function factoryFromFileLocation(string $dirLocation, string $dataSourceName) : ZeedhiConfiguration {
        $instance = parent::factoryFromFileLocation($dirLocation, $dataSourceName);
        $pathFile = realpath($dirLocation).DIRECTORY_SEPARATOR.$dataSourceName.'.json';
        $json = file_get_contents($pathFile);
        $dataSourceConfig = json_decode($json, true);
        $dataSourceConfig = $dataSourceConfig[$dataSourceName];

        if (isset($dataSourceConfig['columnsProperties'])) {
            $instance->setColumnsProperties($dataSourceConfig['columnsProperties']);
        }

        return $instance;
    }
}