<?php

namespace Teknisa\Libs\Util;

use Zeedhi\Framework\Session\Session;

class Environment {
    /** @var Session $session */
    protected $session;

    /**
     * @param $session
     */
    public function __construct(Session $session){
        $this->session = $session;
    }

    public function getLoginTokenInSession() {
        return $this->session->has("tokenLogin") ? $this->session->get("tokenLogin") : null;
    }

    public function setLoginTokenInSession($token) {
        $this->session->set("tokenLogin", $token);
    }

    public function getCurrentUserId() {
        return $this->session->has("USER_ID") ? $this->session->get("USER_ID") : null;
    }

    public function setCurrentUserId($userId) {
        $this->session->set("USER_ID", $userId);
    }

    public function getCurrentUserName() {
        return $this->session->has("USER_NAME") ? $this->session->get("USER_NAME") : null;
    }

    public function getCurrentOrganizationId() {
        return $this->session->has("ORGANIZATION_ID") ? $this->session->get("ORGANIZATION_ID") : null;
    }

    public function setCurrentOrganizationId($orgId) {
        $this->session->set("ORGANIZATION_ID", $orgId);
    }

    public function getCurrentTradingName() {
        return $this->session->has("TRADING_NAME") ? $this->session->get("TRADING_NAME") : null;
    }

    public function getCurrentEmail() {
        return $this->session->has("EMAIL") ? $this->session->get("EMAIL") : null;
    }

    public function getBHash() {
        return $this->session->has("CURRENT_DBNAME") ? $this->session->get("CURRENT_DBNAME") : null;
    }

    public function getSessionExpired() {
        return $this->session->has("SESSION_EXPIRED") ? $this->session->get("SESSION_EXPIRED") : null;
    }

    public function setSessionExpired($expiredSession) {
        $this->session->set("SESSION_EXPIRED", $expiredSession);
    }

    /* FILTER FUNCTIONS -------------------------------------------------------------------------------------------- */

    public function getUserId() {
        return $this->getCurrentUserId();
    }

    public function getOrganizationId() {
        return $this->getCurrentOrganizationId();
    }

    /* TEKNISA FUNCTIONS -------------------------------------------------------------------------------------------- */

    public function getCdFilial() {
        return $this->session->get("CDFILIAL");
    }

    public function setCdFilial($cdFilial) {
        $this->session->set("CDFILIAL", $cdFilial);
    }

    public function getNrOrgTrab() {
        return $this->session->get("NRORGTRAB") ? $this->session->get("NRORGTRAB") : $this->getCurrentOrganizationId();
    }

    public function setNrOrgTrab($nrOrgTrab) {
        $this->session->set("NRORGTRAB", $nrOrgTrab);
    }

    public function getCdOperador() {
        return $this->getCurrentUserId();
    }

    public function setCdOperador($cdOperador) {
        $this->setCurrentUserId($cdOperador);
    }

    public function getNrOrg() {
        return $this->getCurrentOrganizationId();
    }

    public function setNrOrg($orgId) {
        $this->setCurrentOrganizationId($orgId);
    }
    
    public function getNrPerfil() {
        return $this->session->get("CDPERFILSELECIONADO");
    }
    
    public function setNrPerfil($nrPerfil) {
        $this->session->set("CDPERFILSELECIONADO", $nrPerfil);
    }
    
    public function setIdUtlPerfilFilial($utlPerfilFilial) {
        $this->session->set("IDUTLPERFILFILIAL", $utlPerfilFilial);
    }
    
    public function getIdUtlPerfilFilial() {
        return $this->session->get("IDUTLPERFILFILIAL");
    }

    public function getCurrentTime() {
        return new \DateTime();
    }
    
    public function getFileServerAPIKey() {
        return $this->session->get("FILE_SERVER_API_KEY");
    }
    
    public function setFileServerAPIKey($fsAPIKEY) {
        $this->session->set("FILE_SERVER_API_KEY", $fsAPIKEY);
    }
    
    public function setFiliOper($filiOper){
        $this->session->set("FILIOPER", $filiOper);
    }
    
    public function getFiliOper(){
        return $this->session->get("FILIOPER");
    }
} 