<?php

namespace Teknisa\Libs\Service;

use Teknisa\Libs\Util\Environment;
use Teknisa\Libs\Util\InstanceProvider;
use Teknisa\Libs\Util\Repositories\Layout as LayoutRepository;
use Teknisa\Libs\Util\Utilities;

class Layout
{
    /**
     * @var Environment
     */
    private $environment;

    /** @var LayoutRepository $migrationRepository */
    private $layoutRepository;

    /**
     * @param LayoutRepository $migrationRepository
     */
    public function __construct(Environment $environment, LayoutRepository $layoutRepository)
    {
        $this->environment = $environment;
        $this->layoutRepository = $layoutRepository;

    }

    public function loadLayout($name)
    {
        $organizationId =  InstanceProvider::getEnvironment()->getCurrentOrganizationId();
        $cdOper =  InstanceProvider::getEnvironment()->getCdOperador();
        $result = $this->layoutRepository->getLayout($name, $organizationId, $cdOper);
        if(empty($result)) {
            $result = [
                'data' => [
                    'id' => $name,
                    'layouts' => [
                        'currentLayoutName' => '',
                        'layouts' => []
                    ]
                ]
            ];
        } else {
            $object = json_decode($result['CONTENT']);
            $result = (object) [
                'data' => $object
            ];
        }
        return $result;
    }

    public function saveLayout($layoutObject)
    {
        $layoutString = json_encode($layoutObject);
        $name = $layoutObject['id'];
        $organizationId =  InstanceProvider::getEnvironment()->getCurrentOrganizationId();
        $cdOper =  InstanceProvider::getEnvironment()->getCdOperador();
        $layout = $this->layoutRepository->getLayout($name, $organizationId, $cdOper);
        if(!empty($layout)) {
            $this->layoutRepository->updateLayout($layout['ID'], $layoutString, $organizationId, $cdOper);

        } else {
            $this->layoutRepository->insertLayout($name, $layoutString, $organizationId, $cdOper);
        }
    }
} 