<?php

namespace Teknisa\Libs\Util\Repositories;

use Doctrine\ORM\EntityManager;

class UserData {
    /** @var EntityManager $entityManager */
    protected $entityManager;

    /**
     * @param EntityManager $entityManager
     */
    public function __construct(EntityManager $entityManager) {
        $this->entityManager = $entityManager;
    }

    public function setEntityManager($entityManager) {
        $this->entityManager = $entityManager;
    }

    /**
     * @param $operador
     * @return array
     */
    public function getOperatorByNmAccessOrEmail($operador){
        $query = "SELECT CDOPERADOR AS ID, NMOPERADOR AS NAME, NRORG AS ORGANIZATION_ID, DSEMAILOPER AS EMAIL,
                         CDSENHAOPERWEB AS PASSWORD_MD5, CDSENHOPER AS PASSWORD_CRYPTO_PLUS,
                         CASE WHEN IDOPERATIVO = 'A'
                              THEN 'Y'
                              ELSE 'N'
                          END AS IS_ACTIVE,
                         IDIDIOMA, NMACESSO, NMCOMPLOPER, CDEMPRESA, NRPARCNEGOCIO,
                         NRORG, NRORGTRAB, NRESTRUTTRAB, CDFILIALSELECIONADA, NRORGOPER
                    FROM OPERADOR
                   WHERE UPPER(NMACESSO) = UPPER(:OPERADOR)
                      OR DSEMAILOPER = :OPERADOR";

        $params = array( 'OPERADOR' => $operador );
        $result = $this->entityManager->getConnection()->fetchAllAssociative($query, $params);
        return !empty($result) ? $result[0] : $result;
    }

    /**
     * @param $cdOperator
     * @return array
     */
    public function getOperatorByCdoperador($cdOperator){
        $query = "SELECT CDOPERADOR, NMOPERADOR, IDOPERATIVO, NRORG, CDSENHAOPERWEB, CDSENHOPER, IDIDIOMA,
                         NMACESSO, NMCOMPLOPER, CDEMPRESA, NRPARCNEGOCIO, NRORG, NRORGTRAB,
                         NRESTRUTTRAB, DSEMAILOPER, CDFILIALSELECIONADA, NRORG AS ORGANIZATION_ID, DSEMAILOPER AS EMAIL,
                         CDSENHAOPERWEB AS PASSWORD_MD5, CDSENHOPER AS PASSWORD_CRYPTO_PLUS,
                         CDOPERADOR AS ID, DSIMAGEMOPER
                    FROM OPERADOR
                   WHERE CDOPERADOR = :CDOPERADOR";

        $params = array( 'CDOPERADOR' => $cdOperator );
        $result = $this->entityManager->getConnection()->fetchAllAssociative($query, $params);
        return !empty($result) ? $result[0] : $result;
    }

    /**
     * @param $nrOrg
     * @return array
     */
    public function getParamSenhaByNrorg($nrOrg){
        $query = "SELECT NRDIASEXPSEN, IDUTILIZAAD, IDUTCTRLSEN, CDPICTSENHA, NRERROSENHA,
                         QTMINSISINA, NRDIASAVISO, NRALTSENHREP, NMDOMINIOAD,
                         DSURLSERVERAD, NMUSUARIOADMAD, DSSENHAUSUARIOADMAD
                    FROM PARAMSENHA
                   WHERE NRORG = :NRORG";

        $params = array( 'NRORG' => $nrOrg );
        $result = $this->entityManager->getConnection()->fetchAllAssociative($query, $params);
        return !empty($result) ? $result[0] : $result;
    }

    /**
     * @param $nrOrg
     * @return array
     */
    public function getParamGeralByNrorg($nrOrg){
        $query = "SELECT CDPICTPROD, CDPICTPRAT, IDUTCTRLACESWEB
                    FROM PARAMGERAL
                   WHERE NRORG = :NRORG";

        $params = array( 'NRORG' => $nrOrg );
        $result = $this->entityManager->getConnection()->fetchAllAssociative($query, $params);
        return !empty($result) ? $result[0] : $result;
    }

    /**
     * @param $nrOrg
     * @param $nrParcNegocio
     * @return array
     */
    public function getPerfAcessParcByNrorgAndNrParcNegocio($nrOrg, $nrParcNegocio){
        $query = "SELECT PP.NRPERFILACESSO AS ID, PA.IDPERFILACESSOADM
                    FROM PERFACESSPARC PP
                   INNER JOIN PERFILACESSO PA ON PA.NRPERFILACESSO = PP.NRPERFILACESSO
                   WHERE PP.NRORG = :NRORG
                     AND PA.NRORG = :NRORG
                     AND PP.NRPARCNEGOCIO = :NRPARCNEGOCIO
                     AND PP.IDATIVO = 'S'";

        $params = array( 'NRORG' => $nrOrg, 'NRPARCNEGOCIO' => $nrParcNegocio );
        return $this->entityManager->getConnection()->fetchAllAssociative($query, $params);
    }

    /**
     * @param $cdFilial
     * @param $nrOrg
     * @return array
     */
    public function getFilialByCdfilialAndNrorg($cdFilial, $nrOrg){
        $query = "SELECT CDFILIAL, NMFILIAL
                    FROM FILIAL
                   WHERE NRORG = :NRORG
                     AND CDFILIAL = :CDFILIAL";

        $params = array( 'NRORG' => $nrOrg, 'CDFILIAL' => $cdFilial );
        $result = $this->entityManager->getConnection()->fetchAllAssociative($query, $params);
        return !empty($result) ? $result[0] : $result;
    }

    /**
     * @param $nrOrg
     * @return array
     */
    public function getOrganizacaoByNrorg($nrOrg){
        $query = "SELECT NRORG, NMORGANIZACAO AS TRADING_NAME, NMRAZSOCIALORG AS COMPANY_NAME
                    FROM ORGANIZACAO
                   WHERE NRORG = :NRORG";

        $params = array( 'NRORG' => $nrOrg );
        $result = $this->entityManager->getConnection()->fetchAllAssociative($query, $params);
        return !empty($result) ? $result[0] : $result;
    }

    /**
     * @param $cdOperador
     * @return array
     */
    public function getLastPasswordUpdateByCdOperador($cdOperador){
        $query = "SELECT TO_CHAR(MAX(DTALTSENHA), 'DD/MM/YYYY') AS DTALTSENHA, IDATUCTRLSENHA
                    FROM CONTROLSENHA
                   WHERE CDOPERADOR = :CDOPERADOR
                     AND DTALTSENHA = (SELECT MAX(DTALTSENHA) AS DTALTSENHA
                                         FROM CONTROLSENHA
                                        WHERE CDOPERADOR = :CDOPERADOR)
                   GROUP BY IDATUCTRLSENHA
                   ORDER BY DTALTSENHA";

        $params = array( 'CDOPERADOR' => $cdOperador );
        $result = $this->entityManager->getConnection()->fetchAllAssociative($query, $params);
        return !empty($result) ? $result[0] : $result;
    }

    /**
     * @param $cdOperator
     * @param $nrOrg
     * @param $webPassword
     * @param $delphiPassword
     * @return array
     */
    public function updateOperatorPassword($cdOperator, $nrOrg, $webPassword, $delphiPassword){
        $query = "UPDATE OPERADOR
                     SET CDSENHAOPERWEB = :WEB_PASSWORD,
                         CDSENHOPER     = :DELPHI_PASSWORD,
                         DTULTATU       = SYSDATE,
                         IDSTATUSENHA   = 'A'
                   WHERE CDOPERADOR = :CDOPERADOR
                     AND NRORG      = :NRORG";

        $params = array(
            'CDOPERADOR'      => $cdOperator,
            'NRORG'           => $nrOrg,
            'WEB_PASSWORD'    => $webPassword,
            'DELPHI_PASSWORD' => $delphiPassword
        );

        return $this->entityManager->getConnection()->executeQuery($query, $params);
    }

    /**
     * @param $cdOperator
     * @param $nrOrg
     * @param $cdSenhAlt
     * @param $cdSenhAltWeb
     * @param $idAtuCtrlSenha
     * @return array
     */
    public function insertControlSenha($cdOperator, $nrOrg, $cdSenhAlt, $cdSenhAltWeb, $idAtuCtrlSenha){
        $query = "INSERT INTO CONTROLSENHA
                         (NRORGINCLUSAO, DTINCLUSAO, CDOPERINCLUSAO, CDOPERADOR, DTALTSENHA,
                          CDSENHALT, CDSENHALTWEB, IDATUCTRLSENHA, NRORG, DTULTATU, NRORGULTATU, CDOPERULTATU)
                  VALUES (:NRORG, SYSDATE, :CDOPERADOR, :CDOPERADOR, SYSDATE,
                          :CDSENHALT, :CDSENHALTWEB, :IDATUCTRLSENHA, :NRORG, SYSDATE, :NRORG, :CDOPERADOR)";

        $params = array(
            'CDOPERADOR'     => $cdOperator,
            'NRORG'          => $nrOrg,
            'CDSENHALT'      => $cdSenhAlt,
            'CDSENHALTWEB'   => $cdSenhAltWeb,
            'IDATUCTRLSENHA' => $idAtuCtrlSenha
        );

        return $this->entityManager->getConnection()->executeQuery($query, $params);
    }

    /**
     * @param $nrOrg
     * @param $idAtivo
     * @return array
     */
    public function getUseIpRestrictionByNrorgAndIdativo($nrOrg, $idAtivo){
        $query = "SELECT IDUTIPRESTRICTION
                    FROM OM_PARAM_ORG
                   WHERE NRORG = :NRORG
                     AND IDATIVO = :IDATIVO";

        $params = array( 'NRORG' => $nrOrg, 'IDATIVO' => $idAtivo );
        $result = $this->entityManager->getConnection()->fetchAllAssociative($query, $params);
        return !empty($result) ? $result[0] : $result;
    }

    /**
     * @param $nrOrg
     * @param $idAtivo
     * @return array
     */
    public function getIpRestrictionByNrorgAndIdativo($nrOrg, $idAtivo){
        $query = "SELECT DS_IPV4_RESTRICTED AS IPV4, DS_IPV6_RESTRICTED AS IPV6
                    FROM OM_IP_RESTRICTION
                   WHERE NRORG = :NRORG
                     AND IDATIVO = :IDATIVO";

        $params = array( 'NRORG' => $nrOrg, 'IDATIVO' => $idAtivo );
        return $this->entityManager->getConnection()->fetchAllAssociative($query, $params);
    }

    /**
     * @param $cdOperator
     * @param $nrOrg
     * @return array
     */
    public function updateUserLastAccess($cdOperator, $nrOrg){
        $query = "UPDATE OPERADOR
                     SET DTULTACESOPER = SYSDATE
                   WHERE CDOPERADOR = :CDOPERADOR
                     AND NRORG      = :NRORG";

        $params = array(
            'CDOPERADOR'      => $cdOperator,
            'NRORG'           => $nrOrg
        );

        return $this->entityManager->getConnection()->executeQuery($query, $params);
    }

    public function getIdUtlPerfilFilial($nrOrg){
        try {
            $query = "SELECT IDUTLPERFILFILIAL
                        FROM PARAMGERAL
                       WHERE NRORG = :NRORG";

            $params = array( 'NRORG' => $nrOrg);
            $result =  $this->entityManager->getConnection()->fetchAllAssociative($query, $params);
            return isset($result[0]) ? $result[0] : array('IDUTLPERFILFILIAL' => "N");
        } catch (\Exception $e) {
            return array('IDUTLPERFILFILIAL' => "N");
        }
    }

    public function getPerfilSelecionado($nrOrg, $cdOperator){
        try {
            $query = "SELECT CDPERFILSELECIONADO 
                        FROM OPERADOR
                       WHERE NRORG = :NRORG
                         AND CDOPERADOR = :CDOPERADOR";

            $params = array( 'NRORG' => $nrOrg, 'CDOPERADOR' => $cdOperator );
            $result =  $this->entityManager->getConnection()->fetchAllAssociative($query, $params);
            return isset($result[0]) ? $result[0] : array('CDPERFILSELECIONADO' => null);
        } catch (\Exception $e) {
            return array('CDPERFILSELECIONADO' => null);
        }
    }

    public function getOperatorHash($user, $project, $organizationId) {
        $query = "SELECT DSCHAVEULTACESSO 
                    FROM OPERADOR_ACESSO
                   WHERE CDOPERADOR   = :USER_ID
                     AND NRPRODUTO_ID = :PROJECT
                     AND NRORG        = :NRORG";

        $params = array(
            'USER_ID' => $user,
            'PROJECT' => $project,
            'NRORG'   => $organizationId
        );
        $result =  $this->entityManager->getConnection()->fetchAllAssociative($query, $params);
        return isset($result[0]) ? $result[0] : [];
    }

    public function deleteOperatorHash($user, $project, $hash, $organizationId) {
        $query = "UPDATE OPERADOR_ACESSO
                     SET DSCHAVEULTACESSO = NULL                   
                   WHERE CDOPERADOR       = :USER_ID
                     AND NRPRODUTO_ID     = :PROJECT
                     AND DSCHAVEULTACESSO = :HASH
                     AND NRORG            = :NRORG";

        $params = array (
            'USER_ID' => $user,
            'PROJECT' => $project,
            'HASH'    => $hash,
            'NRORG'   => $organizationId
        );
        $stmt = $this->entityManager->getConnection()->prepare($query);
        $stmt->execute($params);
    }
}
