<?php

namespace Teknisa\Libs\Util;

use Teknisa\Libs\Util\Libraries\PHPMailer;

class SMTP {

    private $SMTPAuth    = true;
    private $IsHTML      = true;
    private $Host;
    private $Username;
    private $Password;
    private $Port;
    private $SMTPSecure;
    private $From;
    private $FromName;
    private $NmAddress;
    private $Subject;
    private $NameBCC;
    private $NameCC;
    private $NameReplyTo;
    private $Attachments = array();

    public function __construct(array $params) {
        $this->Host        = isset($params['host'])       ? $params['host']       : "smtp.teknisa.com";
        $this->Username    = isset($params['username'])   ? $params['username']   : "app@tecfood.com";
        $this->Password    = isset($params['password'])   ? $params['password']   : "@AppTecFood2015";
        $this->Port        = isset($params['port'])       ? $params['port']       : "";
        $this->SMTPSecure  = isset($params['smtpSecure']) ? $params['smtpSecure'] : "";
        $this->From        = isset($params['from'])       ? $params['from']       : "no-reply@teknisa.com";

        $smtpAuth       = isset($params['smtpAuth']) ? $params['smtpAuth'] : true;
        $this->SMTPAuth = $smtpAuth == '[SMTP_AUTH]' ? true : $smtpAuth;
    }

	public function sendMail($message, $address, $addressCC = '', $addressBCC = '', $addressReplyTo = '') {
		$mail = new PHPMailer;
		$mail->CharSet  = 'UTF-8';
		$mail->IsHTML($this->IsHTML);
        $mail->isSMTP();                       // Set mailer to use SMTP
        $mail->Host       = $this->Host;       // Specify main and backup SMTP servers
        $mail->SMTPAuth   = $this->SMTPAuth;   // Enable SMTP authentication
        $mail->Username   = $this->Username;   // SMTP username
        $mail->Password   = $this->Password;   // SMTP password
        $mail->Port       = $this->Port;
        $mail->SMTPSecure = $this->SMTPSecure;
        $mail->From       = $this->From;
        $mail->FromName   = $this->FromName;
        $mail->Subject    = $this->Subject;
        $mail->Body       = $message;

        if (is_array($address)) {
            foreach ($address as $to) {
                $mail->addAddress($to, $to); // Add multiple recipients
            }
        } else {
            $mail->addAddress($address, $this->NmAddress); // Add a recipient
        }

        //adiciona destinatários como cópia do email
        if (is_array($addressCC)) {
            foreach ($addressCC as $to) {
                $mail->AddCC($to, $to); // Add multiple recipients
            }
        } else {
            $mail->AddCC($addressCC, $this->NameCC); // Add a recipient
        }

        //adiciona destinatários como cópia oculta do email
        if (is_array($addressBCC)) {
            foreach ($addressBCC as $to) {
                $mail->AddBCC($to, $to); // Add multiple recipients
            }
        } else {
            $mail->AddBCC($addressBCC, $this->NameBCC); // Add a recipient
        }

        //adiciona emails para resposta
        if (is_array($addressReplyTo)) {
            foreach ($addressReplyTo as $to) {
                $mail->addReplyTo($to, $to); // Add multiple recipients
            }
        } else {
            $mail->addReplyTo($addressReplyTo, $this->NameReplyTo); // Add a recipient
        }

        foreach ($this->Attachments as $attachment) { // Add all attachments
            if (isset($attachment['isStringAttachment']) && $attachment['isStringAttachment']) {
                $mail->addStringAttachment($attachment["path"], $attachment["name"], $attachment["encoding"], $attachment["type"], $attachment["disposition"]);
            } else {
                $mail->addAttachment($attachment["path"], $attachment["name"], $attachment["encoding"], $attachment["type"], $attachment["disposition"]);
            }
        }

        $result = $mail->send();
        if(!$result) {
            throw new \Exception($mail->ErrorInfo);
        }
        return $result;
    }

    public function setNameBCC($NameBCC) {
		$this->NameBCC = $NameBCC;
    }

    public function setNameCC($NameCC) {
		$this->NameCC = $NameCC;
    }

    public function setNameReplyTo($NameReplyTo) {
		$this->NameReplyTo = $NameReplyTo;
    }

    public function setHost($Host) {
		$this->Host = $Host;
    }

    public function setSMTPAuth($SMTPAuth) {
        $this->SMTPAuth = $SMTPAuth;
    }

    public function setUsername($Username) {
        $this->Username = $Username;
    }

    public function setIsHTML($IsHTML) {
        $this->IsHTML = $IsHTML;
    }

    public function setPassword($Password) {
        $this->Password = $Password;
    }

    public function setFrom($From) {
        $this->From = $From;
    }

    public function setFromName($FromName) {
        $this->FromName = $FromName;
    }

    public function setNmAddress($NmAddress) {
        $this->NmAddress = $NmAddress;
    }

    public function setSubject($Subject) {
        $this->Subject = $Subject;
    }

    public function addAttachment($path, $name = '', $encoding = 'base64', $type = '', $disposition = 'attachment', $isStringAttachment = false) {
        $this->Attachments[] = array(
            "path"               => $path,
            "name"               => $name,
            "encoding"           => $encoding,
            "type"               => $type,
            "isStringAttachment" => $isStringAttachment,
            "disposition"        => $disposition
        );
    }
    
    public function clearAttachments() {
        $this->Attachments = array();
    }
}