<?php

namespace Teknisa\Libs\Service;

use Teknisa\Libs\Util\Environment;
use Teknisa\Libs\Util\Repositories\AccessProfile as AccessProfileRepository;

class AccessProfile {
    /** @var AccessProfileRepository $accessProfileRepository */
    private $accessProfileRepository;
    /** @var Environment $environment */
    private $environment;

    public function __construct(AccessProfileRepository $accessProfileRepository, Environment $environment) {
        $this->accessProfileRepository = $accessProfileRepository;
        $this->environment = $environment;
    }

    /**
     * @return array
     */
    public function getAccessProfile() {
        return $this->accessProfileRepository->getAccessProfile($this->environment->getCurrentOrganizationId());
    }
} 