<?php

namespace Teknisa\Libs\Util\Repositories;

use Doctrine\ORM\EntityManager;
use Teknisa\Libs\Util\Utilities;

class General {
    /**
     * @param $orgId
     * @return array
     */
    public static function getGeneralParamsByOrganizationId($orgId) {
        $query = "SELECT *
                    FROM PARAMGERAL
                   WHERE NRORG = :NRORG";

        $params = array( 'NRORG' => $orgId );
        $result = Utilities::getEntityManager()->getConnection()->fetchAllAssociative($query, $params);
        return !empty($result) ? $result[0] : $result;
    }

    /**
     * @param $productCode
     * @param $orgId
     * @return array
     */
    public static function getProductByCodeAndOrganizationId($productCode, $orgId) {
        $query = "SELECT *
                    FROM PRODUTO
                   WHERE NRORG = :NRORG
                     AND CDPRODUTO = :CDPRODUTO";

        $params = array( 'NRORG' => $orgId, 'CDPRODUTO' => $productCode );
        $result = Utilities::getEntityManager()->getConnection()->fetchAllAssociative($query, $params);
        return !empty($result) ? $result[0] : $result;
    }
}