<?php

namespace Teknisa\Libs\Controller;

use Zeedhi\Framework\HTTP\Request;


use Teknisa\Libs\Util\Environment;
use Teknisa\Libs\Controller\CRUD as CRUD;
use Teknisa\Libs\Service\CRUD as CRUDService;
use Zeedhi\Framework\DTO\Response\Error;
use Zeedhi\Framework\DTO;
use Zeedhi\Framework\DTO\Next\Response;
use Zeedhi\Framework\DataSource\DataSet;
use Zeedhi\Framework\DataSource\FilterCriteria;
//use Zeedhi\Framework\DataSource\Manager;
use Zeedhi\Framework\DataSource\Manager\SQL\ManagerImpl;
use Zeedhi\Framework\DataSource\Manager\Doctrine\NameProvider;

class CrudNext {
    const DATABASE_NAME = 'dbname';
    const IS_NEXT = 'isNext';
    public const IS_ZHNEXT = true;

    /** @var CRUD */
    protected $crudService;
    /** @var  Environment */
    protected $environment;
    protected $dataSourceName;
    protected $dataSourceNameToSave = false;
    protected $httpRequest;
    /** @var Manager The Entity Manager used to interact with Database. */
    private $dataSourceManager;

    public function __construct(CRUDService $crudService, Environment $environment, NameProvider $nameProvider, ManagerImpl $dataSourceManager) {
        $this->crudService = $crudService;
        $this->environment = $environment;
        $this->nameProvider = $nameProvider;
        $this->dataSourceManager = $dataSourceManager;
        $this->crud = new CRUD($this->crudService, $this->environment);
    }

    public function checkHistory(DTO\Response $response, $row) {
        $condition = array(
            array(
                "columnName" => "NRORG",
                "operator" => "=",
                "value" => $this->environment->getNrOrgTrab()
            ),
            array(
                "columnName" => strtoupper($row['saveHistoryTable']['__table_master_pk']),
                "operator" => "=",
                "value" => $row[strtoupper($row['saveHistoryTable']['__table_master_pk'])]
            ),
            array(
                "columnName" => strtoupper($row['saveHistoryTable']['__table_competenc']),
                "operator" => "=",
                "value" => $row[strtoupper($row['saveHistoryTable']['__table_competenc'])]
            )
        );

        $filterCriteria = new FilterCriteria($row['saveHistoryTable']['__table_history_name'], $condition);
        $newFilterCriteria = $this->crudService->populateParameterBag($filterCriteria, array());
        $this->crudService->find($response, $newFilterCriteria);

        if (count($response->getDataSets()[0]->getRows()) > 0) {
            return true;
        } else {
            return false;
        }
    }

    public function save(DTO\Request $request, DTO\Response $response) {
        try {
            $newRequest = $this->buildRequest($request);
            
            $this->dataSourceName = $newRequest->getParameter(self::DATABASE_NAME);
            $this->dataSourceNameToSave = $this->crudService->getDataSourceNameToSaveByName($this->dataSourceName);
            $this->dataSourceName = $this->dataSourceNameToSave ? $this->dataSourceNameToSave : $this->dataSourceName;
            $rows = $this->crudService->getRowsToSave($newRequest, $this->dataSourceName); //insere new_code e campos auditoria
            $persistedRows = $this->crudService->save($this->dataSourceName, $rows/*, self::IS_ZHNEXT*/);
            
            $next = new DTO\Next\Response(
                $this->dataSourceName,
                $this->getPrimaryKeyColumns($this->dataSourceName)
            );
            
            $isDataSet = count($newRequest->getDataSet()->getRows()) > 1;

            $this->setPersistedDataOnResponse($next, $this->dataSourceName, $persistedRows, $isDataSet);
            $response->setZeedhiNext($next);

            $currentRow = current($newRequest->getDataSet()->getRows());

            if(isset($currentRow['saveHistoryTable'])) {

                if (!$currentRow['__is_new']) {
                    if (!$this->checkHistory($response, $currentRow)) {
                        // is new history
                        $currentRow['__is_new'] = true;
                    }
                }

                $tableMasterPK = strtoupper($currentRow['saveHistoryTable']['__table_master_pk']);
                $newCode = array_filter($this->crudService->getColumnsToReturn(), function ($element) use ($tableMasterPK) {
                    return $element[$tableMasterPK];
                });

                $this->dataSourceNameToSave = $this->crudService->getDataSourceNameToSaveByName($currentRow['saveHistoryTable']['__table_history_name']);
                $this->dataSourceName = $this->dataSourceNameToSave ? $this->dataSourceNameToSave : $this->dataSourceName;
                $currentRow[strtoupper($currentRow['saveHistoryTable']['__table_master_pk'])] = intval($newCode[0][strtoupper($currentRow['saveHistoryTable']['__table_master_pk'])]);

                // set history properties
                $currentRow['__new_code_pk'] = $currentRow['saveHistoryTable']['__table_history_name'];
                $currentRow['__table_pk'] = $currentRow['saveHistoryTable']['__table_history_pk'];
                $currentRow['__columns_to_return'] = $currentRow['saveHistoryTable']['__columns_to_return'];

                $newDataSet = new DataSet($this->dataSourceName, array($currentRow));
                $newRequest = new \Zeedhi\Framework\DTO\Request\DataSet($newDataSet,
                $newRequest->getMethod(), $newRequest->getRoutePath(), $newRequest->getUserId());
                $rows = $this->crudService->getRowsToSave($newRequest, $this->dataSourceName);
                $this->crudService->save($this->dataSourceName, $rows);

            }
            $response->addDataset(new DataSet('columnsToReturn', $this->crudService->getColumnsToReturn()));
        } catch (\Exception $e) {
            $response->setError(new Error($e->getMessage(), 500));
        }
    }

    public function find(DTO\Request $request, DTO\Response $response) {
        try {
            $this->dataSourceName = $request->getParameter(self::DATABASE_NAME);
            $newRequest = $this->buildRequest($request);
            $filterCriteria = $newRequest->getFilterCriteria();
            $filterCriteria = $this->crudService->getFilterCriteriaWithNrOrg($filterCriteria);
            $newFilterCriteria = $this->crudService->getPopulatedFilterCriteria($filterCriteria, array());
            $this->crudService->find($response, $newFilterCriteria, true);
            $dataSets = $response->getDataSets();
            
            $dataSet = isset($dataSets[0])?  $dataSets[0]: $dataSets;
            $groupBy = $filterCriteria->getGroupBy();
            if(!empty($groupBy)){
                $pkColumns = [];//$groupBy;
            }else{
                $pkColumns = $this->getPrimaryKeyColumns($this->dataSourceName);
            }
            $next = new DTO\Next\Response(
                $this->dataSourceName,
                $pkColumns
            );
            
            $parameters = array_merge(
                $this->httpRequest->getQueryParameters()->getAll(),
                $this->httpRequest->getRequestParameters()->getAll()
            );

            if($this->isViewRequest($parameters) && ($rows = $dataSet->getRows())){
                $next->setRow(reset($rows));
            } else {
                $pagination = $dataSet->getPagination();
                $pagination = $this->dataSourceManager->getPagination($newFilterCriteria);
                $paginationDataSet = $dataSet->getPagination();
                if(isset($paginationDataSet["page"])) {
                    $pagination["page"] = $paginationDataSet["page"] ;
                }
                if(is_null($pagination['page'])){
                    $pagination['page'] = 1;
                }
                $dataSetNext = new DataSet($newFilterCriteria->getDataSourceName(), $dataSet->getRows(), $pagination);
                $next->setDataSet($dataSetNext);
            }
            
            $response->setZeedhiNext($next);
        } catch (\Exception $e) {
            $response->setError(new Error($e->getMessage(), 500));
        }
    }
    
    public function isViewRequest(array $parameters) : bool {
        $columns = $this->getPrimaryKeyColumns($this->dataSourceName);
        foreach($columns as $column) {
            if(!isset($parameters[$column])) return false;
        }
        return count($columns) > 0;
    }

    public function delete(DTO\Request $request, DTO\Response $response) {
        try {
            $newRequest = $this->buildRequest($request);
            $this->dataSourceName = $newRequest->getParameter(self::DATABASE_NAME);
            $this->dataSourceName = $this->crudService->getDataSourceNameToSaveByName($this->dataSourceName);
            $request = $this->crudService->buildDataSetIfRow($newRequest, $this->dataSourceName);
            $rows = $this->crudService->getRowsToDelete($request, $this->dataSourceName);
            $dataSet = new DataSet($this->dataSourceName, (array)$rows);
            
            $deletedRows = $this->crudService->delete($response, $dataSet);
            $nrDeletedRows = count($deletedRows);
            $next = new DTO\Next\Response(
                $this->dataSourceName,
                $this->getPrimaryKeyColumns($this->dataSourceName)
            );
            
            if($nrDeletedRows > 1){
                $pagination = $request->getDataSet()->getPagination();
                if(empty($pagination['page'])){
                    $pagination['page'] = 1;
                }
                $dataSetNext = new DataSet($this->dataSourceName, $deletedRows, $pagination);
                $next->setDataSet($dataSetNext);
            }
            else
                $next->setRow($deletedRows[0]);
                
            $response->setZeedhiNext($next);
        } catch (\Exception $e) {
            $response->setError(new Error($e->getMessage(), 500));
        }
    }
    
    /**
     * Builds the Request.
     *
     * @return DTO\Request\Filter|DTO\Request\DataSet
     *
     * @throws \Exception
     */
    public function buildRequest($request) {
        $this->getHttpRequest();
        $method = Request::getMethod();
        $userId = $this->httpRequest->getUserId();
        $cleanUri = $route = $request->getRoutePath();
        /*$cleanUri = $this->removeBaseUri($request->getRequestUri());
        $cleanUri = $this->removeQueryFromUri($cleanUri);
        $arrayUri = Next::buildArrayUri($cleanUri);
        $dataSourceName = $this->next->getDataSourceName($arrayUri);*/
        try{
            $dataSourceName = $request->getParameter(self::DATABASE_NAME);
        }catch(\Exception $e){
            if($e->getMessage() === 'Parameter dbname not found.')
                $dataSourceName = '';
            else
                throw $e;
        }
        
        $queryString = $this->httpRequest->getQueryString();
		parse_str($queryString, $qs);

        foreach ($qs as $key => $val) {
            if (is_string($val) && strpos($val, '|') !== false) {
                $qs[$key] = array_map('trim', explode('|', $val));
            }
        }
        
        $parameters = array_merge(
            $this->httpRequest->getQueryParameters()->getAll(),
            $this->httpRequest->getRequestParameters()->getAll(),
			$qs
        );
        
        if($method == 'GET' || ($method == 'DELETE' && !$parameters)) {
            $filterCriteria = $this->buildFilterCriteria($parameters, Request::getQueryString(), $dataSourceName);
            $dtoRequest = new DTO\Request\Filter($filterCriteria, $method, $cleanUri, $userId);
        } elseif($parameters) {
            $dataSet = $this->buildDataSet($parameters, $dataSourceName);
            $dtoRequest = new DTO\Request\DataSet($dataSet, $method, $cleanUri, $userId);
        } else {

            throw new \Exception("No data found to be set or update!");
        }
        
        $dtoRequest->setParameter(self::DATABASE_NAME, $dataSourceName);
        $dtoRequest->setParameter(self::IS_NEXT, true);
        
        return $dtoRequest;
    }
    
    /**
     * Removes base URI from received URI.
     *
     * @param string $uri Requested URI.
     *
     * @return string URI without base URi.
     */
    protected function removeBaseUri(string $uri) : string {
        $this->baseUri = rtrim($this->baseUri, ' /');
        return preg_replace('#(.*)(' . $this->baseUri . ')#', '', $uri);
    }
    
    /**
     * Removes query string from uri.
     *
     * @param string $uri
     *
     * @return string
     */
    private function removeQueryFromUri(string $uri) : string {
        $uri = explode('?', $uri);
        return $uri[0];
    }
    
    /**
     * Returns the current request
     *
     * @return Request
     */
    public function getHttpRequest() {
        if ($this->httpRequest === null) {
            $this->httpRequest = Request::initFromGlobals();
        }

        return $this->httpRequest;
    }
    
    /**
     * Builds the FilterCriteria.
     *
     * @param array  $parameters     The request parameters.
     * @param array  $arrayUri       The array with the elements of uri (without query).
     * @param array  $queryString    The request query string
     * @param string $dataSourceName The data source name
     *
     * @return FilterCriteria
     */
    private function buildFilterCriteria(array $parameters, string $queryString, string $dataSourceName) : FilterCriteria {
        $filterCriteria = new FilterCriteria($this->dataSourceName);
        $this->buildOrderBy($queryString, $parameters, $filterCriteria);
        $this->buildSearch($parameters, $filterCriteria);
        $this->buildSearchIn($queryString, $parameters, $filterCriteria);
        $this->buildPagination($parameters, $filterCriteria);
        $this->buildFunction($queryString, $parameters, $filterCriteria);
        $this->buildConditions($queryString, $parameters, $filterCriteria);
        $this->buildGroupBy($queryString, $parameters, $filterCriteria);
        return $filterCriteria;
    }
    
    /**
     * Builds the orderBy for the FilterCriteria object.
     *
     * @param string $queryString           The request query string.
     * @param array  $parameters            The request parameters.
     * @param FilterCriteria $filterCriteria The FilterCriteria object.
     */
    private function buildOrderBy(string $queryString, array &$parameters, FilterCriteria $filterCriteria) {
        if(preg_match_all("/(?:(?<=\border=))\w+\.\w+/", $queryString, $orderBy)) {
            foreach(reset($orderBy) as $order) {
                $orderArray = explode('.', $order);
                $filterCriteria->addOrderBy($orderArray[0], $orderArray[1]);
                unset($parameters["order"]);
            }
        }
    }
    
    /**
     * Builds the groupBy for the FilterCriteria object.
     *
     * @param string $queryString           The request query string.
     * @param array  $parameters            The request parameters.
     * @param FilterCriteria $filterCriteria The FilterCriteria object.
     */
    private function buildGroupBy(string $queryString, array &$parameters, FilterCriteria $filterCriteria) {
        if(preg_match_all("/(?:(?<=\bgroup=))\w+/", $queryString, $groupBy)) {
            foreach(reset($groupBy) as $group) {
                $filterCriteria->addGroupBy($group);
                unset($parameters["group"]);
            }
        }
    }
    
    /**
     * Builds the function for the FilterCriteria object.
     *
     * @param string $queryString           The request query string.
     * @param array  $parameters            The request parameters.
     * @param FilterCriteria $filterCriteria The FilterCriteria object.
     */
    private function buildFunction(string $queryString, array &$parameters, FilterCriteria $filterCriteria) {
        if(preg_match_all("/(?:(?<=\bfunc=))\w+\.\w+/", $queryString, $function)) {
            foreach(reset($function) as $func) {
                $funcArray = explode('.', $func);
                $filterCriteria->addFunction($funcArray[0], strtoupper($funcArray[1]));
                unset($parameters["func"]);
            }
        }
    }
    
    /**
     * Builds the search for the FilterCriteria object.
     *
     * @param array $parameteters            The request parameters.
     * @param FilterCriteria $filterCriteria The FilterCriteria object.
     */
    private function buildSearch(array &$parameters, FilterCriteria $filterCriteria) {
        if(isset($parameters["search"])){
            $values = explode(" ", $parameters["search"]);
            foreach ($values as $value) {
                $filterCriteria->addSearch($value);
            }
            unset($parameters['search']);
        }
    }
    
    /**
     * Builds the searchIn for the FilterCriteria object.
     *
     * @param string $queryString             The request query string.
     * @param array  $parameteters            The request parameters.
     * @param FilterCriteria $filterCriteria The FilterCriteria object.
     */
    private function buildSearchIn(string $queryString, array &$parameters, FilterCriteria $filterCriteria) {
        if(preg_match_all("/(?:(?<=\bsearch_in=))\w+/", $queryString, $searchIn)) {
            $filterCriteria->setSearchIn(reset($searchIn));
            unset($parameters['search_in']);
        }
    }
    
    /**
     * Builds the pagination for the FilterCriteria object.
     *
     * @param array $parameteters            The request parameters.
     * @param FilterCriteria $filterCriteria The FilterCriteria object.
     */
    private function buildPagination(array &$parameters, FilterCriteria $filterCriteria) {
        if(isset($parameters["page"])) {
            $filterCriteria->setPage(intval($parameters["page"]));
            unset($parameters["page"]);
            if(isset($parameters["limit"])) {
                $filterCriteria->setPageSize(intval($parameters["limit"]));
                unset($parameters["limit"]);
            }
        }
    }
    
    /**
     * Builds the conditions for the FilterCriteria object.
     *
     * @param string $queryString             The request query string.
     * @param array  $parameteters            The request parameters.
     * @param FilterCriteria $filterCriteria The FilterCriteria object.
     */
    private function buildConditions(string $queryString, array &$parameters, FilterCriteria $filterCriteria) {
        if (preg_match_all("/(?:(?<=\bin=))\w+/", $queryString, $in)) {
            foreach(reset($in) as $column) {
                $hasOperator = false;
                $operatorQuery = '';
                $params = array_filter($parameters, function($valor, $chave) use ($column){
                    return strpos($chave, $column.'_') !== false;
                }, ARRAY_FILTER_USE_BOTH);

                if(!empty($params)){
                    foreach($params as $paraKey => $paraValue){
                        $operatorQuery = substr($paraKey, strlen($column.'_'));
                        switch($operatorQuery){
                            case 'greater_than':
                                $filterCriteria->addCondition($column, '>', $parameters[$column.'_'.'greater_than']);
                                break;
                            case 'less_than':
                                $filterCriteria->addCondition($column, '<', $parameters[$column.'_'.'less_than']);
                                break;
                        }
                    }
                }elseif(is_array($parameters[$column]))
                            $filterCriteria->addCondition($column, 'IN', $parameters[$column]);
                        else
                            $filterCriteria->addCondition($column, $parameters[$column]);
            }
        }

    }
    
    /**
     * Get primary keys from a Data Source
     *
     * @param string $dataSourceName
     *
     * @return array
     */
    private function getPrimaryKeyColumns(string $dataSourceName) : array {
        return $this->nameProvider->getDataSourceByName($dataSourceName)->getPrimaryKeyColumns();
    }
    
    /**
     * Returns true if the request is to save or false if to update.
     *
     * @param string $method The requested method.
     *
     * @return bool Is new
     */
    private function getIsNew(string $method) : bool {
        return $method == 'POST' ? self::IS_SAVE : self::IS_UPDATE;
    }
    
     /**
     * Builds the DataSet.
     *
     * @param array  $parameters     The request parameters.
     * @param string $dataSourceName The data source name for dataset.
     *
     * @return DataSet
     */
    private function buildDataSet(array $parameters, string $dataSourceName) : DataSet {
        if(array_keys($parameters)[0] === 0)
            $dataSet = $parameters;
        else
            $dataSet = [$parameters];        
            
        return new DataSet($dataSourceName, $dataSet);
    }
    
    private function setPersistedDataOnResponse(DTO\Next\Response $response, string $dataSourceName, array $persistedData, bool $isDataSet) {
        if($isDataSet) {
            $response->setDataSet(new DataSet($dataSourceName, $persistedData));
        } else {
            if(array_keys($persistedData)[0] === 0)
                $persistedData = $persistedData[0];
                
            $response->setRow($persistedData);
        }
    }
    
}