<?php

namespace Teknisa\Libs\Util;

use Teknisa\Libs\Util\NewCode;
use Zeedhi\Framework\DataSource\DataSet;
use Zeedhi\Framework\DataSource\FilterCriteria;
use Zeedhi\Framework\DataSource\Manager;
use Zeedhi\Framework\DataSource\ParameterBag;
use Zeedhi\Framework\DTO;
use Zeedhi\Framework\DTO\Response\Message;
use ArrayObject;

class DataSource
{
    public $newCode;

    public function __construct(NewCode $newCode) {
        $this->newCode = $newCode;
    }

    public function changeConditionName($filterCriteria, $oldName, $newName, $operator = "=")
    {
        $filterArray = $filterCriteria->getConditions();
        $newFilterArray = array_map(function ($condition) use ($oldName, $newName, $operator) {
            if ($condition["columnName"] === $oldName && $condition["operator"] === $operator) {
                $condition["columnName"] = $newName;
            };
            return $condition;
        }, $filterArray);
        $newFilterCriteria = new FilterCriteria($filterCriteria->getDataSourceName(), $newFilterArray);
        return $newFilterCriteria;
    }

    public function getConditionByName($filterCriteria, $name, $operator = "=")
    {
        $searchedConditionArray = array_filter($filterCriteria->getConditions(), function ($filter) use ($name, $operator) {
            return $filter["columnName"] === $name && $filter["operator"] === $operator;
        });
        return array_pop($searchedConditionArray);
    }

    public function getUniqueKeyForTable($tableName, $nrOrg, $interval = 1, $colSize = 10)
    {
        return $this->newCode->getCodeByTableName($tableName, $nrOrg, $interval, $colSize);
    }

    public function coerceToDataSet(DTO\Request $request, $dataSourceName)
    {
        if ($request instanceof DTO\Request\Row) {
            $dataSet = new DataSet($dataSourceName, array(new ArrayObject($request->getRow())));
            $request = new DTO\Request\DataSet($dataSet, $request->getMethod(), $request->getRoutePath(), $request->getUserId());
        }
        return $request;
    }

    public function fillUniqueValueInRequestRows(DTO\Request $request, $pkColumn, $tableName, $nrorg)
    {

        if ($request instanceof DTO\Request\Row) {
            $row = $request->getRow();
            if ($row['__is_new']) {
                $row[$pkColumn] = $this->getUniqueKeyForTable($tableName, $nrorg);
            }
        } else {   //se trata de um Request\DataSet
            $dataSetRows = $request->getDataSet()->getRows();
            foreach ($dataSetRows as &$setRow) {
                if ($setRow['__is_new']) {
                    $setRow[$pkColumn] = $this->getUniqueKeyForTable($tableName, $nrorg);
                }
            }
        }
    }

    public static function toPlainText($input)
    {

        $input = preg_replace('"{\*?\\\\.+(;})|\\s?\\\[A-Za-z0-9]+|\\s?{\\s?\\\[A-Za-z0-9]+\\s?|\\s?}\\s?"', '', $input);

        return strtr($input,
            array(
                "\'e1" => "á",
                "\'e0" => "à",
                "\'e3" => "ã",
                "\'e2" => "â",
                "\'c1" => "Á",
                "\'c0" => "À",
                "\'c3" => "Ã",
                "\'c2" => "Â",
                "\'e9" => "é",
                "\'e8" => "è",
                "\'ea" => "ê",
                "\'c9" => "É",
                "\'c8" => "È",
                "\'ca" => "Ê",
                "\'ed" => "í",
                "\'ec" => "ì",
                "\'ee" => "î",
                "\'cd" => "Í",
                "\'cc" => "Ì",
                "\'ce" => "Î",
                "\'f3" => "ó",
                "\'f2" => "ò",
                "\'f5" => "õ",
                "\'f4" => "ô",
                "\'d3" => "Ó",
                "\'d2" => "Ò",
                "\'d5" => "Õ",
                "\'d4" => "Ô",
                "\'fa" => "ú",
                "\'f9" => "ù",
                "\'fb" => "û",
                "\'fc" => "ü",
                "\'da" => "Ú",
                "\'d9" => "Ù",
                "\'db" => "Û",
                "\'dc" => "Ü",
                "\'e7" => "ç",
                "\'c7" => "Ç",
                "\'aa" => "ª",
                "\'ba" => "º",
                "<br>" => "\n"
            )
        );
    }

    public function removeConditionFromFilter($filterCriteria, $name, $operator = "=")
    {
        $searchedConditionArray = array_filter($filterCriteria->getConditions(), function ($filter) use ($name, $operator) {
            return !($filter["columnName"] === $name && $filter["operator"] === $operator);
        });
        return new FilterCriteria($filterCriteria->getDataSourceName(), $searchedConditionArray);
    }
}