<?php

namespace Teknisa\Libs\Util\Repositories;

use Doctrine\DBAL\Exception;
use Teknisa\Libs\Util\Utilities;
use Teknisa\Libs\Util\InstanceProvider;

class AclLabels
{
    /**
     * @param $nrperfilacessoFilter
     * @param $nrorg
     * @return array[]
     * @throws Exception
     */
    public static function getLabelsByNrperfilacesso($nrperfilacessoFilter, $nrorg) {
        $query = "SELECT ID, NRPERFILACESSO, LABEL
                    FROM PERFILACESSO_LABEL
                   WHERE NRORG = :NRORG
                   $nrperfilacessoFilter";

        $params = array( 'NRORG' => $nrorg );
        $customEntityManager = InstanceProvider::getConnectionCustom()->updateVpdConnection($nrorg);
        $entityManager = empty($customEntityManager) ? Utilities::getEntityManager() : $customEntityManager;
        return $entityManager->getConnection()->fetchAllAssociative($query, $params);
    }
}
