<?php

require __DIR__ . "/../../../autoload.php";
require __DIR__ . "/../../../zeedhi/framework/bootstrap.php";
require_once './bootstrap.php';

$productBasePath = \Teknisa\Libs\Util\Utilities::getProductBasePath();
$db              = $productBasePath . 'backend/config/db.xml';
$environment     = $productBasePath . 'backend/config/environment.xml';
$general         = $productBasePath . 'backend/config/general.xml';
$parameters      = $productBasePath . 'backend/config/parameters.xml';

$instanceManager = \Zeedhi\Framework\DependencyInjection\InstanceManager::getInstance();
$instanceManager->loadFromFile('../config/modulesVersionParameters.xml');

if(realpath($db)) {
    $instanceManager->loadFromFile($db);
} else {
    throw new \Exception('O arquivo de configuração do banco de dados ("db.xml") não foi encontrado.');
}

if(realpath($environment)) $instanceManager->loadFromFile($environment);
if(realpath($general))     $instanceManager->loadFromFile($general);
if(realpath($parameters))  $instanceManager->loadFromFile($parameters);

$instanceManager->compile();