<?php

namespace Teknisa\Libs\Controller;

use Teknisa\Libs\Exception\CustomException;
use Teknisa\Libs\Util\Utilities;
use Zeedhi\Framework\DTO\Request;
use Zeedhi\Framework\DTO\Response;
use Zeedhi\Framework\DTO\Response\Error;
use Zeedhi\Framework\DataSource\DataSet;
use Teknisa\Libs\Util\Environment;
use Teknisa\Libs\Service\Menu as MenuService;


class Menu {
    /** @var  MenuService $menuService */
    private $menuService;

    /** @param MenuService $menuService */
    public function __construct(MenuService $menuService, Environment $environment) {
        $this->menuService = $menuService;
        $this->environment = $environment;
    }

    /**
     * @param Request\Filter $request
     * @param Response $response
     */
    public function buildMenu(Request\Filter $request, Response $response) {
        try {
            $conditions = $request->getFilterCriteria()->getConditions();
            $concatenateGroupMenu = Utilities::getValueInFilterDataSourceByName($conditions, 'CONCATENATE_GROUP_MENU');
            $visibleMenus         = Utilities::getValueInFilterDataSourceByName($conditions, 'VISIBLE_ELEMENTS');
            $expiredMenus         = Utilities::getValueInFilterDataSourceByName($conditions, 'EXPIRED_ELEMENTS');
            $urlOrigin            = Utilities::getValueInFilterDataSourceByName($conditions, 'URL_ORIGIN');
            $currentModule        = Utilities::getValueInFilterDataSourceByName($conditions, 'CURRENT_MODULE');
            $currentLanguage      = Utilities::getValueInFilterDataSourceByName($conditions, 'CURRENT_LANGUAGE');
            $routesAndMenu        = $this->menuService->buildMenu($concatenateGroupMenu, $visibleMenus, $expiredMenus, $urlOrigin,
                $currentModule, $currentLanguage);
            $response->addDataSet(new DataSet('menu', $routesAndMenu['MENUS']));
            $response->addDataSet(new DataSet('routesTranslate', $routesAndMenu['ROUTES_TRANSLATE']));
        } catch(CustomException $e) {
            $response->setError(Utilities::getErrorObjectFromException($e));
        }
    }
    
    /**
     * @param Request  $request
     * @param Response $response
     */
    public function findFavorites(Request $request, Response $response)
    {
        try {
            $operator = $this->environment->getCdOperador();
            $nrorg    = $this->environment->getNrOrgTrab();
            
            $favorites = $this->menuService->findFavorites($operator, $nrorg);
            
            $response->addDataSet(new DataSet('favorites', [$favorites]));
        } catch (\Exception $e) {
            $response->addMessage(new Response\Message($e->getMessage(), Response\Message::TYPE_ERROR));
        }
    }
    
    /**
     * @param Request  $request
     * @param Response $response
     */
    public function changeFavorites(Request $request, Response $response)
    {
        try {
            $operator = $this->environment->getCdOperador();
            $nrorg    = $this->environment->getNrOrgTrab();
            
            $row = $request->getDataSet()->getRows();
            
            $item   = $row[0]['item'];
            $status = $row[0]['status'];
            
            $this->menuService->changeFavorites($item, $status, $operator, $nrorg);
            
            $response->addDataSet(new DataSet('changeFavorites', []));
        } catch (\Exception $e) {
            $response->addMessage(new Response\Message($e->getMessage(), Response\Message::TYPE_ERROR));
        }
    }
} 