<?php

namespace Teknisa\Libs\Factory;

use Doctrine\ORM\EntityManager;
use Teknisa\Libs\Util\InstanceProvider;

class Notice {
    protected $entityManager;
    protected $connection;

    /**
     * @param EntityManager $entityManager
     */
    public function __construct(EntityManager $entityManager) {
        $this->entityManager = $entityManager;
        $this->connection = $entityManager->getConnection();
    }

    public function readNotification($nrinfecomoper, $notificationId, $cdoperador, $nrOrg) {
        $query = <<<SQL
        INSERT INTO INFORMATIVOECOMOPER
               (NRINFECOMOPER, NRINFECOMMERCE, CDOPERADOR, NRORG, IDATIVO, DTINCLUSAO, NRORGINCLUSAO, CDOPERINCLUSAO)
        VALUES (:NRINFECOMOPER, :NRINFECOMMERCE, :CDOPERADOR, :NRORG, 'S', SYSDATE, :NRORGINCLUSAO, :CDOPERINCLUSAO)
SQL;
        $params = array(
            "NRINFECOMOPER" => $nrinfecomoper,
            "NRINFECOMMERCE" => $notificationId,
            "CDOPERADOR" => $cdoperador,
            "NRORG"     => $nrOrg,
            "NRORGINCLUSAO" => $nrOrg,
            "CDOPERINCLUSAO"    => $cdoperador
        );
        $entityManager = InstanceProvider::getConnectionCustom()->updateVpdConnection($nrOrg);
        $entityManager = $entityManager ? $entityManager : InstanceProvider::getEntityManager();
        return $entityManager->getConnection()->executeQuery($query, $params);
    }

    public function getSilencersById($idSilencer, $nrorg)
    {
        $query =
            <<<SQL
                SELECT QTDIAS, CDPUBLICOALVO FROM INFORMATIVOECOMSILE
                WHERE ID = :ID
                AND IDATIVO = 'S'
                AND NRORG = :NRORG

SQL;
        $params = array (
            'ID' => $idSilencer,
            'NRORG' => $nrorg,
        );

        $result = InstanceProvider::getEntityManager()->getConnection()->fetchAll($query, $params);
        return $result;
    }

    public function getInforEcomOper($cdPublicoAlvo, $cdOperador, $nrOrg)
    {
        $query =
            <<<SQL
                SELECT ID, IDINFOECOMSILE FROM INFORMATIVOECOMSILEOPER
                WHERE CDPUBLICOALVO = :CDPUBLICOALVO
                AND CDOPERADOR = :CDOPERADOR
                AND IDATIVO = 'S'
                AND NRORG = :NRORG

SQL;
        $params = array(
            'CDOPERADOR' => $cdOperador,
            'CDPUBLICOALVO' => $cdPublicoAlvo,
            'NRORG' => $nrOrg
        );

        $result = InstanceProvider::getEntityManager()->getConnection()->fetchAll($query, $params);
        return $result;
    }

    public function saveUserNoticeSilence($connection, $id, $cdoperador, $cdPublicoAlvo, $dtInfoSile, $nrOrg, $idinfoecomsile)
    {
        $query = <<<SQL
        INSERT INTO INFORMATIVOECOMSILEOPER
               (ID, CDOPERADOR, CDPUBLICOALVO, DTINFOSILE, IDATIVO, NRORG, DTINCLUSAO, NRORGINCLUSAO, CDOPERINCLUSAO, IDINFOECOMSILE)
        VALUES (:ID, :CDOPERADOR, :CDPUBLICOALVO, :DTINFOSILE, 'S', :NRORG, SYSDATE, :NRORGINCLUSAO, :CDOPERINCLUSAO, :IDINFOECOMSILE)
SQL;
        $params = array(
            'ID' => $id,
            'CDOPERADOR' => $cdoperador,
            'CDPUBLICOALVO' => $cdPublicoAlvo,
            'DTINFOSILE'    => $dtInfoSile,
            'NRORG' => $nrOrg,
            'NRORGINCLUSAO' => $nrOrg,
            'CDOPERINCLUSAO' => $cdoperador,
            'IDINFOECOMSILE' => $idinfoecomsile
        );

        $connection->executeStatement($query, $params);
    }

    public function updateUserNoticeSilence($connection, $id, $dtInfoSile, $cdoperador, $nrorg, $idinfoecomsile)
    {
        $query = <<<SQL
        UPDATE INFORMATIVOECOMSILEOPER
            SET DTINFOSILE = :DTINFOSILE,
                NRORG = :NRORG,
                DTULTATU = SYSDATE,
                NRORGULTATU = :NRORGULTATU,
                CDOPERULTATU = :CDOPERULTATU,
                IDINFOECOMSILE = :IDINFOECOMSILE
        WHERE ID = :ID
SQL;
        $params = array(
            'ID' => $id,
            'DTINFOSILE' => $dtInfoSile,
            'NRORG' => $nrorg,
            'NRORGULTATU' => $nrorg,
            'CDOPERULTATU' => $cdoperador,
            'IDINFOECOMSILE' => $idinfoecomsile
        );

        $connection->executeStatement($query, $params);
    }
}