<?php

namespace Teknisa\Libs\Service;

use Doctrine\ORM\EntityManager;
use Teknisa\Libs\Factory\Notice as NoticeFactory;
use Teknisa\Libs\Util\InstanceProvider;

class Notice {
    protected $entityManager;

    /** @var  NoticeFactory $noticeFactory */
    private $noticeFactory;

    /**
     * @param EntityManager $entityManager
     */
    public function __construct(EntityManager $entityManager, NoticeFactory $noticeFactory) {
        $this->entityManager = $entityManager;
        $this->noticeFactory = $noticeFactory;
    }

    public function readNotification($nrinfecommerce, $cdOperador) {
        $environment = InstanceProvider::getEnvironment();
        $nrOrg = $environment->getCurrentOrganizationId();
        $newCodeService = InstanceProvider::getNewCode();
        $nrinfecomoper = $newCodeService->getCodeByTableName('INFORMATIVOECOMOPER', $nrOrg, 1, 10, true);
        $this->noticeFactory->readNotification($nrinfecomoper, $nrinfecommerce, $cdOperador, $nrOrg);
        $this->entityManager->flush();
    }

    public function saveUserNoticeSilence($row)
    {
        $noticesForTeknisaViewNotice = $row['noticesForTeknisaViewNotice'] ?? null;
        $noticesForInternalViewNotice = $row['noticesForInternalViewNotice'] ?? null;
        $dataRow = array ($noticesForTeknisaViewNotice, $noticesForInternalViewNotice);
        $connection = InstanceProvider::getEntityManager()->getConnection();
        $connection->beginTransaction();
        $environment = InstanceProvider::getEnvironment();
        $nrOrg = $environment->getCurrentOrganizationId();
        try {
            foreach($dataRow as $idSilencer) {
                if ($idSilencer !== null) {
                    $silencer =  $this->noticeFactory->getSilencersById($idSilencer, $nrOrg);
                    if ($silencer[0]['QTDIAS'] > 0) {
                        $cdoperador = $environment->getCdOperador();
                        $cdPublicoAlvo = $silencer[0]['CDPUBLICOALVO'];
                        $dtInfoSile = $this->getDtInfoSile($silencer[0]['QTDIAS']);
                        $inforEcomOper = $this->noticeFactory->getInforEcomOper($cdPublicoAlvo, $cdoperador, $nrOrg);
                        if (!empty($inforEcomOper)) {
                            $this->noticeFactory->updateUserNoticeSilence($connection, $inforEcomOper[0]['ID'], $dtInfoSile, $cdoperador, $nrOrg, $idSilencer);
                        } else {
                            $newCodeService = InstanceProvider::getNewCode();
                            $id = $newCodeService->getCodeByTableName('INFORMATIVOECOMSILEOPER', $nrOrg,  1, 10, true);
                            $this->noticeFactory->saveUserNoticeSilence($connection, $id, $cdoperador, $cdPublicoAlvo, $dtInfoSile, $nrOrg, $idSilencer);
                        }
                    }
                }
            }
            $connection->commit();
        } catch (\Exception $e) {
            $connection->rollback();
            throw $e;
        }
    }

    public function getDtInfoSile($daysToSilence)
    {
        $currentDate = new \DateTime();
        $targetDate = clone $currentDate;
        $targetDate->modify("+$daysToSilence days");
        $day = str_pad($targetDate->format('d'), 2, '0', STR_PAD_LEFT);
        $month = str_pad($targetDate->format('m'), 2, '0', STR_PAD_LEFT);
        $year = $targetDate->format('Y');
        $formattedDate = "$day/$month/$year";
        return $formattedDate;
    }
}