<?php

namespace Teknisa\Libs\Util\Repositories;

use Doctrine\ORM\EntityManager;
use Teknisa\Libs\Util\Utilities;

class CollectedData {
    /** @var EntityManager $entityManager */
    protected $entityManager;

    /**
     * @param EntityManager $entityManager
     */
    public function __construct(EntityManager $entityManager) {
        $this->entityManager = $entityManager;
    }

    public function setEntityManager($entityManager) {
        $this->entityManager = $entityManager;
    }

    /**
     * @param $productId
     * @param $collectionId
     * @param $organizationId
     * @return array
     */
    public function findCollectedData($productId, $collectionId, $organizationId) {
         $query =  <<<SQL
                    SELECT NRPRODUTO AS "NRPRODUTO",  IDCOLETA AS "IDCOLETA", "IDOPERACAO" AS "IDOPERACAO"
                    FROM DADOS_COLETADOS
                   WHERE NRPRODUTO = :NRPRODUTO
                     AND IDCOLETA  = :IDCOLETA
                     AND NRORG     = :NRORG
SQL;

        $params = array( 
            'NRPRODUTO' => $productId,
            'IDCOLETA'  => $collectionId,
            'NRORG'     => $organizationId
        );
        $result = $this->entityManager->getConnection()->fetchAll($query, $params);
        return !empty($result) ? $result[0] : $result;
    }

    /**
     * @param $productId
     * @param $collectionId
     * @param $operationId
     * @param $organizationId
     * @param $operatorCode
     * @return array
     */
    public function insertCollectedData($productId, $collectionId, $operationId, $organizationId, $operatorCode) {
         $query =  <<<SQL
                    INSERT INTO DADOS_COLETADOS
                         (NRORG, NRPRODUTO, IDCOLETA, IDOPERACAO,
                          NRORGINCLUSAO, DTINCLUSAO, CDOPERINCLUSAO,
                          NRORGULTATU, DTULTATU, CDOPERULTATU)
                  VALUES (:NRORG, :NRPRODUTO, :IDCOLETA, :IDOPERACAO,
                          :NRORG, TO_DATE(:NOW,'DD/MM/YYYY HH24:MI:SS'), :CDOPERADOR,
                          :NRORG, TO_DATE(:NOW,'DD/MM/YYYY HH24:MI:SS'), :CDOPERADOR)
SQL;

        $params = array(
            'NRPRODUTO'  => $productId,
            'IDCOLETA'   => $collectionId,
            'IDOPERACAO' => $operationId,
            "NOW"     => Utilities::getCurrentDateTimeString(),
            'NRORG'      => $organizationId,
            'CDOPERADOR' => $operatorCode
        );

        return $this->entityManager->getConnection()->executeQuery($query, $params);
    }

    /**
     * @param $productId
     * @param $collectionId
     * @param $operationId
     * @param $organizationId
     * @param $operatorCode
     * @return array
     */
    public function updateCollectedData($productId, $collectionId, $operationId, $organizationId, $operatorCode) {
         $query =  <<<SQL
                    UPDATE DADOS_COLETADOS
                     SET IDOPERACAO   = :IDOPERACAO,
                         CDOPERULTATU = :CDOPERADOR,
                         DTULTATU     = TO_DATE(:NOW,'DD/MM/YYYY HH24:MI:SS')
                   WHERE NRPRODUTO = :NRPRODUTO
                     AND IDCOLETA  = :IDCOLETA
                     AND NRORG     = :NRORG
SQL;

        $params = array (
            'NRPRODUTO'  => $productId,
            'IDCOLETA'   => $collectionId,
            'IDOPERACAO' => $operationId,
            "NOW"     => Utilities::getCurrentDateTimeString(),
            'NRORG'      => $organizationId,
            'CDOPERADOR' => $operatorCode
        );

        return $this->entityManager->getConnection()->executeQuery($query, $params);
    }

    /**
     * @param $idTipoOper
     * @param $dsOperacao
     * @param $cdPesqItem
     * @param $dsEndUsuOper
     * @param $dsNmUsuOper
     * @param $organizationId
     * @param $operatorCode
     * @param $operatorName
     * @return array
     */
    public function insertLogOpera($idTipoOper, $dsOperacao, $cdPesqItem, $dsEndUsuOper, $dsNmUsuOper, $organizationId, $operatorCode, $operatorName, $productId) {
         $query =  <<<SQL
                    INSERT INTO LOGOPERA
                         (NMTABELA, DTOPERACAO, NMRESPOPER, IDTIPOOPER, DSOPERACAO, CDPESQITEM, DSRDMUSUOPER, 
                          DSENDUSUOPER, DSNMUSUOPER, DSMETUSUOPER, CDORESPOPER, CDFILLOGOPER, 
                          NRORG, DTINCLUSAO, DTULTATU, NRORGINCLUSAO, CDOPERINCLUSAO, NRORGULTATU, CDOPERULTATU, IDATIVO)
                  VALUES ('DADOS_COLETADOS', TO_DATE(:NOW,'DD/MM/YYYY HH24:MI:SS'), :NMOPERADOR, :IDTIPOOPER, :DSOPERACAO, :CDPESQITEM, 'LIB',
                          :DSENDUSUOPER, :DSNMUSUOPER, :DSMETUSUOPER, :CDOPERADOR, NULL,
                          :NRORG, TO_DATE(:NOW,'DD/MM/YYYY HH24:MI:SS'), TO_DATE(:NOW,'DD/MM/YYYY HH24:MI:SS'), :NRORG, :CDOPERADOR, :NRORG, :CDOPERADOR, 'S')
SQL;

        $params = array(
            'IDTIPOOPER'   => $idTipoOper,
            'DSOPERACAO'   => substr($dsOperacao, 0, 700),
            'CDPESQITEM'   => substr($cdPesqItem, 0, 80),
            'DSENDUSUOPER' => substr($dsEndUsuOper, 0, 50),
            'DSNMUSUOPER'  => substr($dsNmUsuOper, 0, 50),
            'NRORG'        => $organizationId,
            'CDOPERADOR'   => $operatorCode,
            "NOW"          => Utilities::getCurrentDateTimeString(),
            'NMOPERADOR'   => substr($operatorName, 0, 40),
            'DSMETUSUOPER' => 'saveCollectedData:' . $productId,
        );

        return $this->entityManager->getConnection()->executeQuery($query, $params);
    }
}