<?php

namespace Teknisa\Libs\Util\Repositories;

use Teknisa\Libs\Util\Utilities;
use Zeedhi\Framework\ORM\DateTime;

class RotiGeraAFData {
    
    protected $connection;
    protected $entityManager;

    public function __construct($entityManager, $connection) {
        $this->entityManager    = $entityManager;
        $this->connection       = $connection;
    }
    
    public function CONSISTE_ORCAMENTO($stFilDest, $stFilLanc, $stNrAF) {
        $connection = $this->entityManager->getConnection();
        $procedure = new StoredProcedure($connection, 'CONSISTE_ORCAMENTO');
        $procedure->addParam(new Param('P_CDFILDEST', Param::PARAM_INPUT, $stFilDest, Param::PARAM_TYPE_STR));
        $procedure->addParam(new Param('P_CDFILLANC', Param::PARAM_INPUT, $stFilLanc, Param::PARAM_TYPE_STR));
        $procedure->addParam(new Param('P_NRAUTOFORN', Param::PARAM_INPUT, $stNrAF, Param::PARAM_TYPE_STR));
        $procedure->execute();
    }

    public function adqRelValor_AF($stFilDest, $stFilLanc, $stNrAF){
        $query = <<<SQL
                  SELECT AUTOFORNE.VRTOTALAF AS "VRTOTALAF", COMPRADOR.VRLIMAFCOMP AS "VRLIMAFCOMP"
                    FROM
                      AUTOFORNE,
                      COMPRADOR
                    WHERE
                      AUTOFORNE.CDFILDEST   = :P_CDFILDEST AND
                      AUTOFORNE.CDFILLANC   = :P_CDFILLANC AND
                      AUTOFORNE.NRAUTOFORN  = :P_NRAUTOFORN AND
                      AUTOFORNE.CDOPERADOR  = COMPRADOR.CDOPERADOR AND
                      AUTOFORNE.VRTOTALAF > COMPRADOR.VRLIMAFCOMP
SQL;

        $params = array(
            'P_CDFILDEST'       => $stFilDest,
    	    'P_CDFILLANC'       => $stFilLanc,
        	'P_NRAUTOFORN'      => $stNrAF
        );
        $stmt   = $this->connection->prepare($query);
        $stmt->execute($params);
        $result = $stmt->fetchAll();

        return $result;
    }

    public function adqRelValor_AF_Mes($stFilDest, $stFilLanc, $stNrAF, $stOper){
        $query = <<<SQL
                  SELECT SOMAAF AS "SOMAAF", COMPRADOR.VRLIMAFMES AS "VRLIMAFMES"
                    FROM COMPRADOR, AUTOFORNE,
                      (SELECT SUM(VRTOTALAF) AS SOMAAF
                       FROM AUTOFORNE
                       WHERE  AUTOFORNE.DTMESAUTOFOR =
                                     (SELECT DTMESAUTOFOR
                                      FROM AUTOFORNE
                                      WHERE CDFILDEST = :P_CDFILDEST AND
                                            CDFILLANC = :P_CDFILLANC AND
                                            NRAUTOFORN= :P_NRAUTOFORN) AND
                       CDFILDEST  = :P_CDFILDEST AND
                       CDOPERADOR = :P_CDOPERADOR
                    ) SUMVRTOTALAF
                    WHERE (AUTOFORNE.CDFILDEST = :P_CDFILDEST) AND
                          (AUTOFORNE.CDFILLANC = :P_CDFILLANC) AND
                          (AUTOFORNE.NRAUTOFORN= :P_NRAUTOFORN) AND
                          (AUTOFORNE.CDOPERADOR = COMPRADOR.CDOPERADOR) AND
                          SOMAAF > COMPRADOR.VRLIMAFMES
SQL;

        $params = array(
            'P_CDFILDEST'       => $stFilDest,
    	    'P_CDFILLANC'       => $stFilLanc,
        	'P_NRAUTOFORN'      => $stNrAF,
        	'P_CDOPERADOR'      => $stOper
        );
        $stmt   = $this->connection->prepare($query);
        $stmt->execute($params);
        $result = $stmt->fetchAll();

        return $result;
    }

    public function adqRelQuant_TotalAF($stFilDest, $stFilLanc, $stNrAF){
        $query = <<<SQL
                  SELECT QUANT_TOTAL AS "QUANT_TOTAL", FORNECEDOR.QTMINAUTFOT AS "QTMINAUTFOT"
                    FROM AUTOFORNE, FORNECEDOR,
                         (SELECT SUM(QUANT) AS QUANT_TOTAL
                          FROM
                          (SELECT SUM(ITEMAUTF.QTPROGENTAF * PRODUTO.VRFATOCONV) AS QUANT
                           FROM ITEMAUTF, AUTOFORNE, FORNECEDOR, PRODUTO, PRODUTO PRODESTO
                           WHERE AUTOFORNE.CDFILDEST  = :P_CDFILDEST          AND
                                 AUTOFORNE.CDFILLANC  = :P_CDFILLANC          AND
                                 AUTOFORNE.NRAUTOFORN = :P_NRAUTOFORN         AND
                                 AUTOFORNE.CDFILDEST  = ITEMAUTF.CDFILDEST    AND
                                 AUTOFORNE.CDFILLANC  = ITEMAUTF.CDFILLANC    AND
                                 AUTOFORNE.NRAUTOFORN = ITEMAUTF.NRAUTOFORN   AND
                                 AUTOFORNE.CDFORNECED = FORNECEDOR.CDFORNECED AND
                                 ITEMAUTF.CDPRODUTO   = PRODUTO.CDPRODUTO     AND
                                 PRODUTO.CDPRODESTO   = PRODESTO.CDPRODUTO    AND
                                 PRODESTO.SGUNIDADE   =  FORNECEDOR.SGUNIDADE
                           UNION ALL
                           SELECT SUM(ITEMAUTF.QTPROGENTAF * PRODUTO.VRFATOCONV / CONVPRODUTO.VRFATOCONVES) AS QUANT
                           FROM ITEMAUTF, AUTOFORNE, FORNECEDOR, PRODUTO, PRODUTO PRODESTO, CONVPRODUTO
                           WHERE
                              AUTOFORNE.CDFILDEST  = :P_CDFILDEST          AND
                              AUTOFORNE.CDFILLANC  = :P_CDFILLANC          AND
                              AUTOFORNE.NRAUTOFORN = :P_NRAUTOFORN         AND
                              AUTOFORNE.CDFILDEST  = ITEMAUTF.CDFILDEST    AND
                              AUTOFORNE.CDFILLANC  = ITEMAUTF.CDFILLANC    AND
                              AUTOFORNE.NRAUTOFORN = ITEMAUTF.NRAUTOFORN   AND
                              AUTOFORNE.CDFORNECED = FORNECEDOR.CDFORNECED AND
                              ITEMAUTF.CDPRODUTO   = PRODUTO.CDPRODUTO     AND
                              PRODUTO.CDPRODESTO   =  PRODESTO.CDPRODUTO AND
                              PRODESTO.SGUNIDADE   <> FORNECEDOR.SGUNIDADE AND
                              CONVPRODUTO.CDPRODUTO = PRODUTO.CDPRODESTO AND
                              CONVPRODUTO.SGUNIDADE = FORNECEDOR.SGUNIDADE)
                          )
                    
                    WHERE   AUTOFORNE.CDFILDEST = :P_CDFILDEST AND
                            AUTOFORNE.CDFILLANC = :P_CDFILLANC AND
                            AUTOFORNE.NRAUTOFORN =:P_NRAUTOFORN AND
                            AUTOFORNE.CDFORNECED = FORNECEDOR.CDFORNECED AND
                            Quant_total < FORNECEDOR.QTMINAUTFOT AND
                            NOT EXISTS(SELECT MINFORNREG.CDREGIAO
                                       FROM MINFORNREG, FILIAL
                                       WHERE FILIAL.CDFILIAL = AUTOFORNE.CDFILDEST AND
                                             MINFORNREG.CDREGIAO = FILIAL.CDREGIAO AND
                                             MINFORNREG.CDFORNECED = AUTOFORNE.CDFORNECED AND
                                             MINFORNREG.QTMINFORNREG >= 0 AND
                                             MINFORNREG.QTMINFORNREG IS NOT NULL)
SQL;

        $params = array(
            'P_CDFILDEST'       => $stFilDest,
    	    'P_CDFILLANC'       => $stFilLanc,
        	'P_NRAUTOFORN'      => $stNrAF
        );
        $stmt   = $this->connection->prepare($query);
        $stmt->execute($params);
        $result = $stmt->fetchAll();

        return $result;
    }
    
    public function adqRelQuant_FornReg($stFilDest, $stFilLanc, $stNrAF){
        $query = <<<SQL
                  SELECT QUANT_TOTAL AS "QUANT_TOTAL", MINFORNREG.QTMINFORNREG AS "QTMINFORNREG"
                    FROM AUTOFORNE, MINFORNREG, FILIAL,
                         (SELECT SUM(QUANT) AS QUANT_TOTAL
                          FROM
                          (SELECT SUM(ITEMAUTF.QTPROGENTAF * PRODUTO.VRFATOCONV) AS QUANT
                           FROM ITEMAUTF, AUTOFORNE, FORNECEDOR, PRODUTO, PRODUTO PRODESTO
                           WHERE AUTOFORNE.CDFILDEST  = :P_CDFILDEST          AND
                                 AUTOFORNE.CDFILLANC  = :P_CDFILLANC          AND
                                 AUTOFORNE.NRAUTOFORN = :P_NRAUTOFORN         AND
                                 AUTOFORNE.CDFILDEST  = ITEMAUTF.CDFILDEST    AND
                                 AUTOFORNE.CDFILLANC  = ITEMAUTF.CDFILLANC    AND
                                 AUTOFORNE.NRAUTOFORN = ITEMAUTF.NRAUTOFORN   AND
                                 AUTOFORNE.CDFORNECED = FORNECEDOR.CDFORNECED AND
                                 ITEMAUTF.CDPRODUTO   = PRODUTO.CDPRODUTO     AND
                                 PRODUTO.CDPRODESTO   = PRODESTO.CDPRODUTO    AND
                                 PRODESTO.SGUNIDADE   =  FORNECEDOR.SGUNIDADE
                           UNION ALL
                           SELECT SUM(ITEMAUTF.QTPROGENTAF * PRODUTO.VRFATOCONV / CONVPRODUTO.VRFATOCONVES) AS QUANT
                           FROM ITEMAUTF, AUTOFORNE, FORNECEDOR, PRODUTO, PRODUTO PRODESTO, CONVPRODUTO
                           WHERE
                              AUTOFORNE.CDFILDEST  = :P_CDFILDEST          AND
                              AUTOFORNE.CDFILLANC  = :P_CDFILLANC          AND
                              AUTOFORNE.NRAUTOFORN = :P_NRAUTOFORN         AND
                              AUTOFORNE.CDFILDEST  = ITEMAUTF.CDFILDEST    AND
                              AUTOFORNE.CDFILLANC  = ITEMAUTF.CDFILLANC    AND
                              AUTOFORNE.NRAUTOFORN = ITEMAUTF.NRAUTOFORN   AND
                              AUTOFORNE.CDFORNECED = FORNECEDOR.CDFORNECED AND
                              ITEMAUTF.CDPRODUTO   = PRODUTO.CDPRODUTO     AND
                              PRODUTO.CDPRODESTO   =  PRODESTO.CDPRODUTO AND
                              PRODESTO.SGUNIDADE   <> FORNECEDOR.SGUNIDADE AND
                              CONVPRODUTO.CDPRODUTO = PRODUTO.CDPRODESTO AND
                              CONVPRODUTO.SGUNIDADE = FORNECEDOR.SGUNIDADE) QTDE
                          ) QTDETOTAL
                    
                    WHERE   AUTOFORNE.CDFILDEST  = :P_CDFILDEST AND
                            AUTOFORNE.CDFILLANC  = :P_CDFILLANC AND
                            AUTOFORNE.NRAUTOFORN = :P_NRAUTOFORN AND
                            AUTOFORNE.CDFILDEST  = FILIAL.CDFILIAL AND
                            AUTOFORNE.CDFORNECED = MINFORNREG.CDFORNECED AND
                            FILIAL.CDREGIAO      = MINFORNREG.CDREGIAO AND
                            Quant_total < MINFORNREG.QTMINFORNREG
SQL;

        $params = array(
            'P_CDFILDEST'       => $stFilDest,
    	    'P_CDFILLANC'       => $stFilLanc,
        	'P_NRAUTOFORN'      => $stNrAF
        );
        $stmt   = $this->connection->prepare($query);
        $stmt->execute($params);
        $result = $stmt->fetchAll();

        return $result;
    }
    
    public function adqRelValorAF_MinForn($stFilDest, $stFilLanc, $stNrAF){
        $query = <<<SQL
                  SELECT  AUTOFORNE.VRTOTALAF AS "VRTOTALAF", FORNECEDOR.VRMINAUTFOR AS "VRMINAUTFOR" 
                    FROM AUTOFORNE, FORNECEDOR
                    WHERE AUTOFORNE.CDFILDEST = :P_CDFILDEST AND
                          AUTOFORNE.CDFILLANC = :P_CDFILLANC AND
                          AUTOFORNE.NRAUTOFORN= :P_NRAUTOFORN AND
                          AUTOFORNE.CDFORNECED= FORNECEDOR.CDFORNECED AND
                          AUTOFORNE.VRTOTALAF < FORNECEDOR.VRMINAUTFOR AND
                          NOT EXISTS(SELECT MINFORNREG.CDREGIAO
                                     FROM MINFORNREG, FILIAL
                                     WHERE FILIAL.CDFILIAL = AUTOFORNE.CDFILDEST AND
                                           MINFORNREG.CDREGIAO = FILIAL.CDREGIAO AND
                                           MINFORNREG.CDFORNECED = AUTOFORNE.CDFORNECED AND
                                           MINFORNREG.VRMINFORNREG >= 0 AND
                                           MINFORNREG.VRMINFORNREG IS NOT NULL)
SQL;

        $params = array(
            'P_CDFILDEST'       => $stFilDest,
    	    'P_CDFILLANC'       => $stFilLanc,
        	'P_NRAUTOFORN'      => $stNrAF
        );
        $stmt   = $this->connection->prepare($query);
        $stmt->execute($params);
        $result = $stmt->fetchAll();

        return $result;
    }
    
    public function adqRelValorAF_MinFornReg($stFilDest, $stFilLanc, $stNrAF){
        $query = <<<SQL
                  SELECT  AUTOFORNE.VRTOTALAF AS "VRTOTALAF", MINFORNREG.VRMINFORNREG AS "VRMINFORNREG" 
                    WHERE AUTOFORNE.CDFILDEST  = :P_CDFILDEST AND
                          AUTOFORNE.CDFILLANC  = :P_CDFILLANC AND
                          AUTOFORNE.NRAUTOFORN = :P_NRAUTOFORN AND
                          AUTOFORNE.CDFILDEST  = FILIAL.CDFILIAL AND
                          AUTOFORNE.CDFORNECED = MINFORNREG.CDFORNECED AND
                          FILIAL.CDREGIAO      = MINFORNREG.CDREGIAO AND
                          AUTOFORNE.VRTOTALAF  < MINFORNREG.VRMINFORNREG
SQL;
        $params = array(
            'P_CDFILDEST'       => $stFilDest,
    	    'P_CDFILLANC'       => $stFilLanc,
        	'P_NRAUTOFORN'      => $stNrAF
        );
        $stmt   = $this->connection->prepare($query);
        $stmt->execute($params);
        $result = $stmt->fetchAll();

        return $result;
    }
    
    public function adqCentCompra($stFilDest){
        $query = <<<SQL
                  SELECT NVL(CDFILCENTCMP, CDFILIAL) AS "CDFILCENTCMP", CDREGIAO AS "CDREGIAO"
                     FROM FILIAL
                     WHERE CDFILIAL = :P_CDFILIAL
SQL;
        $params = array(
            'P_CDFILIAL' => $stFilDest
        );
        $stmt   = $this->connection->prepare($query);
        $stmt->execute($params);
        $result = $stmt->fetchAll();

        return $result;
    }
    
    public function adqParaSupriCentCmp($cdfilcentcmp){
        $query = <<<SQL
                  SELECT IDQTCOTPROD AS "IDQTCOTPROD"
                     FROM PARASUPRI
                     WHERE CDFILIAL = :P_CDFILIAL
SQL;
        $params = array(
            'P_CDFILIAL' => $cdfilcentcmp
        );
        $stmt   = $this->connection->prepare($query);
        $stmt->execute($params);
        $result = $stmt->fetchAll();

        return $result;
    }

    public function adqRelProdutos($stFilDest, $stFilLanc, $stNrAF){
        $query = <<<SQL
                  SELECT DISTINCT
                       ITEMAUTF.CDPRODUTO AS "CDPRODUTO",
                       PRODUTO.NMPRODUTO AS "NMPRODUTO",
                       PRODUTO.CDARVPROD AS "CDARVPROD",
                       PRODUTO.CDPRODESTO AS "CDPRODESTO",
                       ITEMAUTF.DTPROGENTAF AS "DTPROGENTAF",
                       ITEMAUTF.CDMARCA AS "CDMARCA",
                       PRODUTO.VRFATOCONV AS "VRFATOCONV",
                       ITEMAUTF.VRPREUNIAF AS "VRPREUNIAF",
                       AUTOFORNE.IDAUTOFORNEX AS "IDAUTOFORNEX"
                    FROM ITEMAUTF, PRODUTO, AUTOFORNE
                    WHERE
                     PRODUTO.CDPRODUTO   = ITEMAUTF.CDPRODUTO AND
                     ITEMAUTF.CDFILDEST  = :P_CDFILDEST  AND
                     ITEMAUTF.CDFILLANC  = :P_CDFILLANC  AND
                     ITEMAUTF.NRAUTOFORN = :P_NRAUTOFORN AND
                     ITEMAUTF.CDFILDEST  = AUTOFORNE.CDFILDEST  AND
                     ITEMAUTF.CDFILLANC  = AUTOFORNE.CDFILLANC  AND
                     ITEMAUTF.NRAUTOFORN = AUTOFORNE.NRAUTOFORN
SQL;
        $params = array(
            'P_CDFILDEST'       => $stFilDest,
    	    'P_CDFILLANC'       => $stFilLanc,
        	'P_NRAUTOFORN'      => $stNrAF
        );
        $stmt   = $this->connection->prepare($query);
        $stmt->execute($params);
        $result = $stmt->fetchAll();

        return $result;
    }
    
    public function adqParametro($stFilDest){
        $query = <<<SQL
                  SELECT P.IDUTILCONSSOLIOL AS "IDUTILCONSSOLIOL"
                     FROM PARASUPRI P, FILIAL F
                     WHERE F.CDFILIAL = :P_CDFILIAL
SQL;
        $params = array(
            'P_CDFILIAL' => $stFilDest
        );
        $stmt   = $this->connection->prepare($query);
        $stmt->execute($params);
        $result = $stmt->fetchAll();

        return $result;
    }
    
    public function adqRelValorAF_Prod($stFilDest, $stFilLanc, $stNrAF, $stOper, $cdproduto){
        $query = <<<SQL
                  SELECT  SOMAAF AS "SOMAAF", LIMPRODAF AS "LIMPRODAF".VRLIMPRODAF AS "VRLIMPRODAF" 
                    FROM LIMPRODAF, AUTOFORNE, PRODUTO, PRODUTO P,
                       (SELECT
                          PRODUTO,
                          SUM(VRPRODUTO)  -
                          NVL(SUM(VRDESCONTO), 0) +
                          NVL(SUM(VRIMPOSTO), 0) AS SOMAAF
                        FROM
                          (
                          SELECT
                             SUM(ITEMAUTF.QTPROGENTAF * ITEMAUTF.VRPREUNIAF) AS VRPRODUTO,
                             SUM((ITEMAUTF.QTPROGENTAF * ITEMAUTF.VRPREUNIAF *
                                  ITEMAUTF.VRPERDESAF) / 100)                AS VRDESCONTO,
                             SUM(0) AS VRIMPOSTO,
                             ITEMAUTF.CDPRODUTO AS PRODUTO
                          FROM
                             ITEMAUTF
                          WHERE
                             ITEMAUTF.CDFILDEST   = :P_CDFILDEST  AND
                             ITEMAUTF.CDFILLANC   = :P_CDFILLANC  AND
                             ITEMAUTF.NRAUTOFORN  = :P_NRAUTOFORN AND
                             ITEMAUTF.CDPRODUTO   = :P_CDPRODUTO
                          GROUP BY ITEMAUTF.CDPRODUTO
                    
                          UNION
                    
                          SELECT
                             SUM(0) AS VRPRODUTO,
                             SUM(0) AS VRDESCONTO,
                             SUM(IMPITMAF.VRADIMPAF) AS VRIMPOSTO,
                             ITEMAUTF.CDPRODUTO AS PRODUTO
                          FROM
                             IMPITMAF,
                             ITEMAUTF
                          WHERE
                             IMPITMAF.CDFILDEST   = :P_CDFILDEST         AND
                             IMPITMAF.CDFILLANC   = :P_CDFILLANC         AND
                             IMPITMAF.NRAUTOFORN  = :P_NRAUTOFORN       AND
                             IMPITMAF.CDFILDEST   = ITEMAUTF.CDFILDEST   AND
                             IMPITMAF.CDFILLANC   = ITEMAUTF.CDFILLANC   AND
                             IMPITMAF.NRAUTOFORN  = ITEMAUTF.NRAUTOFORN  AND
                             IMPITMAF.CDPRODUTO   = ITEMAUTF.CDPRODUTO   AND
                             IMPITMAF.CDMARCA     = ITEMAUTF.CDMARCA     AND
                             IMPITMAF.DTPROGENTAF = ITEMAUTF.DTPROGENTAF AND
                             ITEMAUTF.CDPRODUTO   = :P_CDPRODUTO
                          GROUP BY ITEMAUTF.CDPRODUTO
                    
                          )
                          GROUP BY PRODUTO)
                    
                    WHERE PRODUTO.CDPRODUTO = PRODUTO AND
                          (AUTOFORNE.CDFILDEST = :P_CDFILDEST) AND
                          (AUTOFORNE.CDFILLANC = :P_CDFILLANC) AND
                          (AUTOFORNE.NRAUTOFORN= :P_NRAUTOFORN) AND
                          AUTOFORNE.CDOPERADOR = LIMPRODAF.CDOPERADOR AND
                          P.CDPRODUTO = LIMPRODAF.CDPRODUTO AND
                          P.CDARVPROD =
                                          (SELECT MAX(PR.CDARVPROD)
                                           FROM LIMPRODAF, PRODUTO PR
                                           WHERE PR.CDPRODUTO = LIMPRODAF.CDPRODUTO AND
                                                 LIMPRODAF.CDOPERADOR = :P_CDOPERADOR AND
                                                 INSTR(PRODUTO.CDARVPROD, PR.CDARVPROD)= 1) AND
                          SOMAAF > LIMPRODAF.VRLIMPRODAF
SQL;
        $params = array(
            'P_CDFILDEST'       => $stFilDest,
    	    'P_CDFILLANC'       => $stFilLanc,
        	'P_NRAUTOFORN'      => $stNrAF,
        	'P_CDOPERADOR'      => $stOper,
        	'P_CDPRODUTO'       => $cdproduto
        );
        $stmt   = $this->connection->prepare($query);
        $stmt->execute($params);
        $result = $stmt->fetchAll();

        return $result;
    }
    
    public function adqRelValorAF_ProdMes($stFilDest, $stFilLanc, $stNrAF, $stOper, $cdproduto){
        $query = <<<SQL
                  SELECT SOMAAF AS "SOMAAF", LIMPRODAF.VRLIMPRAFMES AS "VRLIMPRAFMES"
                    FROM LIMPRODAF, AUTOFORNE, PRODUTO, PRODUTO P,
                     ( (SELECT
                          PRODUTO,
                          SUM(VRPRODUTO)  -
                          NVL(SUM(VRDESCONTO), 0) + 
                          NVL(SUM(VRIMPOSTO), 0) AS SOMAAF
                        FROM 
                          (
                          SELECT
                             SUM(ITEMAUTF.QTPROGENTAF * ITEMAUTF.VRPREUNIAF) AS VRPRODUTO,
                             SUM((ITEMAUTF.QTPROGENTAF * ITEMAUTF.VRPREUNIAF *
                                  ITEMAUTF.VRPERDESAF) / 100)                AS VRDESCONTO,
                             SUM(0) AS VRIMPOSTO, ITEMAUTF.CDPRODUTO AS PRODUTO
                           FROM ITEMAUTF,
                                AUTOFORNE
                           WHERE
                              AUTOFORNE.CDFILDEST = ITEMAUTF.CDFILDEST AND
                              AUTOFORNE.CDFILLANC = ITEMAUTF.CDFILLANC AND
                              AUTOFORNE.NRAUTOFORN= ITEMAUTF.NRAUTOFORN AND
                              ITEMAUTF.CDPRODUTO   = :P_CDPRODUTO AND
                              AUTOFORNE.DTMESAUTOFOR =
                                     (SELECT DTMESAUTOFOR
                                      FROM AUTOFORNE
                                      WHERE
                                      AUTOFORNE.CDFILDEST = :P_CDFILDEST AND
                                      AUTOFORNE.CDFILLANC = :P_CDFILLANC AND
                                      AUTOFORNE.NRAUTOFORN= :P_NRAUTOFORN) AND
                              AUTOFORNE.CDFILDEST = :P_CDFILDEST AND
                              AUTOFORNE.CDOPERADOR = :P_CDOPERADOR
                           GROUP BY ITEMAUTF.CDPRODUTO
                    
                          UNION
                    
                          SELECT
                             SUM(0) AS VRPRODUTO,
                             SUM(0) AS VRDESCONTO,
                             SUM(IMPITMAF.VRADIMPAF) AS VRIMPOSTO,
                             ITEMAUTF.CDPRODUTO AS PRODUTO
                    
                          FROM
                             IMPITMAF,
                             ITEMAUTF,
                             AUTOFORNE
                          WHERE
                             IMPITMAF.CDFILDEST   = ITEMAUTF.CDFILDEST   AND
                             IMPITMAF.CDFILLANC   = ITEMAUTF.CDFILLANC   AND
                             IMPITMAF.NRAUTOFORN  = ITEMAUTF.NRAUTOFORN  AND
                             IMPITMAF.CDPRODUTO   = ITEMAUTF.CDPRODUTO   AND
                             IMPITMAF.CDMARCA     = ITEMAUTF.CDMARCA     AND
                             IMPITMAF.DTPROGENTAF = ITEMAUTF.DTPROGENTAF AND
                             AUTOFORNE.CDFILDEST = ITEMAUTF.CDFILDEST    AND
                             AUTOFORNE.CDFILLANC = ITEMAUTF.CDFILLANC    AND
                             AUTOFORNE.NRAUTOFORN= ITEMAUTF.NRAUTOFORN   AND
                             ITEMAUTF.CDPRODUTO   = :P_CDPRODUTO AND
                             AUTOFORNE.DTMESAUTOFOR =
                                    (SELECT DTMESAUTOFOR
                                     FROM AUTOFORNE
                                     WHERE
                                      AUTOFORNE.CDFILDEST = :P_CDFILDEST AND
                                      AUTOFORNE.CDFILLANC = :P_CDFILLANC  AND
                                      AUTOFORNE.NRAUTOFORN= :P_NRAUTOFORN) AND
                             AUTOFORNE.CDFILDEST = :P_CDFILDEST AND
                             AUTOFORNE.CDOPERADOR = :P_CDOPERADOR
                          GROUP BY ITEMAUTF.CDPRODUTO
                          )
                          GROUP BY PRODUTO
                          ))
                    
                    
                    WHERE  PRODUTO.CDPRODUTO = PRODUTO AND
                          (AUTOFORNE.CDFILDEST = :P_CDFILDEST) AND
                          (AUTOFORNE.CDFILLANC = :P_CDFILLANC) AND
                          (AUTOFORNE.NRAUTOFORN= :P_NRAUTOFORN) AND
                          (AUTOFORNE.CDOPERADOR= LIMPRODAF.CDOPERADOR) AND
                          (P.CDPRODUTO = LIMPRODAF.CDPRODUTO) AND
                          P.CDARVPROD =
                                          (SELECT MAX(PR.CDARVPROD)
                                           FROM LIMPRODAF, PRODUTO PR
                                           WHERE PR.CDPRODUTO = LIMPRODAF.CDPRODUTO AND
                                                 LIMPRODAF.CDOPERADOR = :P_CDOPERADOR AND
                                                 INSTR(PRODUTO.CDARVPROD, PR.CDARVPROD)= 1) AND
                          SOMAAF > LIMPRODAF.VRLIMPRAFMES
SQL;
        $params = array(
            'P_CDFILDEST'       => $stFilDest,
    	    'P_CDFILLANC'       => $stFilLanc,
        	'P_NRAUTOFORN'      => $stNrAF,
        	'P_CDOPERADOR'      => $stOper,
        	'P_CDPRODUTO'       => $cdproduto
        );
        $stmt   = $this->connection->prepare($query);
        $stmt->execute($params);
        $result = $stmt->fetchAll();

        return $result;
    }
    
    public function adqLimNvAf($stOper, $cdarvprod){
        $query = <<<SQL
                  SELECT MAX(B.CDARVPROD) AS "CDARVPROD"
                      FROM LIMNIVELAF A, PRODUTO B
                     WHERE (A.CDPRODUTO   = B.CDPRODUTO)
                       AND (A.CDOPERADOR  = :P_CDOPERADOR)
                       AND (INSTR(:P_CDPRODUTO, B.CDARVPROD) = 1)
SQL;
        $params = array(
        	'P_CDOPERADOR'      => $stOper,
        	'P_CDPRODUTO'       => $cdarvprod
        );
        $stmt   = $this->connection->prepare($query);
        $stmt->execute($params);
        $result = $stmt->fetchAll();

        return $result;
    }
    
    public function adqRelValorAF_NVProd($stFilDest, $stFilLanc, $stNrAF, $cdarvprod){
        $query = <<<SQL
                  SELECT
                       SUM(SOMAAF) AS "SOMAAF",
                       VRLIMNIVELAF AS "VRLIMNIVELAF"
                    FROM
                       (SELECT  SOMAAF, LIMNIVELAF.VRLIMNIVELAF
                        FROM
                           LIMNIVELAF, AUTOFORNE, PRODUTO, PRODUTO P,
                           (SELECT
                               PRODUTO,
                               SUM(VRPRODUTO) - NVL(SUM(VRDESCONTO), 0) + NVL(SUM(VRIMPOSTO), 0) AS SOMAAF
                            FROM
                              (SELECT
                                  SUM(ITEMAUTF.QTPROGENTAF * ITEMAUTF.VRPREUNIAF) AS VRPRODUTO,
                                  SUM((ITEMAUTF.QTPROGENTAF * ITEMAUTF.VRPREUNIAF * ITEMAUTF.VRPERDESAF) / 100) AS VRDESCONTO,
                                  SUM(0) AS VRIMPOSTO,
                                  ITEMAUTF.CDPRODUTO AS PRODUTO
                               FROM
                                  ITEMAUTF, PRODUTO
                               WHERE
                                  ITEMAUTF.CDFILDEST  = :P_CDFILDEST      AND
                                  ITEMAUTF.CDFILLANC  = :P_CDFILLANC      AND
                                  ITEMAUTF.NRAUTOFORN = :P_NRAUTOFORN     AND
                                  ITEMAUTF.CDPRODUTO  = PRODUTO.CDPRODUTO AND
                                  PRODUTO.CDARVPROD   LIKE :P_CDPRODUTO||'%'
                            GROUP BY ITEMAUTF.CDPRODUTO
                    
                            UNION
                    
                            SELECT
                               SUM(0) AS VRPRODUTO,
                               SUM(0) AS VRDESCONTO,
                               SUM(IMPITMAF.VRADIMPAF) AS VRIMPOSTO,
                               ITEMAUTF.CDPRODUTO AS PRODUTO
                            FROM
                               IMPITMAF,
                               ITEMAUTF,
                               PRODUTO
                            WHERE
                               IMPITMAF.CDFILDEST   = :P_CDFILDEST         AND
                               IMPITMAF.CDFILLANC   = :P_CDFILLANC         AND
                               IMPITMAF.NRAUTOFORN  = :P_NRAUTOFORN        AND
                               IMPITMAF.CDFILDEST   = ITEMAUTF.CDFILDEST   AND
                               IMPITMAF.CDFILLANC   = ITEMAUTF.CDFILLANC   AND
                               IMPITMAF.NRAUTOFORN  = ITEMAUTF.NRAUTOFORN  AND
                               IMPITMAF.CDPRODUTO   = ITEMAUTF.CDPRODUTO   AND
                               IMPITMAF.CDMARCA     = ITEMAUTF.CDMARCA     AND
                               IMPITMAF.DTPROGENTAF = ITEMAUTF.DTPROGENTAF AND
                               ITEMAUTF.CDPRODUTO   = PRODUTO.CDPRODUTO    AND
                               PRODUTO.CDARVPROD    LIKE :P_CDPRODUTO||'%'
                            GROUP BY ITEMAUTF.CDPRODUTO
                            )
                            GROUP BY PRODUTO)
                    WHERE
                       PRODUTO.CDPRODUTO    = PRODUTO               AND
                       AUTOFORNE.CDFILDEST  = :P_CDFILDEST          AND
                       AUTOFORNE.CDFILLANC  = :P_CDFILLANC          AND
                       AUTOFORNE.NRAUTOFORN = :P_NRAUTOFORN         AND
                       AUTOFORNE.CDOPERADOR = LIMNIVELAF.CDOPERADOR AND
                       P.CDPRODUTO          = LIMNIVELAF.CDPRODUTO  AND
                       P.CDARVPROD          = :P_CDPRODUTO) AF
                    GROUP BY "VRLIMNIVELAF"
                    HAVING SUM("SOMAAF") > "VRLIMNIVELAF"
SQL;
        $params = array(
            'P_CDFILDEST'       => $stFilDest,
    	    'P_CDFILLANC'       => $stFilLanc,
        	'P_NRAUTOFORN'      => $stNrAF,
        	'P_CDPRODUTO'       => $cdarvprod
        );
        $stmt   = $this->connection->prepare($query);
        $stmt->execute($params);
        $result = $stmt->fetchAll();

        return $result;
    }
    
    public function adqRelValorAF_NVProdMes($stOper, $cdarvprod){
        $query = <<<SQL
                  SELECT SUM(SOMA.SOMAAF) AS "SOMAAF", LIMNIVELAF.VRLIMNIVPRAFMES AS "VRLIMNIVPRAFMES"
                      FROM LIMNIVELAF, PRODUTO,
                        (SELECT CDPRODUTO,
                                SUM(VRPRODUTO) - NVL(SUM(VRDESCONTO), 0) + NVL(SUM(VRIMPOSTO), 0) AS SOMAAF
                        FROM
                          (
                          SELECT
                             SUM(ITEMAUTF.QTPROGENTAF * ITEMAUTF.VRPREUNIAF) AS VRPRODUTO,
                             SUM((ITEMAUTF.QTPROGENTAF * ITEMAUTF.VRPREUNIAF *  ITEMAUTF.VRPERDESAF) / 100) AS VRDESCONTO,
                             SUM(0) AS VRIMPOSTO,
                             ITEMAUTF.CDPRODUTO AS CDPRODUTO
                          FROM ITEMAUTF,
                               AUTOFORNE,
                               PRODUTO
                          WHERE
                             AUTOFORNE.CDFILDEST  = ITEMAUTF.CDFILDEST    AND
                             AUTOFORNE.CDFILLANC  = ITEMAUTF.CDFILLANC    AND
                             AUTOFORNE.NRAUTOFORN = ITEMAUTF.NRAUTOFORN   AND
                             ITEMAUTF.CDPRODUTO   = PRODUTO.CDPRODUTO     AND
                             AUTOFORNE.CDOPERADOR = :P_CDOPERADOR         AND                                 
                             PRODUTO.CDARVPROD    LIKE :P_CDPRODUTO ||'%' AND
                             AUTOFORNE.DTAUTOFORN BETWEEN '01/'||:NOW_MONTH AND :NOW_LAST_DAY
                          GROUP BY ITEMAUTF.CDPRODUTO
                    
                          UNION
                    
                          SELECT
                             SUM(0) AS VRPRODUTO,
                             SUM(0) AS VRDESCONTO,
                             SUM(IMPITMAF.VRADIMPAF) AS VRIMPOSTO,
                             ITEMAUTF.CDPRODUTO AS PRODUTO
                          FROM
                             IMPITMAF,
                             ITEMAUTF,
                             AUTOFORNE,
                             PRODUTO
                          WHERE
                             IMPITMAF.CDFILDEST   = ITEMAUTF.CDFILDEST    AND
                             IMPITMAF.CDFILLANC   = ITEMAUTF.CDFILLANC    AND
                             IMPITMAF.NRAUTOFORN  = ITEMAUTF.NRAUTOFORN   AND
                             IMPITMAF.CDPRODUTO   = ITEMAUTF.CDPRODUTO    AND
                             IMPITMAF.CDMARCA     = ITEMAUTF.CDMARCA      AND
                             IMPITMAF.DTPROGENTAF = ITEMAUTF.DTPROGENTAF  AND
                             AUTOFORNE.CDFILDEST  = ITEMAUTF.CDFILDEST    AND
                             AUTOFORNE.CDFILLANC  = ITEMAUTF.CDFILLANC    AND
                             AUTOFORNE.NRAUTOFORN = ITEMAUTF.NRAUTOFORN   AND
                             ITEMAUTF.CDPRODUTO   = PRODUTO.CDPRODUTO     AND
                             AUTOFORNE.CDOPERADOR = :P_CDOPERADOR         AND
                             PRODUTO.CDARVPROD    LIKE :P_CDPRODUTO ||'%' AND
                             AUTOFORNE.DTAUTOFORN BETWEEN '01/'||:NOW_MONTH AND :NOW_LAST_DAY
                          GROUP BY ITEMAUTF.CDPRODUTO
                          )
                          GROUP BY CDPRODUTO) SOMA
                    WHERE SOMA.CDPRODUTO        = PRODUTO.CDPRODUTO
                      AND LIMNIVELAF.CDOPERADOR = :P_CDOPERADOR
                      AND LIMNIVELAF.CDPRODUTO  = :P_CDPRODUTO
                    GROUP BY LIMNIVELAF.VRLIMNIVPRAFMES
SQL;
        $currentDate = new \DateTime();
        $nowMonth = $currentDate->format('m/Y');
        $params = array(
        	'P_CDOPERADOR'      => $stOper,
            'NOW_MONTH'         => $nowMonth,
            'NOW_LAST_DAY'      => $currentDate->modify('last day of this month'),
        	'P_CDPRODUTO'       => $cdarvprod
        );
        $stmt   = $this->connection->prepare($query);
        $stmt->execute($params);
        $result = $stmt->fetchAll();

        return $result;
    }
    
    public function adqRelQuant_ProdForn($stFilDest, $stFilLanc, $stNrAF, $cdproduto){
        $query = <<<SQL
                  SELECT QUANT_PROD AS "QUANT_PROD", PRODFORN.QTMINAF AS "QTMINAF" 
                    FROM PRODFORN, AUTOFORNE, PRODUTO, PRODUTO PROD,
                     (
                       SELECT PRODUTO,
                              SUM(QUANT) AS QUANT_PROD
                       FROM
                        (  SELECT SUM(ITEMAUTF.QTPROGENTAF * PRODUTO.VRFATOCONV) AS QUANT,
                                  ITEMAUTF.CDPRODUTO AS PRODUTO
                           FROM ITEMAUTF, AUTOFORNE, PRODFORN, PRODUTO , PRODUTO P, PRODUTO PRODESTO
                           WHERE  AUTOFORNE.CDFILDEST  = :P_CDFILDEST          AND
                                  AUTOFORNE.CDFILLANC  = :P_CDFILLANC          AND
                                  AUTOFORNE.NRAUTOFORN = :P_NRAUTOFORN         AND
                                  AUTOFORNE.CDFILDEST  = ITEMAUTF.CDFILDEST    AND
                                  AUTOFORNE.CDFILLANC  = ITEMAUTF.CDFILLANC    AND
                                  AUTOFORNE.NRAUTOFORN = ITEMAUTF.NRAUTOFORN   AND
                                  AUTOFORNE.CDFORNECED = PRODFORN.CDFORNECED   AND
                                  ITEMAUTF.CDPRODUTO   = PRODUTO.CDPRODUTO     AND
                                  ITEMAUTF.CDPRODUTO   = :P_CDPRODUTO          AND
                                  PRODUTO.CDPRODESTO   = PRODESTO.CDPRODESTO   AND
                                  PRODESTO.SGUNIDADE   = PRODFORN.SGUNIDADE    AND
                                  P.CDPRODUTO          = PRODFORN.CDPRODUTO    AND
                                  P.CDARVPROD   =
                                         ( SELECT MAX(PR.CDARVPROD)
                                           FROM PRODFORN, PRODUTO PR
                                           WHERE
                                             PRODFORN.CDPRODUTO   = PR.CDPRODUTO AND
                                             AUTOFORNE.CDFORNECED = PRODFORN.CDFORNECED AND
                                             PRODUTO.CDARVPROD LIKE PR.CDARVPROD || '%'
                                          )
                           GROUP BY ITEMAUTF.CDPRODUTO, PRODUTO.CDARVPROD
                    
                           UNION
                    
                           SELECT SUM(ITEMAUTF.QTPROGENTAF * PRODUTO.VRFATOCONV / CONVPRODUTO.VRFATOCONVES) AS QUANT,
                                  ITEMAUTF.CDPRODUTO AS PRODUTO
                           FROM ITEMAUTF, AUTOFORNE, PRODFORN, PRODUTO, PRODUTO P, PRODUTO PRODESTO, CONVPRODUTO
                           WHERE AUTOFORNE.CDFILDEST  = :P_CDFILDEST          AND
                                 AUTOFORNE.CDFILLANC  = :P_CDFILLANC          AND
                                 AUTOFORNE.NRAUTOFORN = :P_NRAUTOFORN         AND
                                 AUTOFORNE.CDFILDEST  = ITEMAUTF.CDFILDEST    AND
                                 AUTOFORNE.CDFILLANC  = ITEMAUTF.CDFILLANC    AND
                                 AUTOFORNE.NRAUTOFORN = ITEMAUTF.NRAUTOFORN   AND
                                 AUTOFORNE.CDFORNECED = PRODFORN.CDFORNECED   AND
                                 ITEMAUTF.CDPRODUTO   = PRODUTO.CDPRODUTO     AND
                                 ITEMAUTF.CDPRODUTO   = :P_CDPRODUTO          AND
                                 PRODUTO.CDPRODESTO   = PRODESTO.CDPRODUTO    AND
                                 PRODESTO.SGUNIDADE  <> PRODFORN.SGUNIDADE    AND
                                 CONVPRODUTO.CDPRODUTO = PRODUTO.CDPRODESTO   AND
                                 CONVPRODUTO.SGUNIDADE = PRODFORN.SGUNIDADE   AND
                                 P.CDPRODUTO          = PRODFORN.CDPRODUTO    AND
                                 P.CDARVPROD   =
                                        ( SELECT MAX(PR.CDARVPROD)
                                          FROM PRODFORN, PRODUTO PR
                                          WHERE
                                            PRODFORN.CDPRODUTO   = PR.CDPRODUTO AND
                                            AUTOFORNE.CDFORNECED = CDFORNECED    AND
                                            PRODUTO.CDARVPROD LIKE PR.CDARVPROD || '%'
                                         )
                           GROUP BY ITEMAUTF.CDPRODUTO, PRODUTO.CDARVPROD
                        )
                       GROUP BY PRODUTO
                     )
                    
                    WHERE  (PRODUTO = PRODUTO.CDPRODUTO) AND
                           (AUTOFORNE.CDFILDEST  = :P_CDFILDEST)       AND
                           (AUTOFORNE.CDFILLANC  = :P_CDFILLANC)       AND
                           (AUTOFORNE.NRAUTOFORN = :P_NRAUTOFORN) AND
                           (AUTOFORNE.CDFORNECED = PRODFORN.CDFORNECED) AND
                           (PROD.CDPRODUTO = PRODFORN.CDPRODUTO) AND
                           (PROD.CDARVPROD =
                                     (SELECT MAX(PR.CDARVPROD)
                                      FROM PRODFORN, PRODUTO PR
                                      WHERE
                                        (PR.CDPRODUTO = PRODFORN.CDPRODUTO) AND
                                        (AUTOFORNE.CDFORNECED = CDFORNECED)  AND
                                        (PRODUTO.CDARVPROD LIKE PR.CDARVPROD || '%'))) AND
                           (QUANT_PROD < PRODFORN.QTMINAF)
SQL;
        $params = array(
            'P_CDFILDEST'       => $stFilDest,
    	    'P_CDFILLANC'       => $stFilLanc,
        	'P_NRAUTOFORN'      => $stNrAF,
        	'P_CDPRODUTO'       => $cdproduto
        );
        $stmt   = $this->connection->prepare($query);
        $stmt->execute($params);
        $result = $stmt->fetchAll();

        return $result;
    }
    
    public function adqRelVrArredCmpForn($stFilDest, $stFilLanc, $stNrAF, $cdproduto){
        $query = <<<SQL
                  SELECT
                       ITEMAUTF.DTPROGENTAF, ITEMAUTF.CDMARCA,
                       ITEMAUTF.QTPROGENTAF, PRODFORNCOMP.VRARREDCMPFO,
                       MARCA.NMMARCA
                    FROM
                       PARCMPSUP, PRODFORNCOMP, AUTOFORNE, ITEMAUTF, MARCA
                    WHERE
                       ITEMAUTF.CDFILDEST  = :P_CDFILDEST  AND
                       ITEMAUTF.CDFILLANC  = :P_CDFILLANC  AND
                       ITEMAUTF.NRAUTOFORN = :P_NRAUTOFORN AND
                       ITEMAUTF.CDPRODUTO  = :P_CDPRODUTO  AND
                    
                       AUTOFORNE.CDFILDEST  = ITEMAUTF.CDFILDEST AND
                       AUTOFORNE.CDFILLANC  = ITEMAUTF.CDFILLANC AND
                       AUTOFORNE.NRAUTOFORN = ITEMAUTF.NRAUTOFORN AND
                    
                       PRODFORNCOMP.CDFORNECED = AUTOFORNE.CDFORNECED AND
                       PRODFORNCOMP.CDPRODCOMPL = ITEMAUTF.CDPRODUTO  AND
                    
                       PARCMPSUP.CDFILIAL = ITEMAUTF.CDFILDEST AND
                       PARCMPSUP.IDUTARCMPFOR = 'S' AND
                    
                       MOD(ITEMAUTF.QTPROGENTAF, PRODFORNCOMP.VRARREDCMPFO) <> 0 AND
                    
                       ITEMAUTF.CDMARCA = MARCA.CDMARCA
SQL;
        $params = array(
            'P_CDFILDEST'       => $stFilDest,
    	    'P_CDFILLANC'       => $stFilLanc,
        	'P_NRAUTOFORN'      => $stNrAF,
        	'P_CDPRODUTO'       => $cdproduto
        );
        $stmt   = $this->connection->prepare($query);
        $stmt->execute($params);
        $result = $stmt->fetchAll();

        return $result;
    }
    
    public function adqRelParticularidades($stFilDest, $stFilLanc, $stNrAF, $cdproduto){
        $query = <<<SQL
                  SELECT PARTICULAR AS "PARTICULAR", MARCA AS "MARCA", FORNECEDOR AS "FORNECEDOR", NMMARCA AS "NMMARCA", NMFANTFORN AS NMRAZSOCFORN 
                    FROM PRODUTO,
                      (SELECT
                       DISTINCT ITEMAUTF.CDPRODUTO as Produto,
                                ITEMAUTF.CDMARCA as Marca,
                                MARCA.NMMARCA,
                                ITEMAUTF.CDSEGMARCA as SegMarca,
                                AUTOFORNE.CDFORNECED as Fornecedor,
                                FORNECEDOR.NMFANTFORN,
                                PARTFILI.CDTIPPART as Particular,
                                PARTFILI.CDMARCA as Part_Marca,
                                PARTFILI.CDFORNECED as Part_Forn,
                                PARTFILI.CDPRODUTO AS PROD_PART
                       FROM ITEMAUTF, AUTOFORNE, PARTFILI, MARCA, FORNECEDOR
                       WHERE
                         (ITEMAUTF.CDFILDEST   = :P_CDFILDEST)       AND
                         (ITEMAUTF.CDFILLANC   = :P_CDFILLANC)       AND
                         (ITEMAUTF.NRAUTOFORN  = :P_NRAUTOFORN)      AND
                         (ITEMAUTF.CDPRODUTO   = :P_CDPRODUTO)       AND
                         (AUTOFORNE.CDFILDEST  = :P_CDFILDEST)       AND
                         (AUTOFORNE.CDFILLANC  = :P_CDFILLANC)       AND
                         (AUTOFORNE.NRAUTOFORN = :P_NRAUTOFORN)      AND
                         (ITEMAUTF.CDPRODUTO   = PARTFILI.CDPRODUTO) AND
                         (ITEMAUTF.CDFILDEST   = PARTFILI.CDFILIAL)  AND
                         (PARTFILI.CDMARCA     = MARCA.CDMARCA(+))   AND
                         (PARTFILI.CDFORNECED  = FORNECEDOR.CDFORNECED(+)))
                    
                    WHERE (Produto = PRODUTO.CDPRODUTO) AND
                          (Produto IS NOT NULL) AND
                          (((Particular =  '1')    AND
                           (Produto = PROD_PART) AND
                           ((Marca  <> Part_Marca) OR
                           (SegMarca IS NOT NULL and SegMarca <> Part_Marca)) )  or
                    
                          ((particular = '2')  and
                            (not exists(select cdtippart
                                        from partfili
                                        where (cdfilial = :P_CDFILDEST) AND
                                              (cdproduto = produto) AND
                                              (cdtippart  = '2') and
                                              (cdmarca = Marca))) AND
                             NOT EXISTS
                               (SELECT CDTIPPART
                                FROM PARTFILI PMF
                                WHERE  
                                  PMF.CDFILIAL = :P_CDFILDEST AND
                                  PMF.CDPRODUTO = PRODUTO AND
                                  PMF.CDMARCA  = MARCA AND
                                  PMF.CDTIPPART = '8' AND
                                  PMF.CDFORNECED = FORNECEDOR) ) or
                    
                          ((particular = '2')  and
                            (SegMarca IS NOT NULL) and        
                            (not exists(select cdtippart
                                        from partfili
                                        where (cdfilial = :P_CDFILDEST) AND
                                              (cdproduto = produto) AND
                                              (cdtippart  = '2') and
                                              (cdmarca = SegMarca))) AND
                             NOT EXISTS
                               (SELECT CDTIPPART
                                FROM PARTFILI PMF
                                WHERE  
                                  PMF.CDFILIAL = :P_CDFILDEST AND
                                  PMF.CDPRODUTO = PRODUTO AND
                                  PMF.CDMARCA  = SEGMARCA AND
                                  PMF.CDTIPPART = '8' AND
                                  PMF.CDFORNECED = FORNECEDOR) ) or
                    
                          ((Particular =  '3')    AND
                           (Produto = PROD_PART) AND
                           ((Marca  = Part_Marca) OR
                           (SegMarca IS NOT NULL and SegMarca = Part_Marca)))  or
                    
                          ((Particular =  '4')    AND
                           (Produto = PROD_PART) AND
                           (Fornecedor <> Part_Forn))  or
                    
                          ((particular = '5')  and
                            (not exists(select cdtippart
                                        from partfili
                                        where (cdfilial = :P_CDFILDEST) AND
                                              (cdproduto = produto) AND
                                              (cdtippart  = '5') and
                                              (cdforneced = Fornecedor))) AND
                             NOT EXISTS
                               (SELECT CDTIPPART
                                FROM PARTFILI PMF
                                WHERE  
                                  PMF.CDFILIAL = :P_CDFILDEST AND
                                  PMF.CDPRODUTO = PRODUTO AND
                                  PMF.CDMARCA  = MARCA AND
                                  PMF.CDTIPPART = '8' AND
                                  PMF.CDFORNECED = FORNECEDOR) ) or
                    
                          ((Particular =  '6')    AND
                           (Produto = PROD_PART) AND
                           (Fornecedor  = Part_Forn))  or
                    
                          ((Particular =  '7')    AND
                           (Produto = PROD_PART) AND
                           ((Marca  <> Part_Marca OR
                            (SegMarca IS NOT NULL and SegMarca <> Part_Marca)) or
                           (Fornecedor <> Part_Forn)))  or
                    
                    
                          ((particular = '8')  and
                            (not exists(select cdtippart
                                        from partfili
                                        where (cdfilial = :P_CDFILDEST) AND
                        adqParamProdSup                      (cdproduto = produto) AND
                                              (cdtippart  = '8') and
                                              (cdmarca    = Marca) and
                                              (cdforneced = Fornecedor)))) or
                    
                          ((particular = '8')  and
                            (SegMarca IS NOT NULL) and
                            (not exists(select cdtippart
                                        from partfili
                                        where (cdfilial = :P_CDFILDEST) AND
                                              (cdproduto = produto) AND
                                              (cdtippart  = '8') and
                                              (cdmarca    = SegMarca) and
                                              (cdforneced = Fornecedor)))) or
                    
                          ((Particular =  '9')    AND
                           (Produto = PROD_PART) AND
                           ((Marca  = Part_Marca) OR
                           (SegMarca IS NOT NULL and SegMarca = Part_Marca)) AND
                           (Fornecedor  = Part_Forn)))
SQL;
        $params = array(
            'P_CDFILDEST'       => $stFilDest,
    	    'P_CDFILLANC'       => $stFilLanc,
        	'P_NRAUTOFORN'      => $stNrAF,
        	'P_CDPRODUTO'       => $cdproduto
        );
        $stmt   = $this->connection->prepare($query);
        $stmt->execute($params);
        $result = $stmt->fetchAll();

        return $result;
    }
    
    public function adqParamProdSup($stFilDest, $cdproduto){
        $query = <<<SQL
                  SELECT CDPRODUTO AS "CDPRODUTO", CDFILIAL AS "CDFILIAL", CDFILIOPELOG AS "CDFILIOPELOG"
                      FROM PARAMPRODSUP
                     WHERE CDFILIAL  = :P_CDFILDEST
                       AND CDPRODUTO = :P_CDPRODUTO
                       AND CDFILIOPELOG IS NOT NULL
SQL;
        $params = array(
            'P_CDFILDEST'       => $stFilDest,
        	'P_CDPRODUTO'       => $cdproduto
        );
        $stmt   = $this->connection->prepare($query);
        $stmt->execute($params);
        $result = $stmt->fetchAll();

        return $result;
    }
    
    public function adqFornecedorObrig($stFilDest, $stFilLanc, $stNrAF, $cdproduto, $fornecedor){
        $query = <<<SQL
                  SELECT
                       CDFORNECED AS "CDFORNECED"
                    FROM
                       PARTFILI
                    WHERE PARTFILI.CDFILIAL   =  :P_CDFILDEST
                      AND PARTFILI.CDPRODUTO  =  :P_CDPRODUTO
                      AND PARTFILI.CDTIPPART  =  '4'
                      AND PARTFILI.CDFORNECED <> :P_CDFORNECED
                      AND PARTFILI.NRCOLEPRECO IS NULL
                    
                    UNION ALL
                    
                    SELECT
                       CDFORNECED AS "CDFORNECED"
                    FROM
                       PARTFILI
                    WHERE PARTFILI.CDFILIAL   =  :P_CDFILDEST
                      AND PARTFILI.CDPRODUTO  =  :P_CDPRODUTO
                      AND PARTFILI.CDTIPPART  =  '4'
                      AND PARTFILI.CDFORNECED <> :P_CDFORNECED
                      AND PARTFILI.NRCOLEPRECO IS NOT NULL
                      AND EXISTS (SELECT 1
                                  FROM ITEMAUTF
                                  WHERE ITEMAUTF.CDFILDEST     = :P_CDFILDEST
                                    AND ITEMAUTF.CDFILLANC     = :P_CDFILLANC
                                    AND ITEMAUTF.NRAUTOFORN    = :P_NRAUTOFORN
                                    AND ITEMAUTF.CDPRODUTO     = :P_CDPRODUTO
                                    AND EXISTS (SELECT 1
                                                FROM COLETAPR
                                                WHERE COLETAPR.CDFILIAL    = PARTFILI.CDFILCOTA
                                                  AND COLETAPR.NRCOLEPRECO = PARTFILI.NRCOLEPRECO
                                                  AND ITEMAUTF.DTENTRITMSOL BETWEEN COLETAPR.DTINIVALCOL AND COLETAPR.DTFINVALCOL
                                                ))
SQL;
        $params = array(
            'P_CDFILDEST'       => $stFilDest,
    	    'P_CDFILLANC'       => $stFilLanc,
        	'P_NRAUTOFORN'      => $stNrAF,
        	'P_CDPRODUTO'       => $cdproduto,
        	'P_CDFORNECED'      => $fornecedor
        );
        $stmt   = $this->connection->prepare($query);
        $stmt->execute($params);
        $result = $stmt->fetchAll();

        return $result;
    }
    
    public function adqRelProdPrefMed($stFilDest, $cdprodesto){
        $query = <<<SQL
                  SELECT
                       PRODUTO.CDPRODUTO AS "CDPRODPREF",
                       PRODUTO.NMPRODUTO AS "NMPRODPREF"
                    FROM
                       PRODPREFMED, PARCMPSUP, PRODUTO
                    WHERE
                       PARCMPSUP.CDFILIAL = :P_CDFILDEST AND
                       PARCMPSUP.IDUTPRODPREF = 'S' AND
                       PRODPREFMED.CDFILIAL = :P_CDFILDEST AND
                       PRODPREFMED.CDPRODUTO = :P_CDPRODESTO AND
                       PRODPREFMED.CDPRODPREF = PRODUTO.CDPRODUTO
SQL;
        $params = array(
            'P_CDFILDEST'       => $stFilDest,
        	'P_CDPRODESTO'      => $cdprodesto
        );
        $stmt   = $this->connection->prepare($query);
        $stmt->execute($params);
        $result = $stmt->fetchAll();

        return $result;
    }
    
    public function adqVerificaParametro($stFilDest){
        $query = <<<SQL
                  SELECT IDCONSAFORCFIL AS "IDCONSAFORCFIL"
                      FROM FILIAL
                     WHERE CDFILIAL = :P_CDFILIDEST
SQL;
        $params = array(
            'P_CDFILDEST'       => $stFilDest
        );
        $stmt   = $this->connection->prepare($query);
        $stmt->execute($params);
        $result = $stmt->fetchAll();

        return $result;
    }
    
    public function adqRelConsisteOrca($stFilDest, $stFilLanc, $stNrAF, $cdproduto){
        $query = <<<SQL
                  SELECT ERROCONSORCA.NRSEQERCONSORCA AS "NRSEQERCONSORCA", ERROCONSORCA.DSERROCONSORCA AS "DSERROCONSORCA", ERROCONSORCA.CDPRODUTO AS "CDPRODUTO",
                         ERROCONSORCA.DSERROCONSORCA AS "DSERROCONSORCA"
                      FROM ERROCONSORCA, ITEMAUTF
                     WHERE ITEMAUTF.CDFILDEST  = ERROCONSORCA.CDFILDEST
                       AND ITEMAUTF.CDFILLANC  = ERROCONSORCA.CDFILLANC
                       AND ITEMAUTF.NRAUTOFORN = ERROCONSORCA.NRAUTOFORN
                       AND ITEMAUTF.CDPRODUTO  = ERROCONSORCA.CDPRODUTO
                       AND TO_CHAR(ITEMAUTF.DTPROGENTAF, 'MM/YYYY') = TO_CHAR(ERROCONSORCA.DTPROGENTAF, 'MM/YYYY')
                       AND ITEMAUTF.CDFILDEST  = :P_CDFILDEST
                       AND ITEMAUTF.CDFILLANC  = :P_CDFILLANC
                       AND ITEMAUTF.NRAUTOFORN = :P_NRAUTOFORN
                       AND ITEMAUTF.CDPRODUTO  = :P_CDPRODUTO
                       AND DSERROCONSORCA IS NOT NULL
                     ORDER BY ERROCONSORCA.DSERROCONSORCA DESC
SQL;
        $params = array(
            'P_CDFILDEST'       => $stFilDest,
    	    'P_CDFILLANC'       => $stFilLanc,
        	'P_NRAUTOFORN'      => $stNrAF,
        	'P_CDPRODUTO'       => $cdproduto
        );
        $stmt   = $this->connection->prepare($query);
        $stmt->execute($params);
        $result = $stmt->fetchAll();

        return $result;
    }
    
    public function adqQntCotProd($cdfilcentcmp, $cdarvprod){
        $query = <<<SQL
                  SELECT QUANTCOTPROD.VRQTDCOTACAO AS "VRQTDCOTACAO"
                      FROM QUANTCOTPROD, PRODUTO
                     WHERE QUANTCOTPROD.CDFILIAL  = :P_CDFILIAL
                       AND QUANTCOTPROD.CDPRODUTO = PRODUTO.CDPRODUTO
                       AND PRODUTO.CDARVPROD      = (SELECT MAX(B.CDARVPROD)
                                                       FROM QUANTCOTPROD A, PRODUTO B
                                                      WHERE A.CDPRODUTO = B.CDPRODUTO
                                                        AND A.CDFILIAL  = :P_CDFILIAL
                                                        AND INSTR(:P_CDPRODUTO, B.CDARVPROD) = 1)
SQL;
        $params = array(
            'P_CDFILIAL'       => $cdfilcentcmp,
        	'P_CDPRODUTO'      => $cdarvprod
        );
        $stmt   = $this->connection->prepare($query);
        $stmt->execute($params);
        $result = $stmt->fetchAll();

        return $result;
    }
    
    public function adqVerificaQntCot($stFilDest, $cdproduto, $cdfilcentcmp, $dtprogntaf){
        $query = <<<SQL
                  SELECT COUNT(*) AS "QTDCOTACAO"
                      FROM ITEMCOLE
                     WHERE CDPRODUTO = :P_CDPRODUTO
                       AND CDFILIAL  = :P_CDFILCENTCMP 
                       AND  :P_DTPROGENT BETWEEN DTINIVALITM AND DTFINVALITM
                       AND NOT EXISTS (SELECT CDREGIAO
                                         FROM REFOREG
                                        WHERE ITEMCOLE.CDFORNECED = REFOREG.CDFORNECED
                                          AND ITEMCOLE.CDREGIAO   = REFOREG.CDREGIAO)
                      AND NOT EXISTS (SELECT CDFORNECED
                                        FROM REFORFIL
                                       WHERE CDFILIAL   = :P_CDFILIAL
                                         AND CDFORNECED = ITEMCOLE.CDFORNECED
                                         AND CDPERIENTR IS NULL)
SQL;
        $params = array(
            'P_CDFILCENTCMP'       => $cdfilcentcmp,
    	    'P_CDFILIAL'           => $stFilDest,
        	'P_DTPROGENT'          => $dtprogntaf,
        	'P_CDPRODUTO'          => $cdproduto
        );
        $stmt   = $this->connection->prepare($query);
        $stmt->execute($params);
        $result = $stmt->fetchAll();

        return $result;
    }
    
    public function adqPrecObjet($stFilDest, $cdprodesto, $dtprogntaf){
        $query = <<<SQL
                  SELECT MIN(VRPRECOBJETIVO) AS "VRPRECOBJETIVO"
                      FROM ITEMPRECOJETIVO, FILIAL
                     WHERE FILIAL.CDFILIAL                = :P_CDFILDEST
                       AND ITEMPRECOJETIVO.CDFILIAL       = FILIAL.CDFILIAL
                       AND ITEMPRECOJETIVO.CDREGIAO       = FILIAL.CDREGIAO
                       AND ITEMPRECOJETIVO.CDPRODUTO      = :P_CDPRODESTO
                       AND :P_DTPROGENTAF BETWEEN ITEMPRECOJETIVO.DTINIVALITMOBJ AND ITEMPRECOJETIVO.DTFINVALITMOBJ
SQL;
        $params = array(
    	    'P_CDFILDEST'          => $stFilDest,
        	'P_DTPROGENTAF'        => $dtprogntaf,
        	'P_CDPRODESTO'         => $cdprodesto
        );
        $stmt   = $this->connection->prepare($query);
        $stmt->execute($params);
        $result = $stmt->fetchAll();

        return $result;
    }
    
    public function acmLimpaInconsAF($stFilDest, $stFilLanc, $stNrAF){
        $query = <<<SQL
                  UPDATE AUTOFORNE
                    SET 
                       DSINCONSAF = NULL
                    WHERE
                       CDFILDEST = :P_CDFILDEST AND
                       CDFILLANC = :P_CDFILLANC AND
                       NRAUTOFORN = :P_NRAUTOFORN
SQL;
        $params = array(
            'P_CDFILDEST'       => $stFilDest,
    	    'P_CDFILLANC'       => $stFilLanc,
        	'P_NRAUTOFORN'      => $stNrAF
        );
        $stmt   = $this->connection->prepare($query);
        $stmt->execute($params);
    }
    
    public function acmLimpaInconsItAf($stFilDest, $stFilLanc, $stNrAF){
        $query = <<<SQL
                  UPDATE ITEMAUTF
                    SET
                       DSINCONSITAF = NULL
                    WHERE
                       CDFILDEST = :P_CDFILDEST AND
                       CDFILLANC = :P_CDFILLANC AND
                       NRAUTOFORN = :P_NRAUTOFORN
SQL;
        $params = array(
            'P_CDFILDEST'       => $stFilDest,
    	    'P_CDFILLANC'       => $stFilLanc,
        	'P_NRAUTOFORN'      => $stNrAF
        );
        $stmt   = $this->connection->prepare($query);
        $stmt->execute($params);
    }
    
    public function acmInconsAF($stFilDest, $stFilLanc, $stNrAF, $stErro){
        $query = <<<SQL
                  UPDATE AUTOFORNE
                    SET 
                       DSINCONSAF = :P_DSINCONSAF
                    WHERE
                       CDFILDEST = :P_CDFILDEST AND
                       CDFILLANC = :P_CDFILLANC AND
                       NRAUTOFORN = :P_NRAUTOFORN
SQL;
        $params = array(
            'P_CDFILDEST'       => $stFilDest,
    	    'P_CDFILLANC'       => $stFilLanc,
        	'P_NRAUTOFORN'      => $stNrAF, 
        	'P_DSINCONSAF'      => $stErro
        );
        $stmt   = $this->connection->prepare($query);
        $stmt->execute($params);
    }
    
    public function acmInconsItAF($stFilDest, $stFilLanc, $stNrAF, $stErroItm, $cdmarca, $cdproduto){
        $query = <<<SQL
                  UPDATE ITEMAUTF
                    SET 
                       DSINCONSITAF = :P_DSINCONSITAF
                    WHERE
                       CDFILDEST = :P_CDFILDEST AND
                       CDFILLANC = :P_CDFILLANC AND
                       NRAUTOFORN = :P_NRAUTOFORN AND
                       CDMARCA = NVL(:P_CDMARCA, CDMARCA) AND
                       CDPRODUTO = NVL(:P_CDPRODUTO, CDPRODUTO)
SQL;
        $params = array(
            'P_CDFILDEST'       => $stFilDest,
    	    'P_CDFILLANC'       => $stFilLanc,
        	'P_NRAUTOFORN'      => $stNrAF, 
        	'P_DSINCONSITAF'    => $stErroItm,
        	'P_CDMARCA'         => $cdmarca,
        	'P_CDPRODUTO'       => $cdproduto
        );
        $stmt   = $this->connection->prepare($query);
        $stmt->execute($params);
    }
    
    public function acmGravaInconsLimAF($stFilDest, $stFilLanc, $stNrAF, $stSituAtuaAF, $stAFForaLim){
        $query = <<<SQL
                  UPDATE AUTOFORNE
                    SET 
                       IDSITUATUAAF = :P_IDSITUATUAAF,
                       IDAFFORALIM = :P_IDAFFORALIM,
                       CDGERENTE = NULL,
                       IDAFCONS = 'S'
                    WHERE
                       CDFILDEST = :P_CDFILDEST AND
                       CDFILLANC = :P_CDFILLANC AND
                       NRAUTOFORN = :P_NRAUTOFORN
SQL;
        $params = array(
            'P_CDFILDEST'       => $stFilDest,
    	    'P_CDFILLANC'       => $stFilLanc,
        	'P_NRAUTOFORN'      => $stNrAF, 
        	'P_IDSITUATUAAF'    => $stSituAtuaAF,
        	'P_IDAFFORALIM'     => $stAFForaLim
        );
        $stmt   = $this->connection->prepare($query);
        $stmt->execute($params);
    }
}