<?php

namespace Teknisa\Libs\Util;

class Configuration extends \Zeedhi\Framework\DataSource\Configuration {
    protected $columnsProperties;

    public function getColumnsProperties() {
        return $this->columnsProperties;
    }

    public function setColumnsProperties($columnsProperties) {
        $this->columnsProperties = $columnsProperties;
    }

    public static function factoryFromFileLocation($dirLocation, $dataSourceName) {
        $instance = parent::factoryFromFileLocation($dirLocation, $dataSourceName);
        $pathFile = realpath($dirLocation).DIRECTORY_SEPARATOR.$dataSourceName.'.json';
        $json = file_get_contents($pathFile);
        $dataSourceConfig = json_decode($json, true);
        $dataSourceConfig = $dataSourceConfig[$dataSourceName];

        if (isset($dataSourceConfig['columnsProperties'])) {
            $instance->setColumnsProperties($dataSourceConfig['columnsProperties']);
        }

        return $instance;
    }
}