# Changelog
*As versões que não estiverem listadas abaixo significa que não houve alteração. Houve apenas a necessidade de atualizar a [libFrontend](http://gitlab.teknisa.com/teknisa/libfrontend).*

## [5.0.0](http://gitlab.teknisa.com/teknisa/libbackend/tree/5.0.0)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.14.9...5.0.0)

**Improvements**
- ajustado para o php 8.4

## [3.14.9](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.14.9)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.14.7...3.14.9)

**Improvements**
- Retornada validação do banco de dados, a fim de alertar o usuário se alguma estrutura gerada no deploy não tiver sido aplicada.

## [3.14.2](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.14.2)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.14.1...3.14.2)

**Improvements**
- Adicionada rota `/lib_chatBotQuery` para executar um comando **SQL** e retornar os dados, com uso inicialmente no **Teka** (*ChatBot da Teknisa*).

## [3.14.0](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.14.0)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.13.9...3.14.0)

**Improvements**
- Criação da popup de visualização dos comunicados no Zeedhi Angular.

## [3.13.9](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.13.9)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.13.8...3.13.9)

**Improvements**
- Aumento no limite padrão de requisições na rotina **Rate Limit** para **30**.

## [3.13.8](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.13.8)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.13.7...3.13.8)

**Fixed Bugs**
- Correção nos tamanhos dos dados na rotina **SQLWEBTUNNING** ficando maiores que as colunas no banco de dados.

## [3.13.7](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.13.7)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.13.6...3.13.7)

**Fixed Bugs**
- Adicionada rota `/validateRedirectionUrl` na exceção do **Acesso Concorrente**.

## [3.13.6](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.13.6)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.13.5...3.13.6)

**Fixed Bugs**
- Correção na rotina de **Comunicados pós login** para não retornar quando a língua for diferente do português.

## [3.13.5](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.13.5)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.13.4...3.13.5)

**Fixed Bugs**
- Correção no IP padrão na rotina **SQLWEBTUNNING**.

## [3.13.4](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.13.4)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.13.3...3.13.4)

**Fixed Bugs**
- Tratamento de IP's utilizando porta na rotina **SQLWEBTUNNING**.

## [3.13.3](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.13.3)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.13.2...3.13.3)

**Improvements**
- Adicionada exceção para operadores da Teknisa conseguirem baixar os arquivos de log do PHP.

## [3.13.2](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.13.2)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.13.1...3.13.2)

**Improvements**
- Adicionado botão no menu para **Baixar arquivos de log do PHP**.

## [3.13.0](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.13.0)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.12.3...3.13.0)

**Features**
- Adicionada rotina para tratamento do **Rate Limit** em requisições públicas.

## [3.12.3](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.12.3)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.12.1...3.12.3)

**Improvements**
- Criação de parâmetro `LOGIN_USER_NEXT` para corrigir o problema de URL muito grande nos produtos que possuem um alto volume de menus.

## [3.12.0](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.12.0)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.11.4...3.12.0)

**Features**
- Tratamentos para a rotina de **Comunicados** após login.

## [3.11.0](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.11.0)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.10.3...3.11.0)

**Features**
- Criação de tratamentos para os menus customizados criados no CP.

## [3.10.3](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.10.3)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.10.2...3.10.3)

**Improvements**
- Adicionada rotina para salvar logs na tabela **LOGOPERA**.

## [3.10.0](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.10.0)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.9.3...3.10.0)

**Improvements**
- Alteração na rotina de **Criptografia do Delphi** para ser executada localmente e não chamar mais web services.

## [3.9.5](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.9.5)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.9.4...3.9.5)

**Fixed Bugs**
- Correção na execução do script PHP de coleta de medidas variáveis gerando bug de contador 0.

## [3.9.0](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.9.0)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.8.1...3.9.0)

**Improvements**
- Removida função **Excel** do **PHP 7.2** e suas dependências para evitar erros de código depreciados (*Rafael Dias*).

## [3.8.8](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.8.8)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.8.7...3.8.8)

**Improvements**
- Melhoria na rotina de buscar **CEPs** para garantir que outras **APIs** sejam executadas. (*Luan Santiago*).

## [3.8.4](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.8.4)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.8.3...3.8.4)

**Improvements**
- Correção no **ReportDecorator** para não duplicar relatórios QR2 (*Samuel Costa*).
- Alteração na URL padrão de teste do license para utilizar **https**.

## [3.8.1](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.8.1)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.8.0...3.8.1)

**Improvements**
- Adicionados tratamentos para receber o formato do relatório a ser baixado pelo backend.
- Adicionados tratamentos para abrir relatório do tipo **HTML** em nova aba do navegador.

## [3.8.0](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.8.0)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.7.11...3.8.0)

**Features**
- Adicionados tratamentos para uso da rotina de configuração de **Horários de Acesso**.

## [3.7.13](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.7.13)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.7.12...3.7.13)

**Improvements**
- Adicionada tradução dos itens do `groupMenu` do **containers.json**.

## [3.7.1](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.7.1)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.6.0...3.7.1)

**Features**
- Adicionado filtro **PROJECT_ID** na rotina **Favoritos**.

## [3.6.7](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.6.7)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.6.5...3.6.7)

**Improvements**
- Adicionado tratamento de **dbname** na conexão com o banco de dados para possibilitar não utilizar wallet em ambientes **SaaS**.

## [3.6.6](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.6.6)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.6.5...3.6.6)

**Improvements**
- Alteração na rotina de gerar relatórios para, por padrão, abrir documentos **PDF** diretamente no browser e não realizar seu download.

## [3.6.3](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.6.3)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.6.2...3.6.3)

**Fixed Bugs**
- Removida verificação de acesso concorrente ao utilizar o **Operador de Suporte**.

## [3.6.2](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.6.2)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.6.1...3.6.2)

**Fixed Bugs**
- Correção nas queries dos scripts de banco para retornar ao padrão Oracle utilizando **SYSDATE**.
    - *Não há a possibilidade de utilizar parâmetros nessas queries durante a montagem do script de Deploy no CP.*

## [3.6.1](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.6.1)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.6.0...3.6.1)

**Features**
- Aumento de memória e tempo de execução na requisição de atualizar tradução.

## [3.6.0](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.6.0)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.5.1...3.6.0)

**Features**
- Adicionadas funcionalidades do módulo de **LOGIN** com foco na melhoria de performance.

## [3.5.1](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.5.1)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.5.0...3.5.1)

**Fixed Bugs**
- Adicionado tratamento para não criar arquivos de tradução quando a pasta do módulo não existir.

## [3.5.0](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.5.0)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.4.2...3.5.0)

**Features**
- Adicionada rotina para atualização dos arquivos de tradução dentro dos sistemas.

## [3.4.4](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.4.4)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.4.3...3.4.4)

**Improvements**
- Correção em falta de variável no __reportDecorator__ (*Rafael Dias*).

## [3.4.2](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.4.2)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.4.1...3.4.2)

**Improvements**
- Adicionado controle de leitura de células vazias no arquivo **FileLoader.php** (*João Corte*).

## [3.4.1](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.4.1)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.4.0...3.4.1)

**Features**
- Adicionada possibilidade de abrir telas de microservices específicos sem o redirecionamento, a partir do parâmetro `modulesNotRedirect`.
    
*Exemplo de Uso:*

```xml
<parameter key="modulesNotRedirect" type="collection">
    <parameter>acl</parameter>
</parameter>
```

## [3.4.0](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.4.0)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.3.1...3.4.0)

**Features**
- Adicionados tratamentos para troca de separadores **Decimal e Milhar** na tela de Login.

## [3.3.2](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.3.2)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.3.1...3.3.2)

**Improvements**
- Adicionado controle de leitura de células vazias no arquivo **FileLoader.php** (*João Corte*).

## [3.3.1](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.3.1)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.3.0...3.3.1)

**Fixed Bugs**
- Correção erro no index ORGANIZATION_ID na versão **3.3.0**.

## [3.3.0](http://gitlab.teknisa.com/teknisa/libbackend/tree/3.3.0)
[Full Changelog](http://gitlab.teknisa.com/teknisa/libbackend/compare/3.2.15...3.3.0)

**Features**
- Adicionados tratamentos para funcionamento das rotinas em **PostgreSQL**.

## [3.2.18][TREE_3_2_18]
[Full Changelog][CHANGES_3_2_18]

**Improvements**
- Alteração da chamada da função `setReadEmptyCells` para executar somente no php 7.4 (*João Corte*).

[TREE_3_2_18]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.2.18
[CHANGES_3_2_18]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.2.17...3.2.18

## [3.2.16][TREE_3_2_16]
[Full Changelog][CHANGES_3_2_16]

**Improvements**
- Adicionado controle de leitura de células vazias no arquivo **FileLoader.php** (*João Corte*).

[TREE_3_2_16]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.2.16
[CHANGES_3_2_16]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.2.15...3.2.16

## [3.2.15][TREE_3_2_15]
[Full Changelog][CHANGES_3_2_15]

**Fixed Bugs**
- Corrigida função que lê o array do xls em **PHP 7.4** arquivo **FileReader.php** (*Rafael Dias*).

[TREE_3_2_15]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.2.15
[CHANGES_3_2_15]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.2.14...3.2.15

## [3.2.14][TREE_3_2_14]
[Full Changelog][CHANGES_3_2_14]

**Fixed Bugs**
- Removida tipagem `PHPExcel_Worksheet` para correto funcionamento da nova biblioteca de **XLS**.

[TREE_3_2_14]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.2.14
[CHANGES_3_2_14]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.2.13...3.2.14

## [3.2.13][TREE_3_2_13]
[Full Changelog][CHANGES_3_2_13]

**Improvements**
- Atualização nas rotinas de **XLS** para utilizar a biblioteca **phpoffice/phpspreadsheet** no **PHP 7.4**.

[TREE_3_2_13]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.2.13
[CHANGES_3_2_13]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.2.12...3.2.13

## [3.2.12][TREE_3_2_12]
[Full Changelog][CHANGES_3_2_12]

**Fixed Bugs**
- Corrigido erra na rota **lib_startSession** gerando problema ao acessar o index **ORGANIZATION_ID**.

[TREE_3_2_12]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.2.12
[CHANGES_3_2_12]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.2.11...3.2.12

## [3.2.11][TREE_3_2_11]
[Full Changelog][CHANGES_3_2_11]

**Fixed Bugs**
- Corrigido erro no uso do parâmetro **IDUTLPERFILFILIAL** gerando erros no **PHP 7.4**.

[TREE_3_2_11]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.2.11
[CHANGES_3_2_11]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.2.10...3.2.11

## [3.2.9][TREE_3_2_9]
[Full Changelog][CHANGES_3_2_9]

**Fixed Bugs**
- Corrigido erro de carregamento eterno na rota **lib_startSession** em ambientes **SaaS** quando a base Teknisa (_20_) está inacessível.

[TREE_3_2_9]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.2.9
[CHANGES_3_2_9]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.2.8...3.2.9

## [3.2.8][TREE_3_2_8]
[Full Changelog][CHANGES_3_2_8]

**Fixed bugs**
- Correção na rotina de sessão expirada não renovando o tempo do token quando ficava muito tempo ocioso.
- Remoção de módulos next na lista de módulos do __About__.

[TREE_3_2_8]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.2.8
[CHANGES_3_2_8]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.2.7...3.2.8

## [3.2.7][TREE_3_2_7]
[Full Changelog][CHANGES_3_2_7]

**Fixed bugs**
- Correção na classe __Active Directory__ para o __PHP 7.4__.

[TREE_3_2_7]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.2.7
[CHANGES_3_2_7]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.2.5...3.2.7

## [3.2.5][TREE_3_2_5]
[Full Changelog][CHANGES_3_2_5]

**Fixed bugs**
- Removido uso da função **get_magic_quotes_runtime** depreciado no **PHP 7.4** e removido no **PHP 8.1** (*Fernando Cardoso*).
- Tratamento para não gerar exceção quando existem relatórios específicos de **QR2** (*Samuel Costa*).

[TREE_3_2_5]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.2.5
[CHANGES_3_2_5]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.2.4...3.2.5

## [3.2.4][TREE_3_2_4]
[Full Changelog][CHANGES_3_2_4]

**Improvements**
- Adicionado **NRORGOPER** na sessão.
- Adicionado tratamento na rotina de obter as filiais da organização para considerar o **NRORGOPER** caso exista.

[TREE_3_2_4]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.2.4
[CHANGES_3_2_4]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.2.3...3.2.4

## [3.2.3][TREE_3_2_3]
[Full Changelog][CHANGES_3_2_3]

**Improvements**
- Alteração na rotina de redirecionamento para armazenar os dados do usuário no mongo.

[TREE_3_2_3]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.2.3
[CHANGES_3_2_3]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.1.2...3.2.3

## [3.1.2][TREE_3_1_2]
[Full Changelog][CHANGES_3_1_2]

**Improvements**
- Alteração de uso das funções **implode** e **array_key_exists** para a versão **7.4** do **PHP**.
    - _Requer, no mínimo, a versão **2.4.5** do **framework**._

[TREE_3_1_2]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.1.2
[CHANGES_3_1_2]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.74...3.1.2

## [3.0.76][TREE_3_0_76]
[Full Changelog][CHANGES_3_0_76]

**Fixed Bugs**
- Corrigido erro de carregamento eterno na rota **lib_startSession** em ambientes **SaaS** quando a base Teknisa (_20_) está inacessível.

[TREE_3_0_76]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.76
[CHANGES_3_0_76]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.75...3.0.76

## [3.0.75][TREE_3_0_75]
[Full Changelog][CHANGES_3_0_75]

**Improvements**
- Adicionada rota **lib_findFavorites** nas ignoradas pelo acesso concorrente.

[TREE_3_0_75]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.75
[CHANGES_3_0_75]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.74...3.0.75

## [3.0.74][TREE_3_0_74]
[Full Changelog][CHANGES_3_0_74]

**Improvements**
- Adicionado tratamento de erro para a versão **7.4** do **PHP**.

[TREE_3_0_74]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.74
[CHANGES_3_0_74]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.73...3.0.74

## [3.0.73][TREE_3_0_73]
[Full Changelog][CHANGES_3_0_73]

**Fixed bugs**
- Adicionado tratamento para ignorar a rotina de acesso concorrente quando a sessão estiver com dados incoerentes por qualquer motivo.

[TREE_3_0_73]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.73
[CHANGES_3_0_73]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.72...3.0.73

## [3.0.72][TREE_3_0_72]
[Full Changelog][CHANGES_3_0_72]

**Fixed bugs**
- Correção no tratamento adicionado na versão 3.0.70 gerando erro onde o token é passado na requisição mas já está inválido.

[TREE_3_0_72]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.72
[CHANGES_3_0_72]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.71...3.0.72

## [3.0.71][TREE_3_0_71]
[Full Changelog][CHANGES_3_0_71]

**Fixed bugs**
- Correção no tratamento adicionado na versão 3.0.70 gerando erro em chamadas de php via shell e webservices.

[TREE_3_0_71]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.71
[CHANGES_3_0_71]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.70...3.0.71

## [3.0.70][TREE_3_0_70]
[Full Changelog][CHANGES_3_0_70]

**Fixed bugs**
- Adicionado tratamento para correto funcionamento de conexões que utilizam o modelo VPD (SaaS) em URLs distintas de front e back.

[TREE_3_0_70]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.70
[CHANGES_3_0_70]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.69...3.0.70

## [3.0.69][TREE_3_0_69]
[Full Changelog][CHANGES_3_0_69]

**Improvements**
- Adicionada rota __/acl_zhu_acl_rules__ para ser ignorada na rotina do __Acesso Concorrente__. Em casos específicos, como lentidão na requisição de iniciar a sessão, o momento que essa rota é disparada pode gerar inconsistências nessa rotina.

[TREE_3_0_69]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.69
[CHANGES_3_0_69]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.68...3.0.69

## [3.0.68][TREE_3_0_68]
[Full Changelog][CHANGES_3_0_68]

**Improvements**
- Adicionada possibilidade de passar array de filiais para a função __callLicenseSaveOrgFilial__.
- Alterações no __ReportDecorator__ para qr2 específico (*Rafael Dias*).

[TREE_3_0_68]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.68
[CHANGES_3_0_68]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.67...3.0.68

## [3.0.67][TREE_3_0_67]
[Full Changelog][CHANGES_3_0_67]

**Features**
- Adicionada função estática __callLicenseSaveOrgFilial__ na classe __\Teknisa\Libs\Util\Utilities__ para salvar no banco a __Organização__ e a __Filial__ a ser utilizada na rotina de __Valida Filial__. Essa função chamará um webservice para o __License__ gravar os dados no banco Teknisa.
    - Parâmetro __NRORG__    => Código da Organização.
    - Parâmetro __CDFILIAL__ => Código da Filial.
- Adicionada rota __/lib_saveOrgFilial__ para executar a função __callLicenseSaveOrgFilial__ a partir do frontend, recebendo os parâmetros acima com o tipo __DataSet__.

[TREE_3_0_67]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.67
[CHANGES_3_0_67]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.66...3.0.67

## [3.0.63][TREE_3_0_63]
[Full Changelog][CHANGES_3_0_63]

**Improvements**
- Alteração na __Busca de Município__: primeiramente por __IBGE__, caso contrário por __Nome__ (*Rafael Dias*).

[TREE_3_0_63]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.63
[CHANGES_3_0_63]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.62...3.0.63

## [3.0.62][TREE_3_0_62]
[Full Changelog][CHANGES_3_0_62]

**Improvements**
- Adicionado parâmetro para esconder a versão do banco de dados no about.

[TREE_3_0_62]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.62
[CHANGES_3_0_62]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.61...3.0.62

## [3.0.61][TREE_3_0_61]
[Full Changelog][CHANGES_3_0_61]

**Improvements**
- Adicionada validação do acesso concorrente para operadores de suporte.

[TREE_3_0_61]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.61
[CHANGES_3_0_61]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.59...3.0.61

## [3.0.59][TREE_3_0_59]
[Full Changelog][CHANGES_3_0_59]

**Features**
- Adicionada função de validação da filial para fields do tipo select ou função separada retornando boolean de acordo com parâmetro, para uso da rotina __Valida Filial__ (*Rafael Dias*).

[TREE_3_0_59]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.59
[CHANGES_3_0_59]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.58...3.0.59

## [3.0.56][TREE_3_0_56]
[Full Changelog][CHANGES_3_0_56]

**Improvements**
- Correção do erro que impedia de gravar os dados coletados na rotina de login em ambiente SaaS.

[TREE_3_0_56]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.56
[CHANGES_3_0_56]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.55...3.0.56

## [3.0.55][TREE_3_0_55]
[Full Changelog][CHANGES_3_0_55]

**Improvements**
- Criação das rotinas CRUD do menu __Favoritos__. (*Victor Rezende*)

[TREE_3_0_55]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.55
[CHANGES_3_0_55]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.54...3.0.55

## [3.0.52][TREE_3_0_52]
[Full Changelog][CHANGES_3_0_52]

**Improvements**
- Alteração no __ReportDecorator.php__ para buscar a lista de QR2 do servidor do cliente. Caso algum problema ocorra, o sistema buscará a lista do servidor padrão Teknisa. (*João Corte*)

[TREE_3_0_52]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.52
[CHANGES_3_0_52]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.51...3.0.52

## [3.0.51][TREE_3_0_51]
[Full Changelog][CHANGES_3_0_51]

**Fixed Bugs**
- Correção da língua corrente salva na sessão para utilizar o padrão CamelCase (*pt_BR, en_US*).

[TREE_3_0_51]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.51
[CHANGES_3_0_51]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.50...3.0.51

## [3.0.50][TREE_3_0_50]
[Full Changelog][CHANGES_3_0_50]

**Improvements**
- Adicionada possibilidade de alterar o parâmetro que controla se o usuário é administrador na sessão (__ACL_ADMINISTRATOR__).

[TREE_3_0_50]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.50
[CHANGES_3_0_50]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.49...3.0.50

## [3.0.49][TREE_3_0_49]
[Full Changelog][CHANGES_3_0_49]

**Improvements**
- Adicionados tratamentos para o uso da rotina do __Operador de Suporte__.

[TREE_3_0_49]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.49
[CHANGES_3_0_49]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.48...3.0.49

## [3.0.48][TREE_3_0_48]
[Full Changelog][CHANGES_3_0_48]

**Improvements**
- Adicionada rota para que a função __saveCollectedData__ possa ser chamada pelo frontend.
- Adicionada opção de enviar um __array__ de Ids de coleta para a função __saveCollectedData__.

**Fixed Bugs**
- Atualizado proxy na função __searchCEP__.

[TREE_3_0_48]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.48
[CHANGES_3_0_48]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.47...3.0.48

## [3.0.47][TREE_3_0_47]
[Full Changelog][CHANGES_3_0_47]

**Improvements**
- Adicionada língua corrente na sessão do backend.

[TREE_3_0_47]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.47
[CHANGES_3_0_47]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.46...3.0.47

## [3.0.46][TREE_3_0_46]
[Full Changelog][CHANGES_3_0_46]

**Improvements**
- Alteração na rotina de buscar __CEP__, conforme definido em SEPG (*Rafael Dias*).
    - Nova API (ciacep) como prioridade na busca de CEP.
    - Caso esteja fora do ar, é feita outra tentativa com a antiga (postmon).
    - Caso ambas não funcionem, é feita uma verificação de proxy.
- Adicionada rota __/findPrivacyPolicyByAuthentication__ para ser ignorada na rotina de Acesso Concorrente.

[TREE_3_0_46]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.46
[CHANGES_3_0_46]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.45...3.0.46

## [3.0.45][TREE_3_0_45]
[Full Changelog][CHANGES_3_0_45]

**Improvements**
- Adicionada rota __/setLogAccess/save__ para ser ignorada na rotina de Acesso Concorrente.

[TREE_3_0_45]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.45
[CHANGES_3_0_45]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.44...3.0.45

## [3.0.44][TREE_3_0_44]
[Full Changelog][CHANGES_3_0_44]

**Fixed Bugs**
- Adicionado tratamento na rotina de __SQLWebTunning__ para não gerar erro quando não existir variáveis na sessão do PHP.
    - *Ao executar um arquivo PHP via linha de comando, por exemplo.*

[TREE_3_0_44]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.44
[CHANGES_3_0_44]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.43...3.0.44

## [3.0.43][TREE_3_0_43]
[Full Changelog][CHANGES_3_0_43]
    
**Features**
- Adicionada função estática __getOrganizationAndBranchesIds__ na classe __\Teknisa\Libs\Util\Utilities__ para retornar a relação de filiais relacionadas com as organizações do grupo (Primária + Secundária, se houver, ou somente da Primária).
    - Parâmetro __NRORG__ (*opcional*) => Código da organização. Caso não passado, a organização logada será utilizada.

[TREE_3_0_43]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.43
[CHANGES_3_0_43]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.42...3.0.43

## [3.0.42][TREE_3_0_42]
[Full Changelog][CHANGES_3_0_42]

**Improvements**
- Adicionada verificação se o código da filial está válido na classe __LibsValidations__ (*Gabriel Xavier*).

**Fixed Bugs**
- Correção na rotina __SQLWebTunning__ não enviando o usuário autenticado corretamente.

[TREE_3_0_42]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.42
[CHANGES_3_0_42]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.41...3.0.42

## [3.0.41][TREE_3_0_41]
[Full Changelog][CHANGES_3_0_41]

**Features**
- Adicionada função estática __saveCollectedData__ na classe __\Teknisa\Libs\Util\Utilities__ para gravar os dados de coleta de medidas variáveis.
    - Parâmetro __collectionId__   => ID da coleta (Cod Filial, Cod Operador, Cod da Loja, ...)
    - Parâmetro __operationId__    => ID da operação (Retirada, Cardápio, Login, ...)
    - Parâmetro __productId__      => Código do Produto (*opcional*). Caso não passado, o valor será obtido através do parâmetro *projectId* (O mesmo utilizado para o controle de acesso. ID do produto no DevOps).
    - Parâmetro __operatorCode__   => Código do Operador (*opcional*). Caso não passado, o valor será obtido na sessão.
    - Parâmetro __operatorName__   => Nome do Operador (*opcional*). Caso não passado, o valor será obtido na sessão.
    - Parâmetro __organizationId__ => Código do organização (*opcional*). Caso não passado, o valor será obtido na sessão.

[TREE_3_0_41]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.41
[CHANGES_3_0_41]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.40...3.0.41

## [3.0.40][TREE_3_0_40]
[Full Changelog][CHANGES_3_0_40]

**Improvements**
- Adicionada possibilidade de utilizar a rotina __SQLWebTunning__ sem haver um usuário autenticado.

[TREE_3_0_40]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.40
[CHANGES_3_0_40]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.39...3.0.40

## [3.0.38][TREE_3_0_38]
[Full Changelog][CHANGES_3_0_38]

**Fixed Bugs**
- Adicionado filtro de __NRORG__ na validação do __Acesso Concorrente__.

[TREE_3_0_38]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.38
[CHANGES_3_0_38]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.37...3.0.38

## [3.0.37][TREE_3_0_37]
[Full Changelog][CHANGES_3_0_37]

**Fixed Bugs**
- Correção na classe __LibsValidations__ para que não trate unidades de requisição com o operador __LIKE__ (*Gabriel Xavier*).

[TREE_3_0_37]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.37
[CHANGES_3_0_37]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.36...3.0.37

## [3.0.36][TREE_3_0_36]
[Full Changelog][CHANGES_3_0_36]

**Improvements**
- Correções na classe *LibsValidations* para o PENTEST - GR (*Gabriel Xavier*).

[TREE_3_0_36]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.36
[CHANGES_3_0_36]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.35...3.0.36

## [3.0.35][TREE_3_0_35]
[Full Changelog][CHANGES_3_0_35]

**Improvements**
- Atualizações no __ReportDecorator__ (*Daniel Oliveira*).
    - Adicionada a possibilidade de utilizar uma função para tratar os parâmetros (ou outras possibilidades) antes de chamar a rota para gerar relatórios QR2/BIRT;
    - Reformulação da captura de relatórios QR2, que agora consome uma função da aplicação em Delphi;
    - Automatização do processo de definição do relatório padrão no campo em questão;
    - Adicionada a propriedade *reportIsTheMainFunction* para que o processo de recuperação dos relatórios seja feita apenas na tela de relatório (afeta principalmente telas cuja função primária não é apenas gerar relatórios);
    - Adicionada uma tratativa de erros para facilitar o processo de debug, bem como um retorno mais amigável ao usuário.

[TREE_3_0_35]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.35
[CHANGES_3_0_35]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.34...3.0.35

## [3.0.34][TREE_3_0_34]
[Full Changelog][CHANGES_3_0_34]

**Fixed Bugs**
- Correções na classe __LibValidations__ para o PENTEST - GR (*Willer Santos*).

[TREE_3_0_34]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.34
[CHANGES_3_0_34]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.33...3.0.34

## [3.0.33][TREE_3_0_33]
[Full Changelog][CHANGES_3_0_33]

**Fixed Bugs**
- Mudança no nome do arquivo de __LibValidations__ para __LibsValidations__ (*Douglas Ribeiro*).
- Alteração na função __getBirtReportPath__ para buscar os relatórios na pasta report do respectivo módulo (*Mateus Castro*).

[TREE_3_0_33]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.33
[CHANGES_3_0_33]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.32...3.0.33

## [3.0.32][TREE_3_0_32]
[Full Changelog][CHANGES_3_0_32]

**Improvements**
- Adicionada rotina de validação genérica para requisições contendo NRORG, CDOPERADOR e CDFILIAL provenientes do frontend, referentes às demandas do PENTEST GRSA (*Douglas Ribeiro*).

[TREE_3_0_32]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.32
[CHANGES_3_0_32]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.31...3.0.32

## [3.0.31][TREE_3_0_31]
[Full Changelog][CHANGES_3_0_31]

**Fixed Bugs**
- Adicionado tratamento para que logout em sessões encerradas não gere erro em produtos configurados para o SaaS.

[TREE_3_0_31]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.31
[CHANGES_3_0_31]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.30...3.0.31

## [3.0.30][TREE_3_0_30]
[Full Changelog][CHANGES_3_0_30]

**Improvements**
- Adicionada possibilidade de utilizar o mongo para as validações do acesso concorrente (*Tulio Magalhaes*).
    - *Utilizando o parâmetro __concurrentAccessSaveInMongo__ nas parametrizações do backend*.

[TREE_3_0_30]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.30
[CHANGES_3_0_30]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.29...3.0.30

## [3.0.29][TREE_3_0_29]
[Full Changelog][CHANGES_3_0_29] 

**Fixed Bugs**
- Alterações na classe ReportDecorator para a busca automática dos relatorios (*Mateus Castro*).
- Correção no acesso concorrente utilizando VPD, gerando erro na tela de login.

[TREE_3_0_29]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.29
[CHANGES_3_0_29]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.28...3.0.29

## [3.0.28][TREE_3_0_28]
[Full Changelog][CHANGES_3_0_28]  

**Improvements**
- Adicionada rotina para normalizar a tabela __VERSAOOBJETO__, caso necessário, durante a rotina de verificação da versão atual do banco de dados.

**Fixed Bugs**
- Correção na leitura de XLS para obter o valor calculado quando o conteúdo do campo é uma fórmula (*Rafael Dias*).

[TREE_3_0_28]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.28
[CHANGES_3_0_28]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.27...3.0.28

## [3.0.27][TREE_3_0_27]
[Full Changelog][CHANGES_3_0_27]

**Fixed Bugs**
- Corrigido erro que não redirecionava o usuário para a tela de login em uma aba quando realizava o logout em outra aba.  

[TREE_3_0_27]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.27
[CHANGES_3_0_27]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.26...3.0.27

## [3.0.26][TREE_3_0_26]
[Full Changelog][CHANGES_3_0_26]

**Improvements**
- Remoção da leitura de diretórios de scritps de banco de dados durante a rotina de __Migration__.
- Adicionada rotina para executar scripts de banco de dados muito grandes, que geravam erros de execução no WebSocket.

**Fixed Bugs**
- Retirado __NRORG__ do filtro da busca da versão atual do banco de dados.
    - *Em clientes locais ou hosting, o valor do NRORG é diferente do valor na Teknisa*.
- Adicionadas rotas do login para serem ignoradas na validação do acesso concorrente.
    - *Durante a rotina de login, essa validação é de responsabilidade do módulo de Login*.

[TREE_3_0_26]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.26
[CHANGES_3_0_26]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.25...3.0.26

## [3.0.25][TREE_3_0_25]
[Full Changelog][CHANGES_3_0_25]

**Improvements**
- Alteração no recurso __Report Decorator__, com o intuito de otimizar o processo de busca de relatórios __BIRT__ e __QR2__ (*Mateus Castro*).

[TREE_3_0_25]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.25
[CHANGES_3_0_25]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.24...3.0.25

## [3.0.24][TREE_3_0_24]
[Full Changelog][CHANGES_3_0_24]

**Improvements**
- Adicionados tratamentos para que os dados referentes ao acesso concorrente de outro equipamento não sejam removidos. 

[TREE_3_0_24]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.24
[CHANGES_3_0_24]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.23...3.0.24

## [3.0.23][TREE_3_0_23]
[Full Changelog][CHANGES_3_0_23]

**Improvements**
- Retirada obrigatoriedade de parametrizar o uso da criptografia do php7. Agora, nas versões php7, sempre usará a criptografia referente.

**Fixed Bugs**
- Correção na sessão do token não sendo encerrada após o tempo de vida parametrizado esgotar (*default 2 horas*).

[TREE_3_0_23]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.23
[CHANGES_3_0_23]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.22...3.0.23

## [3.0.22][TREE_3_0_22]
[Full Changelog][CHANGES_3_0_22]

**Fixed Bugs**
- Correção na popup de timeout de sessão não considerando os tratamentos do acesso concorrente.

[TREE_3_0_22]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.22
[CHANGES_3_0_22]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.21...3.0.22

## [3.0.21][TREE_3_0_21]
[Full Changelog][CHANGES_3_0_21]

**Fixed Bugs**
- Correção de compatibilidade com versões anteriores do módulo de login que não utilizam o acesso concorrente.

[TREE_3_0_21]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.21
[CHANGES_3_0_21]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.20...3.0.21

## [3.0.20][TREE_3_0_20]
[Full Changelog][CHANGES_3_0_20]

**Fixed Bugs**
- Desconsiderada rota de inicializar a sessão (*lib_startSession*) para os tratamentos do __acesso concorrente__.

[TREE_3_0_20]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.20
[CHANGES_3_0_20]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.19...3.0.20

## [3.0.19][TREE_3_0_19]
[Full Changelog][CHANGES_3_0_19]

**Features**
- Adicionados tratamentos para bloquear o acesso concorrente (necessário utilizar a versão __3.9__ (php5) ou __4.1__ (php7) do módulo de __Login__).

[TREE_3_0_19]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.19
[CHANGES_3_0_19]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.18...3.0.19

## [3.0.18][TREE_3_0_18]
[Full Changelog][CHANGES_3_0_18]

**Improvements**
- Adicionada chave do __File Server__ na __sessão__ e no retorno da rota __lib_startSession__.
- Adicionada possibilidade de parametrizar o uso da rotina __SQLWEBTUNNING__, com valor padrão em fazer sempre.

[TREE_3_0_18]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.18
[CHANGES_3_0_18]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.17...3.0.18

## [3.0.17][TREE_3_0_17]
[Full Changelog][CHANGES_3_0_17]

**Fixed Bugs**
- Adicionado filtro de __NRORG__ nos registros de __Log__.

[TREE_3_0_17]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.17
[CHANGES_3_0_17]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.16...3.0.17

## [3.0.16][TREE_3_0_16]
[Full Changelog][CHANGES_3_0_16]

**Improvements**
- Adicionado parâmetro __SMTPAuth__, com valor default __true__.

**Fixed Bugs**
- Adicionado tratamento para falhas ao enviar emails.

[TREE_3_0_16]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.16
[CHANGES_3_0_16]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.15...3.0.16

## [3.0.15][TREE_3_0_15]
[Full Changelog][CHANGES_3_0_15]

**Improvements**
- Modificada rotina de geração dos scripts de atualização de estrutura para não retornar mais o conteúdo dos arquivos.
    - *O conteúdo será obtido através dos registros criados pelo __Model Tools__ (https://mt.teknisa.com), na rotina de __Deploy__.*

[TREE_3_0_15]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.14
[CHANGES_3_0_15]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.14...3.0.15

## [3.0.14][TREE_3_0_14]
[Full Changelog][CHANGES_3_0_14]

**Improvements**
- Adicionada versão do banco de dados no __About__ (*Tulio Magalhaes*).

**Fixed Bugs**
- Corrigido erro na rotina de geração dos scripts que retornava scripts já aplicados.

[TREE_3_0_14]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.14
[CHANGES_3_0_14]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.13...3.0.14

## [3.0.13][TREE_3_0_13]
[Full Changelog][CHANGES_3_0_13]

**Fixed Bugs**
- Corrigida atualização da versão da base de dados quando o deploy executa scripts automaticamente.

[TREE_3_0_13]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.13
[CHANGES_3_0_13]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.12...3.0.13

## [3.0.12][TREE_3_0_12]
[Full Changelog][CHANGES_3_0_12]

**Fixed Bugs**
- Alterado parâmetro referente ao perfil selecionado do operador para  utilizar o campo __CDPERFILSELECIONADO__ (*Hector Soares*).

[TREE_3_0_12]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.12
[CHANGES_3_0_12]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.11...3.0.12

## [3.0.11][TREE_3_0_11]
[Full Changelog][CHANGES_3_0_11]

**Fixed Bugs**
- Correção dos parâmetros da função __getNrPerfilSelecionado__ (*Hector Soares*).

[TREE_3_0_11]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.11
[CHANGES_3_0_11]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.10...3.0.11

## [3.0.10][TREE_3_0_10]
[Full Changelog][CHANGES_3_0_10]

**Improvements**
- Adicionados parâmetros referentes ao __Perfil de Acesso por Unidade__ na sessão (*Hector Soares*).

[TREE_3_0_10]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.10
[CHANGES_3_0_10]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.9...3.0.10

## [3.0.9][TREE_3_0_9]
[Full Changelog][CHANGES_3_0_9]

**Fixed Bugs**
- Correção de menus que não possuam __windowName__ não sendo traduzidos. 

[TREE_3_0_9]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.9
[CHANGES_3_0_9]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.8...3.0.9

## [3.0.8][TREE_3_0_8]
[Full Changelog][CHANGES_3_0_8]

**Fixed Bugs**
- Correção na rotina de atualização da referência de último script de banco de dados aplicado na rotina de __Deploy__ via __CP__.

[TREE_3_0_8]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.8
[CHANGES_3_0_8]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.7...3.0.8

## [3.0.7][TREE_3_0_7]
[Full Changelog][CHANGES_3_0_7]

**Fixed Bugs**
- Adicionado tratamento para quebrar corretamente os comandos dos scripts pendentes de atualização do banco de dados (*Lucas Haddad*). 
- Corrigido match de rota para aceitar regexes com '{N}' e modificado o match do que está entre '{}' para o que está entre '##' (*Lucas Haddad*).
    - Pedaço do path (e.g., /rota#\\w+# === /rotaABC123).
    - Path completo (e.g., /rota/#\\w+# === /rota/ABC123).
    - Multiplas regexes no path (e.g., /rota/#\\w+#/pedaço/#\\d{2}# === /rota/ABC123/pedaço/12).

[TREE_3_0_7]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.7
[CHANGES_3_0_7]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.6...3.0.7

## [3.0.6][TREE_3_0_6]
[Full Changelog][CHANGES_3_0_6]

**Improvements**
- Modificado match de rota para utilizar regex dentro de chaves (*Lucas Haddad*).
    - Pedaço do path (e.g., /rota{\\w+} === /rotaABC123).
    - Path completo (e.g., /rota/{\\w+} === /rota/ABC123).

[TREE_3_0_6]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.6
[CHANGES_3_0_6]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.5...3.0.6

## [3.0.5][TREE_3_0_5]
[Full Changelog][CHANGES_3_0_5]

**Improvements**
- Adicionados parâmetros ORGANIZATION_ID e USER_ID na seção para chamadas via webservice.

[TREE_3_0_5]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.5
[CHANGES_3_0_5]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.4...3.0.5

## [3.0.3][TREE_3_0_3]
[Full Changelog][CHANGES_3_0_3]

**Improvements**
- Adicionada possibilidade de anexar anexos ao email através de URLs remotas (*Daniel Oliveira*).

[TREE_3_0_3]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.3
[CHANGES_3_0_3]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.2...3.0.3

## [3.0.2][TREE_3_0_2]
[Full Changelog][CHANGES_3_0_2]

**Fixed Bugs**
- Corrigido uso da dependência do ZhuLog mesmo quando o parâmetro _use_zhu_log_ está como _false_.

[TREE_3_0_2]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.2
[CHANGES_3_0_2]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.1...3.0.2

## [3.0.1][TREE_3_0_1]
[Full Changelog][CHANGES_3_0_1]

**Improvements**
- Atualizada rotina de montagem dinâmica de relatórios para exibir o título correto do relatório na tela e verificar corretamente o nrorg da organização (*Pedro Moutinho*).

[TREE_3_0_1]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.1
[CHANGES_3_0_1]: http://gitlab.teknisa.com/teknisa/libbackend/compare/3.0.0...3.0.1

## [3.0.0][TREE_3_0_0]
[Full Changelog][CHANGES_3_0_0]

**Features**
- Adicionada rotina de autenticação para o Zeedhi Next (*Lucas Haddad*).
- Atualizadas rotas do log para serem compatíveis com versão 4.2.* do ZhuLog.

**Improvements**
- Incrementada dependência do ZhuLog para versão 4.
- Atualização das rotinas para serem compatíveis com PHP 7:
    - Mongo;
    - Criptografia.

[TREE_3_0_0]: http://gitlab.teknisa.com/teknisa/libbackend/tree/3.0.0
[CHANGES_3_0_0]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.9.1...3.0.0

## [2.9.34][TREE_2_9_34]
[Full Changelog][CHANGES_2_9_34]

**Fixed Bugs**
- Adicionado filtro de __NRORG__ na validação do __Acesso Concorrente__.

[TREE_2_9_34]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.9.34
[CHANGES_2_9_34]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.9.33...2.9.34

## [2.9.33][TREE_2_9_33]
[Full Changelog][CHANGES_2_9_33]

**Fixed Bugs**
- Correção na classe __LibsValidations__ para que não trate unidades de requisição com o operador __LIKE__ (*Gabriel Xavier*).

[TREE_2_9_33]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.9.33
[CHANGES_2_9_33]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.9.32...2.9.33

## [2.9.32][TREE_2_9_32]
[Full Changelog][CHANGES_2_9_32]

**Improvements**
- Correções na classe *LibsValidations* para o PENTEST - GR (*Gabriel Xavier*).

[TREE_2_9_32]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.9.32
[CHANGES_2_9_32]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.9.31...2.9.32

## [2.9.31][TREE_2_9_31]
[Full Changelog][CHANGES_2_9_31]

**Improvements**
- Atualizações no __ReportDecorator__ (*Daniel Oliveira*).
    - Adicionada a possibilidade de utilizar uma função para tratar os parâmetros (ou outras possibilidades) antes de chamar a rota para gerar relatórios QR2/BIRT;
    - Reformulação da captura de relatórios QR2, que agora consome uma função da aplicação em Delphi;
    - Automatização do processo de definição do relatório padrão no campo em questão;
    - Adicionada a propriedade *reportIsTheMainFunction* para que o processo de recuperação dos relatórios seja feita apenas na tela de relatório (afeta principalmente telas cuja função primária não é apenas gerar relatórios);
    - Adicionada uma tratativa de erros para facilitar o processo de debug, bem como um retorno mais amigável ao usuário.

[TREE_2_9_31]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.9.31
[CHANGES_2_9_31]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.9.30...2.9.31

## [2.9.30][TREE_2_9_30]
[Full Changelog][CHANGES_2_9_30]

**Fixed Bugs**
- Correções na classe __LibValidations__ para o PENTEST - GR (*Willer Santos*).

[TREE_2_9_30]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.9.30
[CHANGES_2_9_30]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.9.29...2.9.30

## [2.9.29][TREE_2_9_29]
[Full Changelog][CHANGES_2_9_29]

**Fixed Bugs**
- Mudança no nome do arquivo de __LibValidations__ para __LibsValidations__ (*Douglas Ribeiro*).
- Alteração na função __getBirtReportPath__ para buscar os relatórios na pasta report do respectivo módulo (*Mateus Castro*).

[TREE_2_9_29]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.9.29
[CHANGES_2_9_29]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.9.28...2.9.29

## [2.9.28][TREE_2_9_28]
[Full Changelog][CHANGES_2_9_28]

**Improvements**
- Adicionada rotina de validação genérica para requisições contendo NRORG, CDOPERADOR e CDFILIAL provenientes do frontend, referentes às demandas do PENTEST GRSA (*Douglas Ribeiro*).

[TREE_2_9_28]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.9.28
[CHANGES_2_9_28]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.9.27...2.9.28

## [2.9.27][TREE_2_9_27]
[Full Changelog][CHANGES_2_9_27]

**Fixed Bugs**
- Adicionado tratamento para que logout em sessões encerradas não gere erro em produtos configurados para o SaaS.

[TREE_2_9_27]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.9.27
[CHANGES_2_9_27]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.9.26...2.9.27

## [2.9.26][TREE_2_9_26]
[Full Changelog][CHANGES_2_9_26] 

**Fixed Bugs**
- Alterações na classe ReportDecorator para a busca automática dos relatorios (*Mateus Castro*).
- Correção no acesso concorrente utilizando VPD, gerando erro na tela de login.

[TREE_2_9_26]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.9.26
[CHANGES_2_9_26]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.9.25...2.9.26

## [2.9.25][TREE_2_9_25]
[Full Changelog][CHANGES_2_9_25]  

**Improvements**
- Adicionada rotina para normalizar a tabela __VERSAOOBJETO__, caso necessário, durante a rotina de verificação da versão atual do banco de dados.

**Fixed Bugs**
- Correção na leitura de XLS para obter o valor calculado quando o conteúdo do campo é uma fórmula (*Rafael Dias*).

[TREE_2_9_25]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.9.25
[CHANGES_2_9_25]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.9.24...2.9.25

## [2.9.24][TREE_2_9_24]
[Full Changelog][CHANGES_2_9_24]

**Fixed Bugs**
- Corrigido erro que não redirecionava o usuário para a tela de login em uma aba quando realizava o logout em outra aba.  

[TREE_2_9_24]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.9.24
[CHANGES_2_9_24]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.9.23...2.9.24

## [2.9.23][TREE_2_9_23]
[Full Changelog][CHANGES_2_9_23]

**Improvements**
- Remoção da leitura de diretórios de scritps de banco de dados durante a rotina de __Migration__.
- Adicionada rotina para executar scripts de banco de dados muito grandes, que geravam erros de execução no WebSocket.

**Fixed Bugs**
- Retirado __NRORG__ do filtro da busca da versão atual do banco de dados.
    - *Em clientes locais ou hosting, o valor do NRORG é diferente do valor na Teknisa*.
- Adicionadas rotas do login para serem ignoradas na validação do acesso concorrente.
    - *Durante a rotina de login, essa validação é de responsabilidade do módulo de Login*.

[TREE_2_9_23]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.9.23
[CHANGES_2_9_23]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.9.22...2.9.23

## [2.9.22][TREE_2_9_22]
[Full Changelog][CHANGES_2_9_22]

**Improvements**
- Alteração no recurso __Report Decorator__, com o intuito de otimizar o processo de busca de relatórios __BIRT__ e __QR2__ (*Mateus Castro*).

[TREE_2_9_22]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.9.22
[CHANGES_2_9_22]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.9.21...2.9.22

## [2.9.21][TREE_2_9_21]
[Full Changelog][CHANGES_2_9_21]

**Improvements**
- Adicionados tratamentos para que os dados referentes ao acesso concorrente de outro equipamento não sejam removidos. 

[TREE_2_9_21]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.9.21
[CHANGES_2_9_21]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.9.20...2.9.21

## [2.9.20][TREE_2_9_20]
[Full Changelog][CHANGES_2_9_20]

**Fixed Bugs**
- Correção na popup de timeout de sessão não considerando os tratamentos do acesso concorrente.

[TREE_2_9_20]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.9.20
[CHANGES_2_9_20]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.9.19...2.9.20

## [2.9.19][TREE_2_9_19]
[Full Changelog][CHANGES_2_9_19]

**Fixed Bugs**
- Correção de compatibilidade com versões anteriores do módulo de login que não utilizam o acesso concorrente.

[TREE_2_9_19]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.9.19
[CHANGES_2_9_19]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.9.18...2.9.19

## [2.9.18][TREE_2_9_18]
[Full Changelog][CHANGES_2_9_18]

**Fixed Bugs**
- Desconsiderada rota de inicializar a sessão (*lib_startSession*) para os tratamentos do __acesso concorrente__.

[TREE_2_9_18]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.9.18
[CHANGES_2_9_18]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.9.17...2.9.18

## [2.9.17][TREE_2_9_17]
[Full Changelog][CHANGES_2_9_17]

**Features**
- Adicionados tratamentos para bloquear o acesso concorrente (necessário utilizar a versão __3.9__ (php5) ou __4.1__ (php7) do módulo de __Login__).

[TREE_2_9_17]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.9.17
[CHANGES_2_9_17]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.9.16...2.9.17

## [2.9.16][TREE_2_9_16]
[Full Changelog][CHANGES_2_9_16]

**Improvements**
- Adicionada chave do __File Server__ na __sessão__ e no retorno da rota __lib_startSession__.

[TREE_2_9_16]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.9.16
[CHANGES_2_9_16]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.9.15...2.9.16

## [2.9.15][TREE_2_9_15]
[Full Changelog][CHANGES_2_9_15]

**Fixed Bugs**
- Adicionado filtro de __NRORG__ nos registros de __Log__.

[TREE_2_9_15]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.9.15
[CHANGES_2_9_15]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.9.14...2.9.15

## [2.9.14][TREE_2_9_14]
[Full Changelog][CHANGES_2_9_14]

**Improvements**
- Adicionado parâmetro __SMTPAuth__, com valor default __true__.

**Fixed Bugs**
- Adicionado tratamento para falhas ao enviar emails.

[TREE_2_9_14]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.9.14
[CHANGES_2_9_14]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.9.13...2.9.14

## [2.9.13][TREE_2_9_13]
[Full Changelog][CHANGES_2_9_13]

**Improvements**
- Modificada rotina de geração dos scripts de atualização de estrutura para não retornar mais o conteúdo dos arquivos.
    - *O conteúdo será obtido através dos registros criados pelo __Model Tools__ (https://mt.teknisa.com), na rotina de __Deploy__.*

[TREE_2_9_13]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.9.13
[CHANGES_2_9_13]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.9.12...2.9.13

## [2.9.12][TREE_2_9_12]
[Full Changelog][CHANGES_2_9_12]

**Improvements**
- Adicionada versão do banco de dados no __About__ (*Tulio Magalhaes*).

**Fixed Bugs**
- Corrigido erro na rotina de geração dos scripts que retornava scripts já aplicados.

[TREE_2_9_12]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.9.12
[CHANGES_2_9_12]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.9.11...2.9.12

## [2.9.11][TREE_2_9_11]
[Full Changelog][CHANGES_2_9_11]

**Fixed Bugs**
- Corrigida atualização da versão da base de dados quando o deploy executa scripts automaticamente.

[TREE_2_9_11]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.9.11
[CHANGES_2_9_11]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.9.10...2.9.11

## [2.9.10][TREE_2_9_10]
[Full Changelog][CHANGES_2_9_10]

**Fixed Bugs**
- Alterado parâmetro referente ao perfil selecionado do operador para  utilizar o campo __CDPERFILSELECIONADO__ (*Hector Soares*).

[TREE_2_9_10]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.9.10
[CHANGES_2_9_10]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.9.9...2.9.10

## [2.9.9][TREE_2_9_9]
[Full Changelog][CHANGES_2_9_9]

**Fixed Bugs**
- Correção dos parâmetros da função __getNrPerfilSelecionado__ (*Hector Soares*).

[TREE_2_9_9]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.9.9
[CHANGES_2_9_9]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.9.8...2.9.9

## [2.9.8][TREE_2_9_8]
[Full Changelog][CHANGES_2_9_8]

**Improvements**
- Adicionados parâmetros referentes ao __Perfil de Acesso por Unidade__ na sessão (*Hector Soares*).

[TREE_2_9_8]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.9.8
[CHANGES_2_9_8]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.9.7...2.9.8

## [2.9.7][TREE_2_9_7]
[Full Changelog][CHANGES_2_9_7]

**Fixed Bugs**
- Correção de menus que não possuam __windowName__ não sendo traduzidos.

[TREE_2_9_7]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.9.7
[CHANGES_2_9_7]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.9.6...2.9.7

## [2.9.6][TREE_2_9_6]
[Full Changelog][CHANGES_2_9_6]

**Fixed Bugs**
- Correção na rotina de atualização da referência de último script de banco de dados aplicado na rotina de __Deploy__ via __CP__.

[TREE_2_9_6]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.9.6
[CHANGES_2_9_6]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.9.5...2.9.6

## [2.9.5][TREE_2_9_5]
[Full Changelog][CHANGES_2_9_5]

**Improvements**
- Adicionado tratamento para quebrar corretamente os comandos dos scripts pendentes de atualização do banco de dados.

[TREE_2_9_5]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.9.5
[CHANGES_2_9_5]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.9.4...2.9.5

## [2.9.3][TREE_2_9_3]
[Full Changelog][CHANGES_2_9_3]

**Improvements**
- Adicionada possibilidade de anexar anexos ao email através de URLs remotas (*Daniel Oliveira*).

[TREE_2_9_3]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.9.3
[CHANGES_2_9_3]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.9.2...2.9.3

## [2.9.2][TREE_2_9_2]
[Full Changelog][CHANGES_2_9_2]

**Improvements**
- Atualizada rotina de montagem dinâmica de relatórios para exibir o título correto do relatório na tela e verificar corretamente o nrorg da organização (*Pedro Moutinho*).

[TREE_2_9_2]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.9.2
[CHANGES_2_9_2]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.9.1...2.9.2

## [2.9.0][TREE_2_9_0]
[Full Changelog][CHANGES_2_9_0]

**Features**
- Adicionada utilização da rotina SQLWEBTUNNING.

**Improvements**
- Adicionado registro dos arquivos de migration que ainda não constam no diretório.

[TREE_2_9_0]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.9.0
[CHANGES_2_9_0]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.8.0...2.9.0

## [2.8.0][TREE_2_8_0]
[Full Changelog][CHANGES_2_8_0]

**Features**
- Adicionado retorno do campo NRORGOPER na busca das informações do operador.

[TREE_2_8_0]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.8.0
[CHANGES_2_8_0]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.7.5...2.8.0

## [2.7.5][TREE_2_7_5]
[Full Changelog][CHANGES_2_7_5]

**Fixed Bugs**
- Correção na ordenação dos scripts na rotina de migration.

[TREE_2_7_5]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.7.5
[CHANGES_2_7_5]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.7.4...2.7.5

## [2.7.3][TREE_2_7_3]
[Full Changelog][CHANGES_2_7_3]

**Fixed Bugs**
- Correção na quantidade de scripts da rotina de migration, considerando o último executado.

[TREE_2_7_3]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.7.3
[CHANGES_2_7_3]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.7.2...2.7.3

## [2.7.2][TREE_2_7_2]
[Full Changelog][CHANGES_2_7_2]

**Fixed Bugs**
- Correção na quebra de scripts da rotina de migration.

[TREE_2_7_2]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.7.2
[CHANGES_2_7_2]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.7.1...2.7.2

## [2.7.1][TREE_2_7_1]
[Full Changelog][CHANGES_2_7_1]

**Fixed Bugs**
- Correção no retorno dos elementos expirados no momento de inicializar a sessão do usuário.

[TREE_2_7_1]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.7.1
[CHANGES_2_7_1]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.7.0...2.7.1

## [2.7.0][TREE_2_7_0]
[Full Changelog][CHANGES_2_7_0]

**Features**
- Adicionada validação da data de validade do elemento durante a rotina de construir o menu (depende da versão 3.6 ou superior do login).

**Improvements**
- Adicionados parâmetros para configurar porta e protocolo seguro do SMTP.

[TREE_2_7_0]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.7.0
[CHANGES_2_7_0]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.6.2...2.7.0


## [2.6.2][TREE_2_6_2]
[Full Changelog][CHANGES_2_6_2]

**Fixed Bugs**
- Correção na rotina de tradução dos menus não executando para menus de microservices diferentes do atual.

[TREE_2_6_2]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.6.2
[CHANGES_2_6_2]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.6.1...2.6.2


## [2.6.1][TREE_2_6_1]
[Full Changelog][CHANGES_2_6_1]

**Improvements**
- Adicionada opção de utilizar o código HTML da **#** na propriedade *windowName* do menus.

[TREE_2_6_1]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.6.1
[CHANGES_2_6_1]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.6.0...2.6.1


## [2.5.7][TREE_2_5_7]
[Full Changelog][CHANGES_2_5_7]

**Improvements**
- Adição de função para atualizar a sessão corrente do usuário.

**Fixed Bugs**
- Correção na data de último acesso do operador sendo atualizada na base errada quando se utiliza VPD.

[TREE_2_5_7]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.5.7
[CHANGES_2_5_7]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.5.6...2.5.7


## [2.5.6][TREE_2_5_6]
[Full Changelog][CHANGES_2_5_6]

**Fixed Bugs**
- Correção na exceção lançada de token inválido enviando o código do erro errado.

[TREE_2_5_6]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.5.6
[CHANGES_2_5_6]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.5.5...2.5.6


## [2.5.5][TREE_2_5_5]
[Full Changelog][CHANGES_2_5_5]

**Fixed Bugs**
- Correção na leitura dos scripts de migração para aceitar caracteres especiais.

[TREE_2_5_5]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.5.5
[CHANGES_2_5_5]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.5.4...2.5.5


## [2.5.4][TREE_2_5_4]
[Full Changelog][CHANGES_2_5_4]

**Improvements**
- Melhora de performance na rotina de inicializar a sessão do usuário.

[TREE_2_5_4]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.5.4
[CHANGES_2_5_4]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.5.3...2.5.4


## [2.5.3][TREE_2_5_3]
[Full Changelog][CHANGES_2_5_3]

**Fixed Bugs**
- Correção nas variáveis de sessão customizadas (*OTHER_SESSION_VALUES*) não sendo setadas.

[TREE_2_5_3]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.5.3
[CHANGES_2_5_3]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.5.2...2.5.3


## [2.5.1][TREE_2_5_1]
[Full Changelog][CHANGES_2_5_1]

**Improvements**
- Alteração na rotina de redirecionamento após login para utilizar um token para autenticação.

[TREE_2_5_1]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.5.1
[CHANGES_2_5_1]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.5.0...2.5.1


## [2.5.0][TREE_2_5_0]
[Full Changelog][CHANGES_2_5_0]

**Features**
- Adição da rotina de tradução utilizando Translate Management.

**Improvements**
- Adição da tradução dos menus de outros microservices na rota que constrói o menu.

[TREE_2_5_0]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.5.0
[CHANGES_2_5_0]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.4.1...2.5.0


## [2.4.0][TREE_2_4_0]
[Full Changelog][CHANGES_2_4_0]

**Fixed Bugs**
- Correção na validação do padrão dos relatórios customizados.

[TREE_2_4_0]: http://gitlab.teknisa.com/teknisa/libbackend/tree/2.4.0
[CHANGES_2_4_0]: http://gitlab.teknisa.com/teknisa/libbackend/compare/2.3.2...2.4.0