<?php

namespace Teknisa\Libs\Controller;

use Teknisa\Libs\Util\Utilities;
use Zeedhi\Framework\DTO\Request;
use Zeedhi\Framework\DTO\Response;
use Zeedhi\Framework\DTO\Response\Error;
use Zeedhi\Framework\DataSource\DataSet;
use Teknisa\Libs\Service\Version as VersionService;

class Version {
    /** @var  VersionService $versionService */
    private $versionService;

    /** @param VersionService $versionService */
    public function __construct(VersionService $versionService) {
        $this->versionService = $versionService;
    }
    /**
     * @param Request\Filter $request
     * @param Response $response
     */
    public function getVersionInfo(Request\Filter $request, Response $response) {
        try {
            $conditions    = $request->getFilterCriteria()->getConditions();
            $currentModule = Utilities::getValueInFilterDataSourceByName($conditions, 'CURRENT_MODULE');
            $versionInfo   = $this->versionService->getVersionInfo($currentModule);
            $response->addDataSet(new DataSet('versionInfo', $versionInfo));
        } catch(\Exception $e) {
            $response->setError(new Error($e->getMessage(), 500));
        }
    }
}