<?php

namespace Teknisa\Libs\Exception;

use Teknisa\Libs\Util\Messages;

class Login {
    public static function invalidADCredentials() {
        throw new CustomException('ERR_INVALID_AD_CREDENTIALS', 1);
    }

    public static function notConnectAD() {
        throw new CustomException('ERR_CONNECT_AD', 2);
    }

    public static function notUpdatePasswordAD() {
        throw new CustomException('ERR_UPDATE_PASSWORD_AD', 3);
    }

    public static function userNotFoundAD() {
        throw new CustomException('ERR_NOT_FOUND_USER_AD', 4);
    }

    public static function menuConfigNotFound() {
        throw new CustomException('ERR_NOT_FOUND_MENU_CONFIG', 5);
    }

    public static function modulesConfigNotFound() {
        throw new CustomException('ERR_NOT_FOUND_MODULES_CONFIG', 6);
    }

    public static function aclStructNotFound() {
        throw new CustomException('ERR_NOT_FOUND_ACL_STRUCT', 7);
    }

    public static function containersNotFound() {
        throw new CustomException('ERR_NOT_FOUND_CONTAINERS', 8);
    }

    public static function bowerConfigModuleNotFound($bowersNotFound) {
        throw new CustomException('ERR_NOT_FOUND_BOWER_CONFIG', 9, array( 'modules' => $bowersNotFound ));
    }

    public static function moduleParametersNotFound($modulesParametersNotFound) {
        throw new CustomException('ERR_NOT_FOUND_MODULES_PARAMETERS', 10, array( 'modules' => $modulesParametersNotFound ));
    }

    public static function ldapLogonNotPermitedTime() {
        throw new CustomException('LDAP_LOGON_NOT_PERMITED_TIME', 11);
    }

    public static function ldapLogonNotPermitedMachine() {
        throw new CustomException('LDAP_LOGON_NOT_PERMITED_MACHINE', 12);
    }

    public static function ldapPasswordExpired() {
        throw new CustomException('LDAP_PASSWORD_EXPIRED', 13);
    }

    public static function ldapAccountDisabled() {
        throw new CustomException('LDAP_ACCOUNT_DISABLED', 14);
    }

    public static function ldapAccountExpired() {
        throw new CustomException('LDAP_ACCOUNT_EXPIRED', 15);
    }

    public static function ldapAccountLocked() {
        throw new CustomException('LDAP_ACCOUNT_LOCKED', 16);
    }

    public static function ldapUserMustResetPassword() {
        throw new CustomException('LDAP_USER_MUST_RESET_PASSWORD', 17);
    }

    public static function sessionWillBeEnded() {
        throw new CustomException('ALE_SESSION_WILL_BE_ENDED', 20);
    }
    public static function accessBlockedByTimeDay() {
        throw new CustomException('ACCESS_BLOCKED_BY_TIME_OR_DAY', 21);
    }
} 