<?php

namespace Teknisa\Libs\Factory;

use Doctrine\ORM\EntityManager;
use Teknisa\Libs\Util\Utilities;

class Menu {
    
    protected $entityManager;
    protected $connection;
    protected $projectId;

    /**
     * @param EntityManager $entityManager
     */
    public function __construct(EntityManager $entityManager) {
        $this->entityManager = $entityManager;
        $this->connection = $entityManager->getConnection();
        $this->projectId = Utilities::getProjectIdParameter();
    }
    
    public function findFavorites($operator, $nrorg)
    {
        $sql = <<<SQL
                SELECT IDFAVORITOS AS "ID", NMFAVORITOS AS "NAME", DSFAVORITOS AS "LABEL"
                  FROM FAVORITOS
                 WHERE CDOPERADOR = :CDOPERADOR
                   AND NRORG      = :NRORG
                   AND PROJECT_ID = :PROJECT_ID
              ORDER BY NMFAVORITOS
SQL;

        $params = array(
            "CDOPERADOR" => $operator,
            "NRORG"      => $nrorg,
            "PROJECT_ID" => $this->projectId,
        );
        
        return $this->connection->fetchAllAssociative($sql, $params);
    }
    
    public function addFavorites($id, $name, $label, $operator, $nrorg)
    {
        $sql = "INSERT INTO FAVORITOS
                    (IDFAVORITOS, NMFAVORITOS, DSFAVORITOS, CDOPERADOR, NRORG, PROJECT_ID)
                 VALUES 
                    (:IDFAVORITOS, :NMFAVORITOS, :DSFAVORITOS, :CDOPERADOR, :NRORG, :PROJECT_ID)";
        
        $params = array(
            "IDFAVORITOS" => $id,
            "NMFAVORITOS" => $name,
            "DSFAVORITOS" => $label,
            "CDOPERADOR"  => $operator,
            "NRORG"       => $nrorg,
            "PROJECT_ID"  => $this->projectId,
        );
        
        $this->connection->executeQuery($sql, $params);
    }
    
    public function deleteFavorites($id, $operator, $nrorg)
    {
        $sql = "DELETE FROM FAVORITOS
                 WHERE IDFAVORITOS = :IDFAVORITOS 
                   AND CDOPERADOR  = :CDOPERADOR 
                   AND NRORG       = :NRORG
                   AND PROJECT_ID  = :PROJECT_ID";
        
        $params = array(
            "IDFAVORITOS" => $id,
            "CDOPERADOR"  => $operator,
            "NRORG"       => $nrorg,
            "PROJECT_ID"  => $this->projectId,
        );
        
        $this->connection->executeQuery($sql, $params);
    }    
} 