<?php

namespace Teknisa\Libs\Service;

use Teknisa\Libs\Util\Environment;
use Teknisa\Libs\Util\Repositories\Log as LogRepository;
use Teknisa\ACL\Util\InstanceProvider;
use Teknisa\Libs\Util\Utilities;

class Log {
    /** @var LogRepository $logRepository */
    private $logRepository;
    /** @var Environment $environment */
    private $environment;

    public function __construct(LogRepository $logRepository, Environment $environment) {
        $this->logRepository = $logRepository;
        $this->environment = $environment;
    }

    public function logRegister($cdpesqitem, $dsoperacao, $idtipooper, $nmtabela, $dsmetusuoper, $dsnmusuoper, $dsrdmusuoper, $dsendusuoper, $cdOperRespApi = null, $organizationApi = null) {
        $libEnvironment = InstanceProvider::getLibEnvironment();
        $organizationId = $organizationApi ?? $libEnvironment->getCurrentOrganizationId();
        $operatorCurrent = $cdOperRespApi ?? $libEnvironment->getCurrentUserId();
        $findNmResOper = $this->logRepository->findNmResOper($operatorCurrent, $organizationId);
        $nmresoper = empty($findNmResOper) ? '' : $findNmResOper[0]['NMOPERADOR'];
        $productId = Utilities::getProjectIdParameter();
        $this->logRepository->insertLogRegister($cdpesqitem, $dsoperacao, $idtipooper, $nmtabela, $nmresoper, $dsmetusuoper, $dsnmusuoper, $dsrdmusuoper, $dsendusuoper, $organizationId, $operatorCurrent, $productId);
    }
} 