<?php
namespace Teknisa\Libs\Util;

use Symfony\Component\Cache\Adapter\ArrayAdapter;
use Zeedhi\Framework\Cache\Cache;

class ArrayNullCache implements Cache {
    private ArrayAdapter $cache;

    public function __construct() {
        $this->cache = new ArrayAdapter();
    }

    public function save($key, $value, $lifeTime = 0): bool {
        $item = $this->cache->getItem($key);
        $item->set($value);
        if ($lifeTime > 0) {
            $item->expiresAfter($lifeTime);
        }
        return $this->cache->save($item);
    }

    public function fetch($key) {
        $item = $this->cache->getItem($key);
        return $item->isHit() ? $item->get() : null;
    }

    public function delete($key): bool {
        return $this->cache->deleteItem($key);
    }

    public function contains($key): bool {
        return $this->cache->hasItem($key);
    }
}
