<?php

namespace Teknisa\Libs\Util;

use Zeedhi\Framework\DependencyInjection\InstanceManager;

class InstanceProvider {
    /** @return \Teknisa\Libs\Util\Environment */
    public static function getEnvironment()
    {
        return InstanceManager::getInstance()->getService('libEnvironment');
    }

    /** @return \Teknisa\Libs\Util\ConnectionCustom */
    public static function getConnectionCustom()
    {
        return InstanceManager::getInstance()->getService('connectionCustom');
    }

    /** @return \Teknisa\Libs\Service\Migration */
    public static function getMigrationService()
    {
        return InstanceManager::getInstance()->getService('migrationService');
    }

    /** @return \Teknisa\Libs\Util\MongoImplCustom */
    public static function getMongoCache()
    {
        return InstanceManager::getInstance()->getService('mongoCacheImpl');
    }
    
    /** @return \Zeedhi\Framework\DB\Mongo\Mongo */
    public static function getMongoDB()
    {
        return InstanceManager::getInstance()->getService('mongoDB');
    }

    /** @return \Teknisa\Libs\Util\OAuthCustom */
    public static function getOAuthCustom()
    {
        return InstanceManager::getInstance()->getService('oAuthImpl');
    }

    /** @return  \Teknisa\Libs\Util\IntegrationProvider */
    public static function getIntegrationProvider()
    {
        return InstanceManager::getInstance()->getService('integrationProvider');
    }

    /** @return  \Zeedhi\Framework\Session\Session */
    public static function getSession()
    {
        return InstanceManager::getInstance()->getService('session');
    }

    /** @return \Teknisa\Libs\Util\Repositories\UserData */
    public static function getLibUserDataRepository()
    {
        return InstanceManager::getInstance()->getService('libUserDataRepository');
    }

    /** @return \Teknisa\Libs\Util\Repositories\CollectedData */
    public static function getLibCollectedDataRepository()
    {
        return InstanceManager::getInstance()->getService('libCollectedDataRepository');
    }

    /** @return \Teknisa\Libs\Util\Repositories\OAccTekMgr */
    public static function getLibOAccTekMgrRepository()
    {
        return InstanceManager::getInstance()->getService('libOAccTekMgrRepository');
    }

    /** @return \Teknisa\Libs\Util\Repositories\LogAcesso */
    public static function getLibLogAcessoRepository()
    {
        return InstanceManager::getInstance()->getService('libLogAcessoRepository');
    }
    
    /** @return \Doctrine\ORM\EntityManager */
    public static function getEntityManager()
    {
        return InstanceManager::getInstance()->getService('entityManager');
    }

    /** @return \Teknisa\Libs\Util\NewCode */
    public static function getNewCode()
    {
        return InstanceManager::getInstance()->getService('newCode');
    }
}