<?php


namespace Teknisa\Libs\Util\Repositories;

use Teknisa\Libs\Util\Utilities;

class OAccTekMgr
{
    public function getOAccTekMgr($orgId)
    {
        $query = <<<SQL
                  SELECT NRORG AS "NRORG", OACCTEK_PHP7 AS "OACCTEK_PHP7", OACCTEK_PHP7 AS "OACCTEK", 
				  		 RECURRENCE_DAYS AS "RECURRENCE_DAYS", TO_CHAR(DTULTATU, 'DD/MM/YYYY') AS "DTULTATU"
                    FROM OACCTEKMGR
                   WHERE NRORG = :NRORG
                     AND IDATIVO = 'S'
SQL;

        $params = array( 'NRORG' => $orgId );
        return Utilities::getEntityManager()->getConnection()->fetchAllAssociative($query, $params);
    }

    public function insertOAccTekMgr($nrOrg, $cdOperator, $recurrenceDays, $oAccTek) {
		$dateTimeFormat = 'DD/MM/YYYY HH24:MI:SS';
		$query = <<<SQL
                INSERT INTO OACCTEKMGR
                            (NRORG, DTINCLUSAO, DTULTATU, NRORGINCLUSAO, CDOPERINCLUSAO, RECURRENCE_DAYS, OACCTEK_PHP7, OACCTEK)
                     VALUES (:NRORG, TO_DATE(:NOW, '$dateTimeFormat'), TO_DATE(:NOW, '$dateTimeFormat'), :NRORG, :CDOPERADOR, :RECURRENCE_DAYS, :OACCTEK, :OACCTEK)
SQL;

		$params = array(
			'NRORG'           => $nrOrg,
			'CDOPERADOR'      => $cdOperator,
			'RECURRENCE_DAYS' => $recurrenceDays,
			"NOW"     		  => Utilities::getCurrentDateTimeString(),
			'OACCTEK'         => $oAccTek
		);

		return Utilities::getEntityManager()->getConnection()->executeQuery($query, $params);
  }

  public function updateOAccTekMgr($nrOrg, $cdOperator, $recurrenceDays, $oAccTek) {
		$dateTimeFormat = 'DD/MM/YYYY HH24:MI:SS';
		$query = <<<SQL
                UPDATE OACCTEKMGR
                   SET OACCTEK_PHP7 = :OACCTEK,
                       RECURRENCE_DAYS = :RECURRENCE_DAYS,
                       NRORGULTATU = :NRORG,
                       DTULTATU = TO_DATE(:DTULTATU,'$dateTimeFormat'),
                       CDOPERULTATU = :CDOPERADOR
                 WHERE NRORG = :NRORG
SQL;

		$params = array(
			'NRORG'           => $nrOrg,
			'CDOPERADOR'      => $cdOperator,
			'RECURRENCE_DAYS' => $recurrenceDays,
			'DTULTATU'        => Utilities::getCurrentDateTimeString(),
			'OACCTEK'         => $oAccTek
		);

		return Utilities::getEntityManager()->getConnection()->executeQuery($query, $params);
  }
}