<?php

namespace Teknisa\Libs\Controller;

use Zeedhi\Framework\DTO;
use Teknisa\Libs\Service\Notice as NoticeService;


class Notice {
    /** @var  NoticeService $noticeService */
    private $noticeService;

    /** @param NoticeService $noticeService */
    public function __construct(NoticeService $noticeService) {
        $this->noticeService = $noticeService;
    }

    public function readNotification(DTO\Request\Row $request, DTO\Response $response) {
        $row = $request->getRow();
        try {
            $nrinfecommerce = $row['NRINFECOMMERCE'];
            $cdOperador = $row['CDOPERADOR'];
            $this->noticeService->readNotification($nrinfecommerce, $cdOperador);
        } catch (\Exception $e) {
            $response->addMessage(new DTO\Response\Message($e->getMessage(), DTO\Response\Message::TYPE_ERROR));
            $response->setError(new DTO\Response\Error($e->getMessage(), DTO\Response\Message::TYPE_ERROR));
        }
    }

    public function saveUserNoticeSilence(DTO\Request\Row $request, DTO\Response $response) {
        $row = $request->getRow();
        try {
            $this->noticeService->saveUserNoticeSilence($row);
        } catch (\Exception $e) {
            $response->addMessage(new DTO\Response\Message($e->getMessage(), DTO\Response\Message::TYPE_ERROR));
            $response->setError(new DTO\Response\Error($e->getMessage(), DTO\Response\Message::TYPE_ERROR));
        }
    }
}