<?php

namespace Teknisa\Libs\Controller;

use Zeedhi\Framework\DTO\Request;
use Zeedhi\Framework\DTO\Response;
use Zeedhi\Framework\DataSource\DataSet;
use Teknisa\Libs\Service\AccessProfile as AccessProfileService;

class AccessProfile {
    /** @var  AccessProfileService $accessProfileService */
    private $accessProfileService;

    public function __construct(AccessProfileService $accessProfileService) {
        $this->accessProfileService = $accessProfileService;
    }

    /**
     * @param Request\Filter $request
     * @param Response $response
     */
    public function getAccessProfile(Request\Filter $request, Response $response) {
        try {
            $accessProfile = $this->accessProfileService->getAccessProfile();
            $response->addDataSet(new DataSet('system', $accessProfile));
        } catch(\Exception $e) {
            $response->addMessage(new Response\Message($e->getMessage(), Response\Message::TYPE_ERROR));
            $response->setError(new Response\Error($e->getMessage(), Response\Message::TYPE_ERROR));
        }
    }
} 